unit Frame_ServerOfficialTable;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, MainDatastore, DB, DBClient, Provider, IBCustomDataSet, IBQuery,
  StdCtrls, Grids, DBGrids, IBSQL, IBDatabase, DBLocal, DBLocalI,
  DateUtils, Math, DBCtrls, ActnList, Misc_Constants, Misc_Utilities, Base_Frame;

type
  TServerOfficialTableFrame = class(TFrameTemplate)

    Schedule: TIBClientDataSet;
    DataSourceOf_Schedule: TDataSource;

    cboCondition: TComboBox;
    cboProgress: TComboBox;
    txtProfileInfo: TEdit;
    btnSelectProfile: TButton;
    btnLookupProfile: TButton;

    gridTable: TDBGrid;

    btnSelectSchedule: TButton;
    lblCounter: TLabel;
    radShowEnabled: TRadioButton;
    radShowDisabled: TRadioButton;
    btnToggleSchedule: TButton;

    Shortcuts: TActionList;
    Shortcut_LookupProfile: TAction;

    procedure cboSelector_Click(Sender: TObject);

    procedure Schedule_AfterScroll(DataSet: TDataSet);
    procedure btnSelectProfile_Click(Sender: TObject);
    procedure btnLookupProfile_Click(Sender: TObject);

    procedure gridTable_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);

    procedure gridTable_DragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
    procedure gridTable_TitleClick(Column: TColumn);

    procedure radEnabler_Click(Sender: TObject);

    procedure btnSelectSchedule_Click(Sender: TObject);
    procedure btnToggleSchedule_Click(Sender: TObject);
  private
    { Private 錾 }
    FScheduleAt : TDate;
    FObsolete : Boolean;

    sc_typSchedule, sc_intMinutesAt, sc_intMinutesFor : Integer;
    sc_typExchange, sc_curAmountPerCount, sc_curAmountPerHour : Integer;
    sc_typAddressFrom, sc_refAddressFrom, sc_refResidentFrom, sc_strAddressFrom : Integer;
    sc_typAddressTo, sc_refAddressTo, sc_refResidentTo, sc_strAddressTo : Integer;
    sc_refServer, sc_strServerCode, sc_strServerName, sc_strServerRead, sc_strServerPhone, sc_strServerAddress : Integer;
    sc_refRecipient, sc_refClient : Integer;

    function GetServerKey() : Integer;
    function GetServiceMask() : Integer;
    function GetProgressMask() : Integer;
    function GetConditionName() : String;
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;

    property ServerKey : Integer read GetServerKey;
    property ScheduleAt : TDate read FScheduleAt;
    property ServiceMask : Integer read GetServiceMask;
    property ProgressMask : Integer read GetProgressMask;
    property ConditionName : String read GetConditionName;
    property Obsolete : Boolean read FObsolete write FObsolete;

    procedure Reset( newDate : TDate);

    procedure SaveStyleToFile( FileName : String);
    procedure LoadStyleFromFile( FileName : String);
  end;

var
  ServerOfficialTableFrame: TServerOfficialTableFrame;

implementation

{$R *.dfm}

uses Chooser_Server, Set_Server, Set_Care, Set_Menage, Set_Migration, Set_Transfer;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TServerOfficialTableFrame.Create(AOwner: TComponent);
begin
	inherited Create( AOwner);

	FScheduleAt := Today;
	FObsolete := false;

	sc_typSchedule := -1; // see procedure Reset( newDate : TDate);

	SortByDefault( gridTable);
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function TServerOfficialTableFrame.GetServerKey() : Integer;
begin
	if Schedule.IsEmpty then
		result := -1
	else
		result := Schedule.FieldByName( 'refServer').AsInteger;
end;

function TServerOfficialTableFrame.GetServiceMask() : Integer;
begin
	result := aServiceMask[ cboCondition.ItemIndex];
end;

function TServerOfficialTableFrame.GetProgressMask() : Integer;
begin
	result := aProgressMask[ cboProgress.ItemIndex];
end;

function TServerOfficialTableFrame.GetConditionName() : String;
begin
	result := cboCondition.Text;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServerOfficialTableFrame.Reset( newDate : TDate);
var
	Position : TDataSetPosition;
begin
	FScheduleAt := newDate;
	// property update

	DisableGridSet( gridTable, Position);
	Schedule.Close;
	Schedule.Params.ParamByName( 'datSchedule').AsDate := ScheduleAt;
	Schedule.Params.ParamByName( 'optService').AsInteger := ServiceMask;
	Schedule.Params.ParamByName( 'optProgress').AsInteger := ProgressMask;
	Schedule.Open;

	if sc_typSchedule < 0 then
	begin
		sc_typSchedule := Schedule.FieldByName( 'typSchedule').Index;
		sc_intMinutesAt  := Schedule.FieldByName( 'intMinutesAt').Index;
		sc_intMinutesFor := Schedule.FieldByName( 'intMinutesFor').Index;
		sc_typExchange := Schedule.FieldByName( 'typExchange').Index;
		sc_curAmountPerCount := Schedule.FieldByName( 'curAmountPerCount').Index;
		sc_curAmountPerHour := Schedule.FieldByName( 'curAmountPerHour').Index;
		sc_typAddressFrom := Schedule.FieldByName( 'typAddressFrom').Index;
		sc_refAddressFrom := Schedule.FieldByName( 'refAddressFrom').Index;
		sc_refResidentFrom := Schedule.FieldByName( 'refResidentFrom').Index;
		sc_strAddressFrom := Schedule.FieldByName( 'strAddressFrom').Index;
		sc_typAddressTo := Schedule.FieldByName( 'typAddressTo').Index;
		sc_refAddressTo := Schedule.FieldByName( 'refAddressTo').Index;
		sc_refResidentTo := Schedule.FieldByName( 'refResidentTo').Index;
		sc_strAddressTo := Schedule.FieldByName( 'strAddressTo').Index;
                sc_refServer := Schedule.FieldByName( 'refServer').Index;
		sc_strServerCode  := Schedule.FieldByName( 'strServerCode').Index;
		sc_strServerName  := Schedule.FieldByName( 'strServerName').Index;
		sc_strServerRead  := Schedule.FieldByName( 'strServerRead').Index;
		sc_strServerPhone  := Schedule.FieldByName( 'strServerPhone').Index;
		sc_strServerAddress  := Schedule.FieldByName( 'strServerAddress').Index;
		sc_refClient := Schedule.FieldByName( 'refClient').Index;
		sc_refRecipient := Schedule.FieldByName( 'refRecipient').Index;
		Schedule_AfterScroll( Schedule);
	end;

	radEnabler_Click( radShowEnabled);
	EnableGridSet( gridTable, Position);
	// Schedule update

	Obsolete := false;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServerOfficialTableFrame.SaveStyleToFile( FileName : String);
begin
	gridTable.Columns.SaveToFile( FileName);
end;

procedure TServerOfficialTableFrame.LoadStyleFromFile( FileName : String);
begin
	gridTable.Columns.LoadFromFile( FileName);
	SortByDefault( gridTable);
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServerOfficialTableFrame.cboSelector_Click(Sender: TObject);
begin
	Reset( ScheduleAt);
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServerOfficialTableFrame.Schedule_AfterScroll(DataSet: TDataSet);
begin
	if Schedule.IsEmpty or Schedule.Fields[ sc_refServer].IsNull then
	begin
		txtProfileInfo.Text := 'XXXXX / 񋟎ҁ@ / Ă傤@߂ / dbԍP / Z';
		btnSelectProfile.Enabled := false;
		btnLookupProfile.Enabled := not Schedule.IsEmpty;
	end
	else with Schedule do
	begin
		txtProfileInfo.Text := Format( '%s / %s / %s / %s / %s', [
			Fields[ sc_strServerCode].AsString,
			Fields[ sc_strServerName].AsString,
			Fields[ sc_strServerRead].AsString,
			Fields[ sc_strServerPhone].AsString,
			Fields[ sc_strServerAddress].AsString
		]);
		btnSelectProfile.Enabled := true;
		btnLookupProfile.Enabled := true;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServerOfficialTableFrame.btnSelectProfile_Click(Sender: TObject);
begin
	TServerSet.Prepare.Select( ServerKey);
end;

procedure TServerOfficialTableFrame.btnLookupProfile_Click(Sender: TObject);
var
	keyServer : Integer;
begin
	if not btnLookupProfile.Enabled then exit;
	if ChooseServer( DataStore.MainTransaction, ScheduleAt, keyServer) then
	begin
		Schedule.Locate( 'refServer', keyServer, []);
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServerOfficialTableFrame.gridTable_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
	strAddressFrom, strAddressTo, strExchange : String;
begin
	if Column.Field.IsNull then
	begin
		gridTable.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, '@');
		exit;
	end;

	with Column do if Field.Index = sc_intMinutesAt then
	begin
		with gridTable.Canvas do case Schedule.Fields[ sc_typSchedule].AsInteger of
		     CARE_SCHEDULE : TextRect( Rect, Rect.Left + 2, Rect.Top + 2, RangeToText( Field.AsInteger, Schedule.Fields[ sc_intMinutesFor].AsInteger));
		   MENAGE_SCHEDULE : TextRect( Rect, Rect.Left + 2, Rect.Top + 2, RangeToText( Field.AsInteger, Schedule.Fields[ sc_intMinutesFor].AsInteger));
		MIGRATION_SCHEDULE : TextRect( Rect, Rect.Left + 2, Rect.Top + 2, MinutesToText( Field.AsInteger));
		 TRANSFER_SCHEDULE : TextRect( Rect, Rect.Left + 2, Rect.Top + 2, MinutesToText( Field.AsInteger));
		end;
		exit;
	end;

	if Column.Field.Index = sc_strAddressTo then with Schedule, gridTable.Canvas do
	begin
		if ( Fields[ sc_typAddressFrom].AsInteger = PROFILE_ADDRESS)
		    and ( Fields[ sc_refResidentFrom].AsInteger = Fields[ sc_refRecipient].AsInteger) then
			strAddressFrom := 'p҂̎'
		else
			strAddressFrom := Fields[ sc_strAddressFrom].AsString;

		if ( Fields[ sc_typAddressTo].AsInteger = PROFILE_ADDRESS)
		    and ( Fields[ sc_refResidentTo].AsInteger = Fields[ sc_refRecipient].AsInteger) then
			strAddressTo := 'p҂̎'
		else
			strAddressTo := Fields[ sc_strAddressTo].AsString;

		case Schedule.Fields[ sc_typSchedule].AsInteger of CARE_SCHEDULE, MENAGE_SCHEDULE :
			TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Format( '%s', [ strAddressFrom]));
		else
			if ( Fields[ sc_typAddressFrom].AsInteger = PROFILE_ADDRESS)
			    and ( Fields[ sc_refResidentFrom].AsInteger = Fields[ sc_refClient].AsInteger) then
				TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Format( '@ %s', [ strAddressTo]))
			else if ( Fields[ sc_typAddressTo].AsInteger = PROFILE_ADDRESS)
			    and ( Fields[ sc_refResidentTo].AsInteger = Fields[ sc_refClient].AsInteger) then
				TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Format( '%s', [ strAddressFrom]))
			else
				TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Format( '@ %s%s', [ strAddressFrom, strAddressTo]));
		end;
		exit;
	end;

	with Column do if Field.Index = sc_typExchange then
	begin
		strExchange := AmountToText(
			Schedule.Fields[ sc_typExchange].AsInteger,
			Schedule.Fields[ sc_curAmountPerCount].AsCurrency,
			Schedule.Fields[ sc_curAmountPerHour].AsCurrency,
			Schedule.Fields[ sc_intMinutesFor].AsInteger
		);
		gridTable.Canvas.TextRect(
			Rect,
			Rect.Right - 2 - gridTable.Canvas.TextWidth( strExchange),
			Rect.Top + 2,
			strExchange
		);
		exit;
	end;

	with Column do if PickList.Count > 0 then
	begin
		gridTable.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, PickList[ Field.AsInteger]);
		exit;
	end;

	gridTable.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Column.Field.AsString);
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServerOfficialTableFrame.gridTable_DragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
begin
	Accept := false;
end;

procedure TServerOfficialTableFrame.gridTable_TitleClick(Column: TColumn);
var
	ACol : Integer;
begin
	if Column.Title.Color = clMenu then exit;

	if Column.FieldName = 'INTMINUTESAT' then Schedule.IndexFieldNames := 'intMinutesAt;intMinutesFor;strService;strAddressToRead;strClientRead';
	if Column.FieldName = 'STRSERVICE' then Schedule.IndexFieldNames := 'strService;intMinutesAt;intMinutesFor;strAddressToRead;strClientRead';
	if Column.FieldName = 'STRADDRESSTO' then Schedule.IndexFieldNames := 'strAddressToRead;intMinutesAt;intMinutesFor;strService;strClientRead';
	if Column.FieldName = 'STRCLIENT' then Schedule.IndexFieldNames := 'strClientRead;intMinutesAt;intMinutesFor;strService;strAddressToRead';
	if Column.FieldName = 'STRSERVER' then Schedule.IndexFieldNames := 'strServerRead;intMinutesAt;intMinutesFor;strService;strAddressToRead;strClientRead';
	if Column.FieldName = 'STRDETAIL' then Schedule.IndexFieldNames := 'strDetail;intMinutesAt;intMinutesFor;strService;strAddressToRead;strClientRead';
	if Column.FieldName = 'STRNOTICE' then Schedule.IndexFieldNames := 'strNotice;intMinutesAt;intMinutesFor;strService;strAddressToRead;strClientRead';

	with gridTable.Columns do for ACol := 0 to Count - 1 do Items[ ACol].Color := clWindow;

	Column.Color := clSorted;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServerOfficialTableFrame.radEnabler_Click(Sender: TObject);
begin
	Schedule.Filter := Format( 'typStatus=%d', [ BoolToInt( radShowDisabled.Checked)]);

	lblCounter.Caption := 'vF' + IntToStr( Schedule.RecordCount) + ' ';

	if radShowEnabled.Checked then
		btnToggleSchedule.Caption := '폜'
	else
		btnToggleSchedule.Caption := '';

	btnSelectSchedule.Enabled := not Schedule.IsEmpty;
	btnToggleSchedule.Enabled := not Schedule.IsEmpty;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServerOfficialTableFrame.btnSelectSchedule_Click(Sender: TObject);
begin
	if Schedule.IsEmpty then exit;
	if radShowEnabled.Checked then
		case Schedule.FieldByName( 'typSchedule').AsInteger of
		     CARE_SCHEDULE : TCareSet.Prepare.Select( Schedule.FieldByName( 'keyInstance').AsInteger);
		   MENAGE_SCHEDULE : TMenageSet.Prepare.Select( Schedule.FieldByName( 'keyInstance').AsInteger);
		MIGRATION_SCHEDULE : TMigrationSet.Prepare.Select( Schedule.FieldByName( 'keyInstance').AsInteger);
		 TRANSFER_SCHEDULE : TTransferSet.Prepare.Select( Schedule.FieldByName( 'keyInstance').AsInteger);
		end
	else
		case Schedule.FieldByName( 'typSchedule').AsInteger of
		     CARE_SCHEDULE : TCareSet.Prepare.Browse( Schedule.FieldByName( 'keyInstance').AsInteger);
		   MENAGE_SCHEDULE : TMenageSet.Prepare.Browse( Schedule.FieldByName( 'keyInstance').AsInteger);
		MIGRATION_SCHEDULE : TMigrationSet.Prepare.Browse( Schedule.FieldByName( 'keyInstance').AsInteger);
		 TRANSFER_SCHEDULE : TTransferSet.Prepare.Browse( Schedule.FieldByName( 'keyInstance').AsInteger);
		end;
end;

procedure TServerOfficialTableFrame.btnToggleSchedule_Click(Sender: TObject);
begin
	if Schedule.IsEmpty then exit;
	if radShowEnabled.Checked then
		case Schedule.FieldByName( 'typSchedule').AsInteger of
		     CARE_SCHEDULE : TCareSet.Prepare.Delete( Schedule.FieldByName( 'keyInstance').AsInteger);
		   MENAGE_SCHEDULE : TMenageSet.Prepare.Delete( Schedule.FieldByName( 'keyInstance').AsInteger);
		MIGRATION_SCHEDULE : TMigrationSet.Prepare.Delete( Schedule.FieldByName( 'keyInstance').AsInteger);
		 TRANSFER_SCHEDULE : TTransferSet.Prepare.Delete( Schedule.FieldByName( 'keyInstance').AsInteger);
		end
	else
		case Schedule.FieldByName( 'typSchedule').AsInteger of
		     CARE_SCHEDULE : TCareSet.Prepare.Restore( Schedule.FieldByName( 'keyInstance').AsInteger);
		   MENAGE_SCHEDULE : TMenageSet.Prepare.Restore( Schedule.FieldByName( 'keyInstance').AsInteger);
		MIGRATION_SCHEDULE : TMigrationSet.Prepare.Restore( Schedule.FieldByName( 'keyInstance').AsInteger);
		 TRANSFER_SCHEDULE : TTransferSet.Prepare.Restore( Schedule.FieldByName( 'keyInstance').AsInteger);
		end;
end;

end.
