unit Frame_Servers;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, MainDatastore, StdCtrls, Grids, DBGrids, IBSQL, IBDatabase,
  Provider, DB, DBClient, DBLocal, DBLocalI, DateUtils, Math,
  ActnList, Misc_Constants, Misc_Utilities, Base_Frame;

const
    DAILY_SERVERS = 0;
    MONTHLY_SERVERS = 1;

type
  TServersFrame = class(TFrameTemplate)
    Servers: TIBClientDataSet;
    DataSourceOf_Servers: TDataSource;

    cboCategory: TComboBox;
    btnLookupProfile: TButton;
    gridServers: TDBGrid;
    lblCounter: TLabel;
    btnSelectProfile: TButton;

    Shortcuts: TActionList;
    Shortcut_LookupProfile: TAction;

    procedure cboCategory_Click(Sender: TObject);
    procedure btnSelectProfile_Click(Sender: TObject);
    procedure btnLookupProfile_Click(Sender: TObject);
    procedure gridServers_TitleClick(Column: TColumn);

  private
    { Private 錾 }
    FScheduleAt : TDate;
    FObsolete : Boolean;

    function GetServerKey() : Integer;
    function GetCategory() : Integer;
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;

    property ServerKey : Integer read GetServerKey;
    property ScheduleAt : TDate read FScheduleAt;
    property Category : Integer read GetCategory;
    property Obsolete : Boolean read FObsolete write FObsolete;

    procedure Reset( datAt : TDate);

    procedure Lookup( profileKey : Integer);

    procedure SaveStyleToFile( FileName : String);
    procedure LoadStyleFromFile( FileName : String);
  end;

var
  ServersFrame: TServersFrame;

implementation

{$R *.dfm}

uses Chooser_Server, Set_Server;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TServersFrame.Create(AOwner: TComponent);
begin
	inherited Create( AOwner);

	FScheduleAt := Today;
	FObsolete := false;

	SortByDefault( gridServers);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function TServersFrame.GetServerKey() : Integer;
begin
	if Servers.IsEmpty then
		result := -1
	else
		result := Servers.FieldByName( 'keyInstance').AsInteger;
end;

function TServersFrame.GetCategory() : Integer;
begin
	result := cboCategory.ItemIndex;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServersFrame.Reset( datAt : TDate);
var
	Position : TDataSetPosition;
begin
	FScheduleAt := datAt;
	// property update

	DisableGridSet( gridServers, Position);
	Servers.Close;
	Servers.Params.ParamByName( 'datSchedule').AsDate := ScheduleAt;
	Servers.Params.ParamByName( 'datMonthFirstday').AsDate := StartOfTheMonth( ScheduleAt);
	Servers.Params.ParamByName( 'datMonthLastday').AsDate := EndOfTheMonth( ScheduleAt);
	Servers.Open;
	cboCategory_Click( cboCategory);
	EnableGridSet( gridServers, Position);
	// Servers update

	Obsolete := false;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServersFrame.Lookup( profileKey : Integer);
begin
	Servers.Locate( 'keyInstance', profileKey, []);
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServersFrame.SaveStyleToFile( FileName : String);
begin
	gridServers.Columns.SaveToFile( FileName);
end;

procedure TServersFrame.LoadStyleFromFile( FileName : String);
begin
	gridServers.Columns.LoadFromFile( FileName);
	SortByDefault( gridServers);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServersFrame.cboCategory_Click(Sender: TObject);
begin
	Servers.Filter := Format( 'typCategory=%d', [ Category]);
	lblCounter.Caption := 'vF' + IntToStr( Servers.RecordCount) + ' l';

	btnLookupProfile.Enabled := not Servers.IsEmpty;
	btnSelectProfile.Enabled := btnLookupProfile.Enabled;
end;

procedure TServersFrame.btnSelectProfile_Click(Sender: TObject);
begin
	TServerSet.Prepare.Select( ServerKey);
end;

procedure TServersFrame.btnLookupProfile_Click(Sender: TObject);
var
	keyServer : Integer;
begin
	if not btnLookupProfile.Enabled then exit;
	if ChooseServer( DataStore.MainTransaction, ScheduleAt, keyServer) then
	begin
		Lookup( keyServer);
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServersFrame.gridServers_TitleClick(Column: TColumn);
var
	ACol : Integer;
begin
	if Column.Title.Color = clMenu then exit;

	if Column.FieldName = 'STRCODE' then Servers.IndexFieldNames := 'strCode;strNameRead;strName;keyInstance';
	if Column.FieldName = 'STRNAMEREAD' then Servers.IndexFieldNames := 'strNameRead;strName;keyInstance';
	if Column.FieldName = 'STRBRANCH' then Servers.IndexFieldNames := 'strBranch;strNameRead;strName;keyInstance';
	if Column.FieldName = 'STRREGION' then Servers.IndexFieldNames := 'strRegion;strNameRead;strName;keyInstance';
	if Column.FieldName = 'STRADDRESS' then Servers.IndexFieldNames := 'strAddressRead;strNameRead;strName;keyInstance';
	if Column.FieldName = 'STRPHONENUMBER1' then Servers.IndexFieldNames := 'strPhoneNumber1;strNameRead;strName;keyInstance';
	if Column.FieldName = 'STRAVAILABILITY' then Servers.IndexFieldNames := 'strAvailability;strNameRead;strName;keyInstance';

	with gridServers.Columns do for ACol := 0 to Count - 1 do Items[ ACol].Color := clWindow;

	Column.Color := clSorted;
end;

end.
