unit ThumbnailLibCtl_TLB;

// ************************************************************************ //
//  x                                                                      
// ------                                                                     
// ̃t@CŒ`Ă^錾̓^CvCuǂݏo       //
// lɍ쐬Ă܂B^CvCuGfB^ōƒ [\[       //
// XR[h̍XV] {^ƂCق̃^CvCu       //
// ܂͊Ԑڂɂ̃^CvCuQƂĂꍇɁC̃t@C       //
// ̓^CvCu̒lɍĐ܂B                             //
// ̏ꍇC̃t@Cgɑ΂ύX͎Ă܂܂B             //
// ************************************************************************ //

// PASTLWTR : $Revision:   1.130.1.0.1.0.1.6  $
// ̃t@C͈ȉ̃^CvCu 2004/03/03 17:59:12 ɐ܂B

// ************************************************************************ //
// Type Lib: C:\WINNT\system32\ImgThumb.ocx (1)
// LIBID: {E1A6B8A3-3603-101C-AC6E-040224009C02}
// LCID: 0
// Helpfile: C:\WINNT\Help\imgocxd.hlp
// DepndLst: 
//   (1) v2.0 stdole, (C:\WINNT\System32\stdole2.tlb)
//   (2) v4.0 StdVCL, (C:\WINNT\System32\stdvcl40.dll)
// ************************************************************************ //
{$TYPEDADDRESS OFF} // ^t @ Zq̎wOKv܂B
{$WARN SYMBOL_PLATFORM OFF}
{$WRITEABLECONST ON}
{$VARPROPSETTER ON}
interface

uses Windows, ActiveX, Classes, DBOleCtl, Graphics, OleCtrls, OleServer, StdVCL, 
Variants;
  

// *********************************************************************//
// ^CvCu GUID ̒`Bȉ̋Kg܂B             
//   Type Libraries     : LIBID_xxxx                                      
//   CoClasses          : CLASS_xxxx                                      
//   DISPInterfaces     : DIID_xxxx                                       
//   Non-DISP interfaces: IID_xxxx                                        
// *********************************************************************//
const
  // ^CvCũW[/}Ci[o[Wԍ
  ThumbnailLibCtlMajorVersion = 1;
  ThumbnailLibCtlMinorVersion = 0;

  LIBID_ThumbnailLibCtl: TGUID = '{E1A6B8A3-3603-101C-AC6E-040224009C02}';

  DIID__DImgThumbnail: TGUID = '{E1A6B8A1-3603-101C-AC6E-040224009C02}';
  DIID__DImgThumbnailEvents: TGUID = '{E1A6B8A2-3603-101C-AC6E-040224009C02}';
  CLASS_ImgThumbnail: TGUID = '{E1A6B8A0-3603-101C-AC6E-040224009C02}';

// *********************************************************************//
// Declaration of Enumerations defined in Type Library                    
// *********************************************************************//
// enum ScrollConstants ̂߂̒萔
type
  ScrollConstants = TOleEnum;
const
  Horizontal = $00000000;
  Vertical = $00000001;

// enum CaptionStyleConstants ̂߂̒萔
type
  CaptionStyleConstants = TOleEnum;
const
  NoCaption = $00000000;
  SimpleNoAnno = $00000001;
  SimpleWithAnno = $00000002;
  CaptionNoAnno = $00000003;
  CaptionWithAnno = $00000004;

// enum MousePointerConstants ̂߂̒萔
type
  MousePointerConstants = TOleEnum;
const
  Default = $00000000;
  Arrow = $00000001;
  Cross = $00000002;
  IBeam = $00000003;
  Icon = $00000004;
  wSize = $00000005;
  SizeNESW = $00000006;
  SizeNS = $00000007;
  SizeNWSE = $00000008;
  SizeWE = $00000009;
  UpArrow = $0000000A;
  Hourglass = $0000000B;
  NoDrop = $0000000C;
  ArrowAndHourglass = $0000000D;
  ArrowAndQuestion = $0000000E;
  SizeAll = $0000000F;
  Custom = $00000063;

// enum EnableDragDropConstants ̂߂̒萔
type
  EnableDragDropConstants = TOleEnum;
const
  NoDragDrop = $00000000;
  DragLeft = $00000001;
  DragRight = $00000002;
  DragLeftRight = $00000003;
  Drop = $00000004;
  DropDragLeft = $00000005;
  DropDragRight = $00000006;
  DropDragLeftRight = $00000007;
  DropFiles = $00000008;
  DropFilesDragLeft = $00000009;
  DropFilesDragRight = $0000000A;
  DropFilesDragLeftRight = $0000000B;
  DropFilesDrop = $0000000C;
  DropFilesDropDragLeft = $0000000D;
  DropFilesDropDragRight = $0000000E;
  DropFilesDropDragLeftRight = $0000000F;

type

// *********************************************************************//
// ^CvCǔ^錾̂߂ forward 錾                          
// *********************************************************************//
  _DImgThumbnail = dispinterface;
  _DImgThumbnailEvents = dispinterface;

// *********************************************************************//
// Declaration of CoClasses defined in Type Library                       
// (NOTE: Here we map each CoClass to its Default Interface)              
// *********************************************************************//
  ImgThumbnail = _DImgThumbnail;


// *********************************************************************//
// Declaration of structures, unions and aliases.                         
// *********************************************************************//
  PWideString1 = ^WideString; {*}
  PWordBool1 = ^WordBool; {*}
  PSmallint1 = ^Smallint; {*}


// *********************************************************************//
// DispIntf:  _DImgThumbnail
// Flags:     (4096) Dispatchable
// GUID:      {E1A6B8A1-3603-101C-AC6E-040224009C02}
// *********************************************************************//
  _DImgThumbnail = dispinterface
    ['{E1A6B8A1-3603-101C-AC6E-040224009C02}']
    property ThumbCaptionFont: IFontDisp dispid 7;
    property LastSelectedThumb: Integer dispid 11;
    property ThumbHeight: Integer dispid 3;
    property ThumbCount: Integer dispid 1;
    property ThumbWidth: Integer dispid 2;
    property ThumbCaption: WideString dispid 12;
    property FirstSelectedThumb: Integer dispid 10;
    procedure Refresh; dispid -550;
    property SelectedThumbCount: Integer dispid 9;
    property HighlightColor: OLE_COLOR dispid 13;
    property HighlightSelectedThumbs: WordBool dispid 8;
    property ThumbCaptionColor: OLE_COLOR dispid 6;
    property StatusCode: Integer dispid 15;
    property MouseIcon: IPictureDisp dispid 18;
    property ThumbBackColor: OLE_COLOR dispid 14;
    property Image: WideString dispid 16;
    property MousePointer: MousePointerConstants dispid 17;
    property Enabled: WordBool dispid -514;
    property ScrollDirection: ScrollConstants dispid 4;
    property ThumbCaptionStyle: CaptionStyleConstants dispid 5;
    property BorderStyle: Smallint dispid -504;
    property hWnd: OLE_HANDLE dispid -515;
    property BackColor: OLE_COLOR dispid -501;
    property AutoSelect: WordBool dispid 1001;
    property DropFailed: WordBool dispid 1002;
    property EnableDragDrop: EnableDragDropConstants dispid 1000;
    procedure DeselectAllThumbs; dispid 102;
    function GetMinimumSize(ThumbCount: Integer; ScrollBar: WordBool): Integer; dispid 103;
    procedure DeleteThumbs(DeleteAt: Integer; DeleteCount: OleVariant); dispid 107;
    procedure ClearThumbs(PageNumber: OleVariant); dispid 105;
    procedure InsertThumbs(InsertBeforeThumb: OleVariant; InsertCount: OleVariant); dispid 106;
    function GetMaximumSize(ThumbCount: Integer; ScrollBar: WordBool): Integer; dispid 104;
    procedure DisplayThumbs(ThumbNumber: OleVariant; Option: OleVariant); dispid 108;
    procedure GenerateThumb(Option: Smallint; PageNumber: OleVariant); dispid 109;
    procedure SelectAllThumbs; dispid 101;
    function UISetThumbSize(Image: OleVariant; Page: OleVariant): WordBool; dispid 111;
    function GetScrollDirectionSize(ScrollDirectionThumbCount: Integer; 
                                    NonScrollDirectionThumbCount: Integer; 
                                    NonScrollDirectionSize: Integer; ScrollBar: WordBool): Integer; dispid 112;
    function ScrollThumbs(Direction: Smallint; Amount: Smallint): WordBool; dispid 110;
    function GetThumbPositionX(ThumbNumber: Integer): Integer; dispid 113;
    function GetThumbPositionY(ThumbNumber: Integer): Integer; dispid 114;
    property ThumbDropNames[PageNumber: Integer]: WideString readonly dispid 1500;
    property ThumbSelected[PageNumber: Integer]: WordBool dispid 200;
    function GetVersion: WideString; dispid 115;
    property ThumbDropPages[PageNumber: Integer]: Integer readonly dispid 1501;
    procedure AboutBox; dispid -552;
    property ReadyState: Integer readonly dispid -525;
    property DataField: WideString dispid 1003;
    property FirstDisplayedThumb: Integer dispid 19;
    property LastDisplayedThumb: Integer dispid 20;
  end;

// *********************************************************************//
// DispIntf:  _DImgThumbnailEvents
// Flags:     (4096) Dispatchable
// GUID:      {E1A6B8A2-3603-101C-AC6E-040224009C02}
// *********************************************************************//
  _DImgThumbnailEvents = dispinterface
    ['{E1A6B8A2-3603-101C-AC6E-040224009C02}']
    procedure Click(ThumbNumber: Integer); dispid 1;
    procedure DblClick(ThumbNumber: Integer); dispid 2;
    procedure MouseDown(Button: Smallint; Shift: Smallint; x: OLE_XPOS_PIXELS; y: OLE_YPOS_PIXELS; 
                        ThumbNumber: Integer); dispid 3;
    procedure MouseUp(Button: Smallint; Shift: Smallint; x: OLE_XPOS_PIXELS; y: OLE_YPOS_PIXELS; 
                      ThumbNumber: Integer); dispid 4;
    procedure MouseMove(Button: Smallint; Shift: Smallint; x: OLE_XPOS_PIXELS; y: OLE_YPOS_PIXELS; 
                        ThumbNumber: Integer); dispid 5;
    procedure ThumbDrop(InsertBefore: Integer; DropCount: Integer; Shift: Smallint); dispid 500;
    procedure ThumbDrag(DragCount: Integer; Shift: Smallint); dispid 501;
    procedure Error(Number: Smallint; var Description: WideString; Scode: Integer; 
                    const Source: WideString; const HelpFile: WideString; HelpContext: Integer; 
                    var CancelDisplay: WordBool); dispid -608;
    procedure KeyDown(var KeyCode: Smallint; Shift: Smallint); dispid -602;
    procedure KeyUp(var KeyCode: Smallint; Shift: Smallint); dispid -604;
    procedure ReadyStateChange(ReadyState: Integer); dispid -609;
  end;


// *********************************************************************//
// OLE Control Proxy class declaration
// Control Name     : TImgThumbnail
// Help String      : Kodak Image Thumbnail Control
// Default Interface: _DImgThumbnail
// Def. Intf. DISP? : Yes
// Event   Interface: _DImgThumbnailEvents
// TypeFlags        : (34) CanCreate Control
// *********************************************************************//
  TImgThumbnailClick = procedure(Sender: TObject; ThumbNumber: Integer) of object;
  TImgThumbnailDblClick = procedure(Sender: TObject; ThumbNumber: Integer) of object;
  TImgThumbnailMouseDown = procedure(Sender: TObject; Button: Smallint; Shift: Smallint; 
                                                      x: OLE_XPOS_PIXELS; y: OLE_YPOS_PIXELS; 
                                                      ThumbNumber: Integer) of object;
  TImgThumbnailMouseUp = procedure(Sender: TObject; Button: Smallint; Shift: Smallint; 
                                                    x: OLE_XPOS_PIXELS; y: OLE_YPOS_PIXELS; 
                                                    ThumbNumber: Integer) of object;
  TImgThumbnailMouseMove = procedure(Sender: TObject; Button: Smallint; Shift: Smallint; 
                                                      x: OLE_XPOS_PIXELS; y: OLE_YPOS_PIXELS; 
                                                      ThumbNumber: Integer) of object;
  TImgThumbnailThumbDrop = procedure(Sender: TObject; InsertBefore: Integer; DropCount: Integer; 
                                                      Shift: Smallint) of object;
  TImgThumbnailThumbDrag = procedure(Sender: TObject; DragCount: Integer; Shift: Smallint) of object;
  TImgThumbnailError = procedure(Sender: TObject; Number: Smallint; var Description: WideString; 
                                                  Scode: Integer; const Source: WideString; 
                                                  const HelpFile: WideString; HelpContext: Integer; 
                                                  var CancelDisplay: WordBool) of object;
  TImgThumbnailReadyStateChange = procedure(Sender: TObject; ReadyState: Integer) of object;

  TImgThumbnail = class(TDBOleControl)
  private
    FOnClick: TImgThumbnailClick;
    FOnDblClick: TImgThumbnailDblClick;
    FOnMouseDown: TImgThumbnailMouseDown;
    FOnMouseUp: TImgThumbnailMouseUp;
    FOnMouseMove: TImgThumbnailMouseMove;
    FOnThumbDrop: TImgThumbnailThumbDrop;
    FOnThumbDrag: TImgThumbnailThumbDrag;
    FOnError: TImgThumbnailError;
    FOnReadyStateChange: TImgThumbnailReadyStateChange;
    FIntf: _DImgThumbnail;
    function  GetControlInterface: _DImgThumbnail;
  protected
    procedure CreateControl;
    procedure InitControlData; override;
    function Get_ThumbDropNames(PageNumber: Integer): WideString;
    function Get_ThumbSelected(PageNumber: Integer): WordBool;
    procedure Set_ThumbSelected(PageNumber: Integer; Param2: WordBool);
    function Get_ThumbDropPages(PageNumber: Integer): Integer;
  public
    procedure Refresh;
    procedure DeselectAllThumbs;
    function GetMinimumSize(ThumbCount: Integer; ScrollBar: WordBool): Integer;
    procedure DeleteThumbs(DeleteAt: Integer); overload;
    procedure DeleteThumbs(DeleteAt: Integer; DeleteCount: OleVariant); overload;
    procedure ClearThumbs; overload;
    procedure ClearThumbs(PageNumber: OleVariant); overload;
    procedure InsertThumbs; overload;
    procedure InsertThumbs(InsertBeforeThumb: OleVariant); overload;
    procedure InsertThumbs(InsertBeforeThumb: OleVariant; InsertCount: OleVariant); overload;
    function GetMaximumSize(ThumbCount: Integer; ScrollBar: WordBool): Integer;
    procedure DisplayThumbs; overload;
    procedure DisplayThumbs(ThumbNumber: OleVariant); overload;
    procedure DisplayThumbs(ThumbNumber: OleVariant; Option: OleVariant); overload;
    procedure GenerateThumb(Option: Smallint); overload;
    procedure GenerateThumb(Option: Smallint; PageNumber: OleVariant); overload;
    procedure SelectAllThumbs;
    function UISetThumbSize: WordBool; overload;
    function UISetThumbSize(Image: OleVariant): WordBool; overload;
    function UISetThumbSize(Image: OleVariant; Page: OleVariant): WordBool; overload;
    function GetScrollDirectionSize(ScrollDirectionThumbCount: Integer; 
                                    NonScrollDirectionThumbCount: Integer; 
                                    NonScrollDirectionSize: Integer; ScrollBar: WordBool): Integer;
    function ScrollThumbs(Direction: Smallint; Amount: Smallint): WordBool;
    function GetThumbPositionX(ThumbNumber: Integer): Integer;
    function GetThumbPositionY(ThumbNumber: Integer): Integer;
    function GetVersion: WideString;
    procedure AboutBox;
    property  ControlInterface: _DImgThumbnail read GetControlInterface;
    property  DefaultInterface: _DImgThumbnail read GetControlInterface;
    property ThumbDropNames[PageNumber: Integer]: WideString read Get_ThumbDropNames;
    property ThumbSelected[PageNumber: Integer]: WordBool read Get_ThumbSelected write Set_ThumbSelected;
    property ThumbDropPages[PageNumber: Integer]: Integer read Get_ThumbDropPages;
    property ReadyState: Integer index -525 read GetIntegerProp;
    property FirstDisplayedThumb: Integer index 19 read GetIntegerProp write SetIntegerProp;
    property LastDisplayedThumb: Integer index 20 read GetIntegerProp write SetIntegerProp;
  published
    property  ParentColor;
    property  TabStop;
    property  Align;
    property  DragCursor;
    property  DragMode;
    property  ParentShowHint;
    property  PopupMenu;
    property  ShowHint;
    property  TabOrder;
    property  Visible;
    property  OnDragDrop;
    property  OnDragOver;
    property  OnEndDrag;
    property  OnEnter;
    property  OnExit;
    property  OnStartDrag;
    property  OnKeyUp;
    property  OnKeyDown;
    property ThumbCaptionFont: TFont index 7 read GetTFontProp write SetTFontProp stored False;
    property LastSelectedThumb: Integer index 11 read GetIntegerProp write SetIntegerProp stored False;
    property ThumbHeight: Integer index 3 read GetIntegerProp write SetIntegerProp stored False;
    property ThumbCount: Integer index 1 read GetIntegerProp write SetIntegerProp stored False;
    property ThumbWidth: Integer index 2 read GetIntegerProp write SetIntegerProp stored False;
    property ThumbCaption: WideString index 12 read GetWideStringProp write SetWideStringProp stored False;
    property FirstSelectedThumb: Integer index 10 read GetIntegerProp write SetIntegerProp stored False;
    property SelectedThumbCount: Integer index 9 read GetIntegerProp write SetIntegerProp stored False;
    property HighlightColor: TColor index 13 read GetTColorProp write SetTColorProp stored False;
    property HighlightSelectedThumbs: WordBool index 8 read GetWordBoolProp write SetWordBoolProp stored False;
    property ThumbCaptionColor: TColor index 6 read GetTColorProp write SetTColorProp stored False;
    property StatusCode: Integer index 15 read GetIntegerProp write SetIntegerProp stored False;
    property MouseIcon: TPicture index 18 read GetTPictureProp write SetTPictureProp stored False;
    property ThumbBackColor: TColor index 14 read GetTColorProp write SetTColorProp stored False;
    property Image: WideString index 16 read GetWideStringProp write SetWideStringProp stored False;
    property MousePointer: TOleEnum index 17 read GetTOleEnumProp write SetTOleEnumProp stored False;
    property Enabled: WordBool index -514 read GetWordBoolProp write SetWordBoolProp stored False;
    property ScrollDirection: TOleEnum index 4 read GetTOleEnumProp write SetTOleEnumProp stored False;
    property ThumbCaptionStyle: TOleEnum index 5 read GetTOleEnumProp write SetTOleEnumProp stored False;
    property BorderStyle: Smallint index -504 read GetSmallintProp write SetSmallintProp stored False;
    property hWnd: Integer index -515 read GetIntegerProp write SetIntegerProp stored False;
    property BackColor: TColor index -501 read GetTColorProp write SetTColorProp stored False;
    property AutoSelect: WordBool index 1001 read GetWordBoolProp write SetWordBoolProp stored False;
    property DropFailed: WordBool index 1002 read GetWordBoolProp write SetWordBoolProp stored False;
    property EnableDragDrop: TOleEnum index 1000 read GetTOleEnumProp write SetTOleEnumProp stored False;
    property DataField: WideString index 1003 read GetWideStringProp write SetWideStringProp stored False;
    property OnClick: TImgThumbnailClick read FOnClick write FOnClick;
    property OnDblClick: TImgThumbnailDblClick read FOnDblClick write FOnDblClick;
    property OnMouseDown: TImgThumbnailMouseDown read FOnMouseDown write FOnMouseDown;
    property OnMouseUp: TImgThumbnailMouseUp read FOnMouseUp write FOnMouseUp;
    property OnMouseMove: TImgThumbnailMouseMove read FOnMouseMove write FOnMouseMove;
    property OnThumbDrop: TImgThumbnailThumbDrop read FOnThumbDrop write FOnThumbDrop;
    property OnThumbDrag: TImgThumbnailThumbDrag read FOnThumbDrag write FOnThumbDrag;
    property OnError: TImgThumbnailError read FOnError write FOnError;
    property OnReadyStateChange: TImgThumbnailReadyStateChange read FOnReadyStateChange write FOnReadyStateChange;
  end;

procedure Register;

resourcestring
  dtlServerPage = 'Imaging';

implementation

uses ComObj;

procedure TImgThumbnail.InitControlData;
const
  CEventDispIDs: array [0..8] of DWORD = (
    $00000001, $00000002, $00000003, $00000004, $00000005, $000001F4,
    $000001F5, $FFFFFDA0, $FFFFFD9F);
  CTFontIDs: array [0..0] of DWORD = (
    $00000007);
  CTPictureIDs: array [0..0] of DWORD = (
    $00000012);
  CControlData: TControlData2 = (
    ClassID: '{E1A6B8A0-3603-101C-AC6E-040224009C02}';
    EventIID: '{E1A6B8A2-3603-101C-AC6E-040224009C02}';
    EventCount: 9;
    EventDispIDs: @CEventDispIDs;
    LicenseKey: nil (*HR:$80004005*);
    Flags: $00000009;
    Version: 401;
    FontCount: 1;
    FontIDs: @CTFontIDs;
    PictureCount: 1;
    PictureIDs: @CTPictureIDs);
begin
  ControlData := @CControlData;
  TControlData2(CControlData).FirstEventOfs := Cardinal(@@FOnClick) - Cardinal(Self);
end;

procedure TImgThumbnail.CreateControl;

  procedure DoCreate;
  begin
    FIntf := IUnknown(OleObject) as _DImgThumbnail;
  end;

begin
  if FIntf = nil then DoCreate;
end;

function TImgThumbnail.GetControlInterface: _DImgThumbnail;
begin
  CreateControl;
  Result := FIntf;
end;

function TImgThumbnail.Get_ThumbDropNames(PageNumber: Integer): WideString;
begin
    Result := DefaultInterface.ThumbDropNames[PageNumber];
end;

function TImgThumbnail.Get_ThumbSelected(PageNumber: Integer): WordBool;
begin
    Result := DefaultInterface.ThumbSelected[PageNumber];
end;

procedure TImgThumbnail.Set_ThumbSelected(PageNumber: Integer; Param2: WordBool);
begin
  Exit;
end;

function TImgThumbnail.Get_ThumbDropPages(PageNumber: Integer): Integer;
begin
    Result := DefaultInterface.ThumbDropPages[PageNumber];
end;

procedure TImgThumbnail.Refresh;
begin
  DefaultInterface.Refresh;
end;

procedure TImgThumbnail.DeselectAllThumbs;
begin
  DefaultInterface.DeselectAllThumbs;
end;

function TImgThumbnail.GetMinimumSize(ThumbCount: Integer; ScrollBar: WordBool): Integer;
begin
  Result := DefaultInterface.GetMinimumSize(ThumbCount, ScrollBar);
end;

procedure TImgThumbnail.DeleteThumbs(DeleteAt: Integer);
begin
  DefaultInterface.DeleteThumbs(DeleteAt, EmptyParam);
end;

procedure TImgThumbnail.DeleteThumbs(DeleteAt: Integer; DeleteCount: OleVariant);
begin
  DefaultInterface.DeleteThumbs(DeleteAt, DeleteCount);
end;

procedure TImgThumbnail.ClearThumbs;
begin
  DefaultInterface.ClearThumbs(EmptyParam);
end;

procedure TImgThumbnail.ClearThumbs(PageNumber: OleVariant);
begin
  DefaultInterface.ClearThumbs(PageNumber);
end;

procedure TImgThumbnail.InsertThumbs;
begin
  DefaultInterface.InsertThumbs(EmptyParam, EmptyParam);
end;

procedure TImgThumbnail.InsertThumbs(InsertBeforeThumb: OleVariant);
begin
  DefaultInterface.InsertThumbs(InsertBeforeThumb, EmptyParam);
end;

procedure TImgThumbnail.InsertThumbs(InsertBeforeThumb: OleVariant; InsertCount: OleVariant);
begin
  DefaultInterface.InsertThumbs(InsertBeforeThumb, InsertCount);
end;

function TImgThumbnail.GetMaximumSize(ThumbCount: Integer; ScrollBar: WordBool): Integer;
begin
  Result := DefaultInterface.GetMaximumSize(ThumbCount, ScrollBar);
end;

procedure TImgThumbnail.DisplayThumbs;
begin
  DefaultInterface.DisplayThumbs(EmptyParam, EmptyParam);
end;

procedure TImgThumbnail.DisplayThumbs(ThumbNumber: OleVariant);
begin
  DefaultInterface.DisplayThumbs(ThumbNumber, EmptyParam);
end;

procedure TImgThumbnail.DisplayThumbs(ThumbNumber: OleVariant; Option: OleVariant);
begin
  DefaultInterface.DisplayThumbs(ThumbNumber, Option);
end;

procedure TImgThumbnail.GenerateThumb(Option: Smallint);
begin
  DefaultInterface.GenerateThumb(Option, EmptyParam);
end;

procedure TImgThumbnail.GenerateThumb(Option: Smallint; PageNumber: OleVariant);
begin
  DefaultInterface.GenerateThumb(Option, PageNumber);
end;

procedure TImgThumbnail.SelectAllThumbs;
begin
  DefaultInterface.SelectAllThumbs;
end;

function TImgThumbnail.UISetThumbSize: WordBool;
begin
  Result := DefaultInterface.UISetThumbSize(EmptyParam, EmptyParam);
end;

function TImgThumbnail.UISetThumbSize(Image: OleVariant): WordBool;
begin
  Result := DefaultInterface.UISetThumbSize(Image, EmptyParam);
end;

function TImgThumbnail.UISetThumbSize(Image: OleVariant; Page: OleVariant): WordBool;
begin
  Result := DefaultInterface.UISetThumbSize(Image, Page);
end;

function TImgThumbnail.GetScrollDirectionSize(ScrollDirectionThumbCount: Integer; 
                                              NonScrollDirectionThumbCount: Integer; 
                                              NonScrollDirectionSize: Integer; ScrollBar: WordBool): Integer;
begin
  Result := DefaultInterface.GetScrollDirectionSize(ScrollDirectionThumbCount, 
                                                    NonScrollDirectionThumbCount, 
                                                    NonScrollDirectionSize, ScrollBar);
end;

function TImgThumbnail.ScrollThumbs(Direction: Smallint; Amount: Smallint): WordBool;
begin
  Result := DefaultInterface.ScrollThumbs(Direction, Amount);
end;

function TImgThumbnail.GetThumbPositionX(ThumbNumber: Integer): Integer;
begin
  Result := DefaultInterface.GetThumbPositionX(ThumbNumber);
end;

function TImgThumbnail.GetThumbPositionY(ThumbNumber: Integer): Integer;
begin
  Result := DefaultInterface.GetThumbPositionY(ThumbNumber);
end;

function TImgThumbnail.GetVersion: WideString;
begin
  Result := DefaultInterface.GetVersion;
end;

procedure TImgThumbnail.AboutBox;
begin
  DefaultInterface.AboutBox;
end;

procedure Register;
begin
  RegisterComponents('Imaging',[TImgThumbnail]);
end;

end.
