unit MainWindow;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ImgList, StdCtrls, ComCtrls, TeeProcs, TeEngine, Chart, ExtCtrls,
  Buttons, Menus, StrUtils, Base_Workspace, ToolWin, DateUtils, ShellApi;

type
  TfmdiMain = class(TForm)
    MainMenu: TMainMenu;

    mnuFile: TMenuItem;
    cmdBackup: TMenuItem;
    cmdRestore: TMenuItem;
    sepFile_1: TMenuItem;
    cmdPurge: TMenuItem;
    sepFile_2: TMenuItem;
    cmdCenter: TMenuItem;
    sepFile_3: TMenuItem;
    cmdZipConfig: TMenuItem;
    sepFile_4: TMenuItem;
    cmdExit: TMenuItem;

    mnuSchedule: TMenuItem;
    cmdClientSchedule: TMenuItem;
    cmdServerSchedule: TMenuItem;

    mnuExchange: TMenuItem;
    cmdTicket: TMenuItem;
    cmdPayback: TMenuItem;
    sepExchange_1: TMenuItem;
    cmdBilling: TMenuItem;
    cmdPayment: TMenuItem;

    mnuProfiles: TMenuItem;
    cmdClients: TMenuItem;
    cmdServers: TMenuItem;

    mnuCatalogue: TMenuItem;
    cmdPlace: TMenuItem;
    sepCatalogue_1: TMenuItem;
    cmdBranch: TMenuItem;
    cmdRegion: TMenuItem;
    sepCatalogue_2: TMenuItem;
    cmdService: TMenuItem;

    mnuReport: TMenuItem;

    mnuWindow: TMenuItem;
    cmdSignboard: TMenuItem;
    sepWindow_1: TMenuItem;
    cmdTileHorizontal: TMenuItem;
    cmdTileVertical: TMenuItem;
    cmdCascadeWindow: TMenuItem;

    mnuHelp: TMenuItem;
    cmdHelpIndex: TMenuItem;
    sepHelp: TMenuItem;
    cmdHelpAbout: TMenuItem;

    Separator: TToolBar;
    BackupDialog: TSaveDialog;
    RestoreDialog: TOpenDialog;

    procedure Form_Create(Sender: TObject);

    procedure Application_Exception(Sender: TObject; E: Exception);

    procedure Menu_Register( _Caption : String; _Handler : TNotifyEvent; _Enabled : Boolean);
    procedure Menu_Initialize(var Msg : TMessage); message WM_INITMENU;

    procedure cmdBackup_Click(Sender: TObject);
    procedure cmdRestore_Click(Sender: TObject);
    procedure cmdPurge_Click(Sender: TObject);
    procedure cmdCenter_Click(Sender: TObject);
    procedure cmdZipConfig_Click(Sender: TObject);
    procedure cmdExit_Click(Sender: TObject);

    procedure cmdClientSchedule_Click(Sender: TObject);
    procedure cmdServerSchedule_Click(Sender: TObject);

    procedure cmdTicket_Click(Sender: TObject);
    procedure cmdPayback_Click(Sender: TObject);
    procedure cmdBilling_Click(Sender: TObject);
    procedure cmdPayment_Click(Sender: TObject);

    procedure cmdClients_Click(Sender: TObject);
    procedure cmdServers_Click(Sender: TObject);

    procedure cmdPlace_Click(Sender: TObject);
    procedure cmdBranch_Click(Sender: TObject);
    procedure cmdRegion_Click(Sender: TObject);
    procedure cmdService_Click(Sender: TObject);

    procedure cmdSignboard_Click(Sender: TObject);
    procedure cmdTileHorizontal_Click(Sender: TObject);
    procedure cmdTileVertical_Click(Sender: TObject);
    procedure cmdCascadeWindow_Click(Sender: TObject);

    procedure cmdHelpAbout_Click(Sender: TObject);
    procedure cmdHelpIndex_Click(Sender: TObject);

  private
    { Private 錾 }
    procedure CreateWorkspace( TWorkspace : CWorkspaceTemplate; Budget : Integer);
  public
    { Public 錾 }
  end;

var
  fmdiMain: TfmdiMain;

implementation

{$R *.dfm}

uses MainDatastore,
	Chooser_Date,
	Set_Center,
	Set_Picture,
	Workspace_ClientSchedule,
	Workspace_ServerSchedule,
	Workspace_Ticket,
	Workspace_Payback,
	Workspace_Billing,
	Workspace_Payment,
	Workspace_Clients,
	Workspace_Servers,
	Workspace_Addresses,
	Workspace_Branches,
	Workspace_Regions,
	Workspace_Services,
	Misc_ZipConfig,
	Misc_Signboard,
	Misc_AboutBox;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TfmdiMain.CreateWorkspace( TWorkspace : CWorkspaceTemplate; Budget : Integer);
var
	Prius : TWorkspaceTemplate;
	Index, Count : Integer;
begin
	Prius := nil;
	Count := 0;
	for Index := 0 to Application.MainForm.MDIChildCount - 1 do
	begin
		if Application.MainForm.MDIChildren[ Index] is TWorkspace then
		begin
			Prius := Application.MainForm.MDIChildren[ Index] as TWorkspace;
			Inc( Count);
		end;
	end;

	if Count < Budget then
		TWorkspace.Create( Application.MainForm)
	else
		if Prius <> nil then Prius.Show;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TfmdiMain.Form_Create(Sender: TObject);
var
	Count : Integer;
begin
	Count := 20;
	while Count > 0 do
	begin
		mnuReport.Add( TMenuItem.Create( Self));
		mnuReport.Items[ mnuReport.Count - 1].Caption := '';
		mnuReport.Items[ mnuReport.Count - 1].OnClick := nil;
		mnuReport.Items[ mnuReport.Count - 1].Visible := false;
		Dec( Count);
	end;

	Count := 20;
	while Count > 0 do
	begin
		mnuWindow.Add( TMenuItem.Create( Self));
		mnuWindow.Items[ mnuWindow.Count - 1].Caption := '';
		mnuWindow.Items[ mnuWindow.Count - 1].OnClick := nil;
		mnuWindow.Items[ mnuWindow.Count - 1].Visible := false;
		mnuWindow.Items[ mnuWindow.Count - 1].GroupIndex := 1;
		Dec( Count);
	end;
end;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TfmdiMain.Application_Exception(Sender: TObject; E: Exception);
begin
	Application.ShowException( E);
	ShowMessage( 'zÕG[܂BŜ߃VXeI܂B');
	Application.Terminate;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TfmdiMain.Menu_Register( _Caption : String; _Handler : TNotifyEvent; _Enabled : Boolean);
begin
	if mnuReport.Tag = mnuReport.Count then
	begin
		mnuReport.Add( TMenuItem.Create( Self));
	end;

	with mnuReport.Items[ mnuReport.Tag] do
	begin
		Caption := _Caption;
		OnClick := _Handler;
		Enabled := _Enabled;
		Visible := true;
	end;

	mnuReport.Tag := mnuReport.Tag + 1;
end;

procedure TfmdiMain.Menu_Initialize(var Msg : TMessage);
var
	Index : Integer;
begin
	mnuReport.Tag := 0;

	if Screen.ActiveForm is TWorkspaceTemplate then
	begin
		( Screen.ActiveForm as TWorkspaceTemplate).Report_MenuSetup( Menu_Register);
	end;

	if mnuReport.Tag = 0 then with mnuReport.Items[ mnuReport.Tag] do
	begin
		Caption := '(\ȃ|[g͂܂)';
		OnClick := nil;
		Enabled := false;
		Visible := true;
		mnuReport.Tag := 1;
	end;

	while mnuReport.Tag < mnuReport.Count do with mnuReport.Items[ mnuReport.Tag] do
	begin
		Caption := '';
		OnClick := nil;
		Visible := false;
		mnuReport.Tag := mnuReport.Tag + 1;
	end;

	if Signboard.Visible then
		cmdSignboard.Caption := 'f(&S)'
	else
		cmdSignboard.Caption := 'fJ(&S)';

	if Application.MainForm.MDIChildCount > 0 then
	begin
		cmdBackup.Enabled := false;
		cmdRestore.Enabled := false;
		cmdPurge.Enabled := false;

		for Index := 2 to mnuWindow.Count - 1 do with mnuWindow.Items[ Index] do
		begin
			Enabled := true;
			Visible := ( GroupIndex = 0);
		end;

		with mnuWindow.Items[ 4] do
		begin
			Caption := '-';
			Visible := true;
		end;

		for Index := 0 to Application.MainForm.MDIChildCount - 1 do with mnuWindow.Items[ 5 + Index] do
		begin
			Caption := Format( '&%d %s', [ Index + 1, Application.MainForm.MDIChildren[ Index].Caption]);
			OnClick := ( Application.MainForm.MDIChildren[ Index] as TWorkspaceTemplate).Form_Required;
			Visible := true;
		end;
	end
	else
	begin
		cmdBackup.Enabled := true;
		cmdRestore.Enabled := true;
		cmdPurge.Enabled := true;

		for Index := 2 to mnuWindow.Count - 1 do with mnuWindow.Items[ Index] do
		begin
			Enabled := false;
			Visible := ( GroupIndex = 0);
		end;
	end;
end;


{*=========================================================*
  @subject: file command
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TfmdiMain.cmdBackup_Click(Sender: TObject);
begin
	if BackupDialog.Execute then
	try
		ShowMessage( 'obNAbv̍쐬Jn܂B');
		Application.Title := 'f[^쐬łB̍Ƃɂ͈ꎞԋ߂|邱Ƃ܂B';
		Application.Minimize;

		DataStore.Backup( BackupDialog.FileName);

		Application.Restore;
		Application.Title := 'VXe';
		ShowMessage( 'obNAbv̍쐬܂B');
	except
		Application.Restore;
		Application.Title := 'VXe';
		ShowMessage( 'obNAbv̍쐬Ɏs܂B');
	end;
end;

procedure TfmdiMain.cmdRestore_Click(Sender: TObject);
begin
	if RestoreDialog.Execute then
	try
		ShowMessage( 'obNAbv̕Jn܂B');
		Application.Title := 'f[^𕜌łB̍Ƃɂ͈ꎞԋ߂|邱Ƃ܂B';
		Application.Minimize;

		DataStore.Restore( RestoreDialog.FileName);

		Application.Restore;
		Application.Title := 'VXe';
		ShowMessage( 'obNAbv̕܂B');
	except
		Application.Restore;
		Application.Title := 'VXe';
		ShowMessage( 'obNAbv̕Ɏs܂B');
	end;
end;

procedure TfmdiMain.cmdPurge_Click(Sender: TObject);
var
	datBoundary : TDate;
	strBoundary : String;
begin
	ShowMessage( '폜f[^̍ŏItIĂB');

	datBoundary := EndOfTheMonth( IncYear( Today, -2));
	if ChooseDate( datBoundary) then
	try
		ShowMessage( 'Âf[^̐؂藣Jn܂B');
		Application.Title := 'f[^폜łB̍Ƃɂ͈ꎞԋ߂|邱Ƃ܂B';
		Application.Minimize;

		strBoundary := DateToStr( datBoundary);
		DataStore.ExecSQL( 'DELETE FROM Ticket WHERE datPublished <= :param1', [ strBoundary]);
		DataStore.ExecSQL( 'DELETE FROM Payback WHERE datPublished <= :param1', [ strBoundary]);
		DataStore.ExecSQL( 'DELETE FROM Billing WHERE datPublished <= :param1', [ strBoundary]);
		DataStore.ExecSQL( 'DELETE FROM Payment WHERE datPublished <= :param1', [ strBoundary]);
		DataStore.ExecSQL( 'UPDATE Schedule SET refPattern = NULL, refSubject = NULL WHERE datSchedule <= :param1', [ strBoundary]);
		DataStore.ExecSQL( 'DELETE FROM Schedule WHERE datSchedule <= :param1', [ strBoundary]);
		DataStore.Commit;

		Application.Restore;
		Application.Title := 'VXe';
		ShowMessage( 'Âf[^̐؂藣܂B');
	except
		Application.Restore;
		Application.Title := 'VXe';
		DataStore.Rollback;
		ShowMessage( 'Âf[^̐؂藣Ɏs܂B');
	end;
end;

procedure TfmdiMain.cmdCenter_Click(Sender: TObject);
begin
	TCenterSet.Prepare.Select( 1);
end;

procedure TfmdiMain.cmdZipConfig_Click(Sender: TObject);
begin
	PopupZipConfig;
end;

procedure TfmdiMain.cmdExit_Click(Sender: TObject);
begin
	Application.Terminate;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TfmdiMain.cmdClientSchedule_Click(Sender: TObject);
begin
	CreateWorkspace( TClientScheduleWorkspace, 2);
end;

procedure TfmdiMain.cmdServerSchedule_Click(Sender: TObject);
begin
	CreateWorkspace( TServerScheduleWorkspace, 2);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TfmdiMain.cmdTicket_Click(Sender: TObject);
begin
	CreateWorkspace( TTicketWorkspace, 2);
end;

procedure TfmdiMain.cmdPayback_Click(Sender: TObject);
begin
	CreateWorkspace( TPaybackWorkspace, 2);
end;

procedure TfmdiMain.cmdBilling_Click(Sender: TObject);
begin
	CreateWorkspace( TBillingWorkspace, 2);
end;

procedure TfmdiMain.cmdPayment_Click(Sender: TObject);
begin
	CreateWorkspace( TPaymentWorkspace, 2);
end;


{*=========================================================*
  @subject: listing command
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TfmdiMain.cmdClients_Click(Sender: TObject);
begin
	CreateWorkspace( TClientsWorkspace, 1);
end;

procedure TfmdiMain.cmdServers_Click(Sender: TObject);
begin
	CreateWorkspace( TServersWorkspace, 1);
end;


{*=========================================================*
  @subject: catalogue command
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TfmdiMain.cmdPlace_Click(Sender: TObject);
begin
	CreateWorkspace( TAddressesWorkspace, 1);
end;

procedure TfmdiMain.cmdBranch_Click(Sender: TObject);
begin
	CreateWorkspace( TBranchesWorkspace, 1);
end;

procedure TfmdiMain.cmdRegion_Click(Sender: TObject);
begin
	CreateWorkspace( TRegionsWorkspace, 1);
end;

procedure TfmdiMain.cmdService_Click(Sender: TObject);
begin
	CreateWorkspace( TServicesWorkspace, 1);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TfmdiMain.cmdSignboard_Click(Sender: TObject);
begin
	Signboard.Visible := not Signboard.Visible;
end;

procedure TfmdiMain.cmdTileHorizontal_Click(Sender: TObject);
begin
	Application.MainForm.TileMode := tbHorizontal;
	Application.MainForm.Tile;
end;

procedure TfmdiMain.cmdTileVertical_Click(Sender: TObject);
begin
	Application.MainForm.TileMode := tbVertical;
	Application.MainForm.Tile;
end;

procedure TfmdiMain.cmdCascadeWindow_Click(Sender: TObject);
begin
	Application.MainForm.Cascade;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TfmdiMain.cmdHelpIndex_Click(Sender: TObject);
begin
	ShellExecute( 0, 'open', PChar( ExtractFilePath( Application.ExeName) + 'manual/index.html'), nil, nil, 0);
end;

procedure TfmdiMain.cmdHelpAbout_Click(Sender: TObject);
begin
	AboutBox.ShowModal;
end;

end.
