unit Misc_PageIndicator;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TPageIndicator = class(TForm)
    pnlMessage: TPanel;
    btnAbort: TButton;
    procedure btnAbort_Click(Sender: TObject);
    procedure Form_Show(Sender: TObject);
  private
    { Private 錾 }
    FPageNumber : Integer;

    procedure SetPageNumber( AValue : Integer);
  public
    { Public 錾 }
    property PageNumber : Integer read FPageNumber write SetPageNumber;
  end;

var
  PageIndicator: TPageIndicator;

implementation

{$R *.dfm}

procedure TPageIndicator.SetPageNumber( AValue : Integer);
begin
	FPageNumber := AValue;
	pnlMessage.Caption := Format( '%d y[W߂𐶐ł', [ PageNumber]);
end;

procedure TPageIndicator.Form_Show(Sender: TObject);
begin
	FPageNumber := 1;
end;

procedure TPageIndicator.btnAbort_Click(Sender: TObject);
begin
	Visible := false;
end;

end.
