unit Misc_Signboard;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Provider, ComCtrls, StdCtrls, DB, DBClient, DBLocal, DBLocalI,
  Grids, DBGrids, DateUtils, Misc_Constants, Misc_Utilities, IBEvents,
  Buttons;

const
    DAILY_COMMENTS = 0;
    MONTHLY_COMMENTS = 1;

    ALL_COMMENTS = 0;
    WAITING_COMMENTS = 1;
    PROCESSED_COMMENTS = 2;
    STATIC_COMMENTS = 3;

type
  TSignboard = class(TForm)
    Comments: TIBClientDataSet;
    DataSourceOf_Comments: TDataSource;

    dtpTimeStamp: TDateTimePicker;
    cboRange: TComboBox;
    cboCategory: TComboBox;

    gridComments: TDBGrid;
    txtContent: TMemo;

    lblCounter: TLabel;
    btnSelect: TSpeedButton;
    btnAppend: TSpeedButton;
    btnDelete: TSpeedButton;

    EventListener: TIBEvents;

    procedure Form_Show(Sender: TObject);
    procedure Form_Hide(Sender: TObject);

    procedure dtpTimeStamp_Change(Sender: TObject);
    procedure Selector_Change(Sender: TObject);

    procedure gridComments_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
    procedure gridComments_TitleClick(Column: TColumn);

    procedure Comments_AfterScroll(DataSet: TDataSet);

    procedure btnSelect_Click(Sender: TObject);
    procedure btnAppend_Click(Sender: TObject);
    procedure btnDelete_Click(Sender: TObject);

    procedure EventListener_EventAlert(Sender: TObject; EventName: String; EventCount: Integer; var CancelAlerts: Boolean);
  private
    { Private 錾 }
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
  end;

var
  Signboard: TSignboard;

implementation

{$R *.dfm}

uses Set_Comment;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TSignboard.Create(AOwner: TComponent);
begin
	inherited Create( AOwner);

	SortByDefault( gridComments);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TSignboard.Form_Show(Sender: TObject);
begin
	EventListener.RegisterEvents;

	dtpTimeStamp.Date := Today;
	dtpTimeStamp_Change( dtpTimeStamp);
end;

procedure TSignboard.Form_Hide(Sender: TObject);
begin
	EventListener.UnRegisterEvents;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TSignboard.dtpTimeStamp_Change(Sender: TObject);
var
	Position : TDataSetPosition;
begin
	DisableGridSet( gridComments, Position);
	Comments.Close;
	Comments.Params.ParamByName( 'datMonthFirstday').AsDate := StartOfTheMonth( dtpTimeStamp.Date);
	Comments.Params.ParamByName( 'datMonthLastday').AsDate := EndOfTheMonth( dtpTimeStamp.Date);
	Comments.Open;
	Selector_Change( cboCategory);
	EnableGridSet( gridComments, Position);

	( Sender as TDateTimePicker).Format := FormatDateTime( ' ggee"N"', ( Sender as TDateTimePicker).Date) + ' yyyyN MM dd';
end;

procedure TSignboard.Selector_Change(Sender: TObject);
var
	strRange, strCategory, strFilter : String;
begin
	if cboRange.ItemIndex = DAILY_COMMENTS then
		strRange := Format( 'datTimeStamp=''%s''', [ DateToStr( dtpTimeStamp.Date)]);

	case cboCategory.ItemIndex of
	WAITING_COMMENTS : strCategory := Format( 'typCategory=%d', [ WAITING_COMMENT]);
	PROCESSED_COMMENTS : strCategory := Format( 'typCategory=%d', [ PROCESSED_COMMENT]);
	STATIC_COMMENTS : strCategory := Format( 'typCategory=%d', [ STATIC_COMMENT]);
	end;

	if ( strRange <> '') and ( strCategory <> '') then
		strFilter := Format( '%s and %s', [ strRange, strCategory])
	else
		strFilter := Format( '%s%s', [ strRange, strCategory]);

	Comments.Filter := strFilter;
	lblCounter.Caption := 'vF' + IntToStr( Comments.RecordCount) + ' ';

	btnSelect.Enabled := not Comments.IsEmpty;
	btnDelete.Enabled := btnSelect.Enabled;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TSignboard.gridComments_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
begin
 	if Column.Field.IsNull then
	begin
		gridComments.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, '@');
		exit;
	end;

	with Column do if Field.FieldName = 'DATTIMESTAMP' then
	begin
		gridComments.Canvas.TextRect( Rect, Rect.Left + 6, Rect.Top + 2,
			FormatDateTime( 'dd"" (ddd)', Column.Field.AsDateTime)
		);
		exit;
	end;

	with Column do if PickList.Count > 0 then
	begin
		gridComments.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, PickList[ Field.AsInteger]);
		exit;
	end;

	gridComments.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Column.Field.AsString);
end;

procedure TSignboard.gridComments_TitleClick(Column: TColumn);
var
	ACol : Integer;
begin
	if Column.Title.Color = clMenu then exit;

	if Column.FieldName = 'TYPCATEGORY' then Comments.IndexFieldNames := 'typCategory;datTimeStamp;strTitle';
	if Column.FieldName = 'DATTIMESTAMP' then Comments.IndexFieldNames := 'datTimeStamp;typCategory;strTitle';
	if Column.FieldName = 'STRTITLE' then Comments.IndexFieldNames := 'strTitle;typCategory;datTimeStamp';

	with gridComments.Columns do for ACol := 0 to Count - 1 do Items[ ACol].Color := clWindow;

	Column.Color := clSorted;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TSignboard.Comments_AfterScroll(DataSet: TDataSet);
begin
	txtContent.Text := Comments.FieldByname( 'strContent').AsString;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TSignboard.btnSelect_Click(Sender: TObject);
begin
	if btnSelect.Enabled then TCommentSet.Prepare.Select( ReadInstanceKey( Comments));
end;

procedure TSignboard.btnAppend_Click(Sender: TObject);
begin
	TCommentSet.Prepare.Append;
end;

procedure TSignboard.btnDelete_Click(Sender: TObject);
begin
	TCommentSet.Prepare.Delete( ReadInstanceKey( Comments));
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TSignboard.EventListener_EventAlert(Sender: TObject; EventName: String; EventCount: Integer; var CancelAlerts: Boolean);
begin
	dtpTimeStamp_Change( dtpTimeStamp);
end;

end.
