unit Piece_MinutesSelector;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Math, DateUtils, Misc_Constants, Misc_Utilities;

type
  TMinutesSelector = class(TFrame)
    cboHour: TComboBox;
    lblDotUpper: TLabel;
    lblDotLower: TLabel;
    cboMinute: TComboBox;
    procedure Combo_Change(Sender: TObject);

  private
    { Private 錾 }
    FValue : Integer;
    FPrevValue : Integer;
    FReadOnly : Boolean;

    FOnChange : TNotifyEvent;

    procedure SetValue( AValue : Integer);
    procedure SetReadOnly( AReadOnly : Boolean);
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;

    property Value : Integer read FValue write SetValue;
    property PrevValue : Integer read FPrevValue;
    property ReadOnly : Boolean read FReadOnly write SetReadOnly;

    property OnChange : TNotifyEvent read FOnChange write FOnChange;

    procedure SetFocus(); override;
  end;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TMinutesSelector.Create(AOwner: TComponent);
begin
	inherited Create( AOwner);

	FValue := 0;
	FPrevValue := 0;
	FReadOnly := true;

	FOnChange := nil;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TMinutesSelector.SetValue( AValue : Integer);
begin
	cboHour.ItemIndex := Min( Max( 0, AValue div 60), cboHour.Items.Count);
	cboMinute.ItemIndex := Min( Max( 0, AValue mod 60), cboMinute.Items.Count);

	Combo_Change( cboHour);
end;

procedure TMinutesSelector.SetReadOnly( AReadOnly : Boolean);
begin
	FReadOnly := AReadOnly;

	cboHour.Enabled := not ReadOnly;
	cboMinute.Enabled := not ReadOnly;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TMinutesSelector.SetFocus();
begin
	inherited SetFocus;

	if not ReadOnly then cboHour.SetFocus;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TMinutesSelector.Combo_Change(Sender: TObject);
begin
	FPrevValue := FValue;
	FValue := cboHour.ItemIndex * 60 + cboMinute.ItemIndex;

	if @FOnChange <> nil then FOnChange( self);
end;

end.
