unit Piece_PatternSelector;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DB, IBCustomDataSet, IBQuery, ExtCtrls, DBCtrls, StdCtrls, Math, DateUtils,
  IBDataBase, Misc_Constants, Misc_Utilities, Buttons;

type
  TPatternSelector = class(TFrame)

    lblPattern: TLabel;
    cboPattern: TComboBox;

    pnlMonth: TPanel;
    btnDay_1: TSpeedButton;
    btnDay_2: TSpeedButton;
    btnDay_3: TSpeedButton;
    btnDay_4: TSpeedButton;
    btnDay_5: TSpeedButton;
    btnDay_6: TSpeedButton;
    btnDay_7: TSpeedButton;
    btnDay_8: TSpeedButton;
    btnDay_9: TSpeedButton;
    btnDay_10: TSpeedButton;
    btnDay_11: TSpeedButton;
    btnDay_12: TSpeedButton;
    btnDay_13: TSpeedButton;
    btnDay_14: TSpeedButton;
    btnDay_15: TSpeedButton;
    btnDay_16: TSpeedButton;
    btnDay_17: TSpeedButton;
    btnDay_18: TSpeedButton;
    btnDay_19: TSpeedButton;
    btnDay_20: TSpeedButton;
    btnDay_21: TSpeedButton;
    btnDay_22: TSpeedButton;
    btnDay_23: TSpeedButton;
    btnDay_24: TSpeedButton;
    btnDay_25: TSpeedButton;
    btnDay_26: TSpeedButton;
    btnDay_27: TSpeedButton;
    btnDay_28: TSpeedButton;
    btnDay_29: TSpeedButton;
    btnDay_30: TSpeedButton;
    btnDay_31: TSpeedButton;

    pnlWeek: TPanel;
    btnSunday: TSpeedButton;
    btnMonday: TSpeedButton;
    btnTuesday: TSpeedButton;
    btnThursday: TSpeedButton;
    btnWednesday: TSpeedButton;
    btnFriday: TSpeedButton;
    btnSaturday: TSpeedButton;

    bvlBottom: TBevel;

    procedure cboPattern_Click(Sender: TObject);
    procedure btnPattern_Click(Sender: TObject);
  private
    { Private 錾 }
    FStartAt : TDate;
    FReadOnly : Boolean;

    FOnChange : TNotifyEvent;

    function ForceMask() : Integer;
    function GetTypeCode() : Integer;
    procedure SetTypeCode( AValue : Integer);
    function GetMaskCode() : Integer;
    procedure SetMaskCode( AValue : Integer);
    function GetExtendable() : Boolean;
    procedure SetReadOnly( AReadOnly : Boolean);
    function GetIsInvalid() : Boolean;
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;

    property StartAt : TDate read FStartAt;
    property TypeCode : Integer read GetTypeCode write SetTypeCode;
    property MaskCode : Integer read GetMaskCode write SetMaskCode;
    property Extendable : Boolean read GetExtendable;
    property ReadOnly : Boolean read FReadOnly write SetReadOnly;
    property IsInvalid : Boolean read GetIsInvalid;

    property OnChange : TNotifyEvent read FOnChange write FOnChange;

    procedure Reset( datAt : TDate; typPattern, optPattern : Integer); overload;

    procedure SetFocus(); override;
  end;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TPatternSelector.Create(AOwner: TComponent);
begin
	inherited Create( AOwner);

	FStartAt := Today;
	FReadOnly := true;

	FOnChange := nil;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function TPatternSelector.ForceMask() : Integer;
begin
	if ReadOnly then
		result := 0
	else
		case TypeCode of
		PATTERN_DAY_OF_THE_EVERY_WEEK, PATTERN_DAY_OF_THE_SECOND_WEEK :
			result := ( 1 shl ( DayOfWeek( StartAt) - 1));

		PATTERN_DAY_OF_THE_MONTH, PATTERN_COMPLEX, PATTERN_MULTIPLE :
			result := ( 1 shl ( DayOfTheMonth( StartAt) - 1));
		else
			result := 0;
		end;
end;

function TPatternSelector.GetTypeCode() : Integer;
begin
	result := cboPattern.ItemIndex
end;

procedure TPatternSelector.SetTypeCode( AValue : Integer);
begin
	cboPattern.ItemIndex := Max( PATTERN_SINGLETON, Min( AValue, PATTERN_MULTIPLE));
	cboPattern_Click( cboPattern);
end;

function TPatternSelector.GetMaskCode() : Integer;
begin
	case TypeCode of
	PATTERN_DAY_OF_THE_EVERY_WEEK, PATTERN_DAY_OF_THE_SECOND_WEEK :
		result := ForceMask or SpeedButtonsToOptions( [
			btnSunday, btnMonday, btnTuesday, btnWednesday, btnThursday, btnFriday, btnSaturday
		]);

	PATTERN_DAY_OF_THE_MONTH, PATTERN_COMPLEX, PATTERN_MULTIPLE :
		result := ForceMask or SpeedButtonsToOptions( [
			btnDay_1, btnDay_2, btnDay_3, btnDay_4, btnDay_5, btnDay_6, btnDay_7, btnDay_8, btnDay_9, btnDay_10,
			btnDay_11, btnDay_12, btnDay_13, btnDay_14, btnDay_15, btnDay_16, btnDay_17, btnDay_18, btnDay_19, btnDay_20,
			btnDay_21, btnDay_22, btnDay_23, btnDay_24, btnDay_25, btnDay_26, btnDay_27, btnDay_28, btnDay_29, btnDay_30,
			btnDay_31
		]);
	else
		result := 0;
	end;
end;

procedure TPatternSelector.SetMaskCode( AValue : Integer);
begin
	case TypeCode of
	PATTERN_DAY_OF_THE_EVERY_WEEK, PATTERN_DAY_OF_THE_SECOND_WEEK :
		OptionsToSpeedButtons( ForceMask or AValue, [
			btnSunday, btnMonday, btnTuesday, btnWednesday, btnThursday, btnFriday, btnSaturday
		]);

	PATTERN_DAY_OF_THE_MONTH, PATTERN_COMPLEX, PATTERN_MULTIPLE :
		OptionsToSpeedButtons( ForceMask or AValue, [
			btnDay_1, btnDay_2, btnDay_3, btnDay_4, btnDay_5, btnDay_6, btnDay_7, btnDay_8, btnDay_9, btnDay_10,
			btnDay_11, btnDay_12, btnDay_13, btnDay_14, btnDay_15, btnDay_16, btnDay_17, btnDay_18, btnDay_19, btnDay_20,
			btnDay_21, btnDay_22, btnDay_23, btnDay_24, btnDay_25, btnDay_26, btnDay_27, btnDay_28, btnDay_29, btnDay_30,
			btnDay_31
		]);
	end;
end;

function TPatternSelector.GetExtendable() : Boolean;
begin
	result := TypeCode <> PATTERN_SINGLETON;
end;

procedure TPatternSelector.SetReadOnly( AReadOnly : Boolean);
begin
	FReadOnly := AReadOnly;

	cboPattern.Enabled := not ReadOnly;
	pnlMonth.Enabled := not ReadOnly;
	pnlWeek.Enabled := not ReadOnly;
end;

function TPatternSelector.GetIsInvalid() : Boolean;
begin
	result := ( TypeCode = PATTERN_COMPLEX) and ( ( MaskCode - ForceMask) = 0);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPatternSelector.Reset( datAt : TDate; typPattern, optPattern : Integer);
begin
	FStartAt := datAt;
	TypeCode := typPattern;
	MaskCode := optPattern;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPatternSelector.SetFocus();
begin
	inherited SetFocus;

	if not ReadOnly then cboPattern.SetFocus;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPatternSelector.cboPattern_Click(Sender: TObject);
var
	index : Integer;
	dateStamp : TDateTime;
	dayButton : TSpeedButton;
begin
	case TypeCode of
	PATTERN_DAY_OF_THE_EVERY_WEEK, PATTERN_DAY_OF_THE_SECOND_WEEK :
		begin
			MaskCode := MaskCode;
			pnlMonth.Visible := false;
			pnlWeek.Visible := true;
		end;

	PATTERN_DAY_OF_THE_MONTH :
		begin
			MaskCode := MaskCode;
			pnlMonth.Visible := true;
			pnlWeek.Visible := false;

			for index := 0 to 30 do
			begin
				dayButton := FindComponent( 'btnDay_' + IntToStr( index + 1)) as TSpeedButton;
				dayButton.Caption := IntToStr( index + 1);
				dayButton.Font.Color := clWindowText;
				dayButton.Enabled := true;
			end;
		end;

	PATTERN_COMPLEX, PATTERN_MULTIPLE :
		begin
			MaskCode := MaskCode;
			pnlMonth.Visible := true;
			pnlWeek.Visible := false;

			for index := 0 to 30 do
			begin
				dateStamp := IncDay( StartOfTheMonth( StartAt), index);
				dayButton := FindComponent( 'btnDay_' + IntToStr( index + 1)) as TSpeedButton;

				if ( StartAt < dateStamp) and ( dateStamp <= EndOfTheMonth( StartAt)) then
				begin
					dayButton.Caption := IntToStr( DayOf( dateStamp));
					case DayOfWeek( dateStamp) of
					1 : dayButton.Font.Color := $0000CC;
					2..6 : dayButton.Font.Color := clWindowText;
					7 : dayButton.Font.Color := $CC0000;
					end;
					dayButton.Enabled := true;
				end
				else
				begin
					dayButton.Caption := '*';
					dayButton.Down := false;
					dayButton.Enabled := false;
				end;
			end;
		end;
	else
		pnlMonth.Visible := false;
		pnlWeek.Visible := false;
	end;

	if @FOnChange <> nil then FOnChange( self);
end;

procedure TPatternSelector.btnPattern_Click(Sender: TObject);
begin
	MaskCode := MaskCode;
end;

end.
