unit Piece_SchedulePalette;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ImgList, Misc_Constants, Misc_Utilities, StdCtrls, StrUtils;

const
	PRIMARY_TRANSFER = 0;
	SECONDARY_TRANSFER = 1;
	PRIMARY_CARE = 2;
	SECONDARY_CARE = 3;
	PRIMARY_MENAGE = 4;
	SECONDARY_MENAGE = 5;
	ESCORT_TRANSFER = 6;
	HELPER_MIGRATION = 7;

type
  TSchedulePalette = class(TFrame)
    iglSchedule: TImageList;
    lbxSchedule: TListBox;

    procedure Frame_Resize(Sender: TObject);

    procedure lbxSchedule_StartDrag(Sender: TObject; var DragObject: TDragObject);
    procedure lbxSchedule_EndDrag(Sender, Target: TObject; X, Y: Integer);
    procedure lbxSchedule_DrawItem(Control: TWinControl; Index: Integer; Rect: TRect; State: TOwnerDrawState);
  private
    { Private 錾 }
    function GetScheduleType() : Integer;
  public
    { Public 錾 }
    property ScheduleType : Integer read GetScheduleType;
  end;

function DragSourceToSchedulePalette( Source : TObject) : TSchedulePalette;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function DragSourceToSchedulePalette( Source : TObject) : TSchedulePalette;
begin
	result := ( Source as TComponent).Owner as TSchedulePalette;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function TSchedulePalette.GetScheduleType() : Integer;
begin
	result := lbxSchedule.ItemIndex;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TSchedulePalette.Frame_Resize(Sender: TObject);
begin
	lbxSchedule.Invalidate;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TSchedulePalette.lbxSchedule_StartDrag(Sender: TObject; var DragObject: TDragObject);
begin
	if @OnStartDrag <> nil then OnStartDrag( Sender, DragObject);
end;

procedure TSchedulePalette.lbxSchedule_EndDrag(Sender, Target: TObject; X, Y: Integer);
begin
	if @OnEndDrag <> nil then OnEndDrag( Sender, Target, X, Y);
end;

procedure TSchedulePalette.lbxSchedule_DrawItem(Control: TWinControl; Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
	ItemText : String;
begin
	if ( odSelected in State) and lbxSchedule.Focused then
	begin
		lbxSchedule.Canvas.Brush.Color := clSkyBlue;
		lbxSchedule.Canvas.Font.Color := clBlack;
	end
	else
	begin
		lbxSchedule.Canvas.Brush.Color := lbxSchedule.Color;
		lbxSchedule.Canvas.Font.Color := clBlack;
	end;
	lbxSchedule.Canvas.FillRect( Rect);

	ItemText := lbxSchedule.Items.Strings[ Index];
	iglSchedule.Draw(
		lbxSchedule.Canvas,
		Rect.Left + ( lbxSchedule.ClientWidth - iglSchedule.Width) div 2,
		Rect.Top + 4,
		StrToInt( LeftStr( ItemText, 1))
	);

	ItemText := MidStr( ItemText, 2, 100);
	lbxSchedule.Canvas.TextOut(
		Rect.Left + ( lbxSchedule.ClientWidth - lbxSchedule.Canvas.TextWidth( ItemText)) div 2,
		Rect.Top + 48,
		ItemText
	);
end;

end.
