unit Piece_ServiceSelector;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DB, IBCustomDataSet, IBQuery, ExtCtrls, DBCtrls, StdCtrls, Math, DateUtils,
  IBDataBase, Misc_Constants, Misc_Utilities;

type
  TServiceSelector = class(TFrame)
    Service: TIBQuery;
    DataSourceOf_Service: TDataSource;

    Exchange: TIBQuery;
    DataSourceOf_Exchange: TDataSource;

    lblService: TLabel;
    cboService: TDBLookupComboBox;

    lblExchange: TLabel;
    cboExchange: TDBLookupComboBox;

    lblProgress: TLabel;
    cboProgress: TComboBox;
    pnlExchange: TPanel;

    txtNotice: TLabeledEdit;

    bvlBottom: TBevel;

    procedure cboProgress_Click(Sender: TObject);
    procedure cboService_Click(Sender: TObject);
    procedure cboExchange_Click(Sender: TObject);
  private
    { Private 錾 }
    FCategory : Integer;
    FMinutes : Integer;
    FReadOnly : Boolean;

    function GetTransaction() : TIBTransaction;
    function GetAvailableAt() : TDate;
    function GetProgress() : Integer;
    procedure SetProgress( AValue : Integer);
    procedure SetMinutes( AValue : Integer);
    function GetServiceKey() : Integer;
    procedure SetServiceKey( AValue : Integer);
    function GetExchangeKey() : Integer;
    procedure SetExchangeKey( AValue : Integer);
    function GetNotice() : String;
    procedure SetNotice( AValue : String);
    procedure SetReadOnly( AReadOnly : Boolean);
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;

    property Transaction : TIBTransaction read GetTransaction;
    property AvailableAt : TDate read GetAvailableAt;
    property Category : Integer read FCategory;
    property Progress : Integer read GetProgress write SetProgress;
    property Minutes : Integer read FMinutes write SetMinutes;
    property ServiceKey : Integer read GetServiceKey write SetServiceKey;
    property ExchangeKey : Integer read GetExchangeKey write SetExchangeKey;
    property Notice : String read GetNotice write SetNotice;
    property ReadOnly : Boolean read FReadOnly write SetReadOnly;

    procedure Reset( _tran : TIBTransaction; datSchedule : TDate; typCategory, typProgress, keyService, keyExchange : Integer; strNotice : String); overload;
    procedure Reset( keyService, keyExchange : Integer; strNotice : String); overload;

    procedure SetFocus(); override;
  end;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TServiceSelector.Create(AOwner: TComponent);
begin
	inherited Create( AOwner);

	FCategory := TRANSFER_SERVICE;
	FMinutes := 0;
	FReadOnly := true;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function TServiceSelector.GetTransaction() : TIBTransaction;
begin
	result := Service.Transaction;
end;

function TServiceSelector.GetAvailableAt() : TDate;
begin
	result := Service.ParamByName( 'datAvailableAt').AsDate;
end;

function TServiceSelector.GetProgress() : Integer;
begin
	result := cboProgress.ItemIndex;
end;

procedure TServiceSelector.SetProgress( AValue : Integer);
begin
	cboProgress.ItemIndex := Max( UNCLEAR_PROGRESS, Min( AValue, DEFINED_PROGRESS));
	cboProgress_Click( cboProgress);
end;

procedure TServiceSelector.SetMinutes( AValue : Integer);
begin
	FMinutes := Max( 0, AValue);
	cboProgress_Click( cboProgress);
end;

function TServiceSelector.GetServiceKey() : Integer;
begin
	if Service.IsEmpty then
		result := -1
	else
		result := Service.FieldByName( 'keyInstance').AsInteger;
end;

procedure TServiceSelector.SetServiceKey( AValue : Integer);
begin
	SelectComboWithoutFail( cboService, AValue);
end;

function TServiceSelector.GetExchangeKey() : Integer;
begin
	if Exchange.IsEmpty then
		result := -1
	else
		result := Exchange.FieldByName( 'keyInstance').AsInteger;
end;

procedure TServiceSelector.SetExchangeKey( AValue : Integer);
begin
	SelectComboWithoutFail( cboExchange, AValue);
end;

function TServiceSelector.GetNotice() : String;
begin
	result := Trim( txtNotice.Text);
end;

procedure TServiceSelector.SetNotice( AValue : String);
begin
	txtNotice.Text := Trim( AValue);
end;

procedure TServiceSelector.SetReadOnly( AReadOnly : Boolean);
begin
	FReadOnly := AReadOnly;

	cboProgress.Enabled := not ReadOnly;
	cboService.Enabled := not ReadOnly;
	cboExchange.Enabled := not ReadOnly;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServiceSelector.Reset( _tran : TIBTransaction; datSchedule : TDate; typCategory, typProgress, keyService, keyExchange : Integer; strNotice : String);
begin
	FCategory := typCategory;

	case FCategory of
	CARE_SCHEDULE : Color := TColor( $00BCA0A0);
	MENAGE_SCHEDULE : Color := TColor( $00DCC0C0);
	MIGRATION_SCHEDULE : Color := TColor( $00C0DCDC);
	TRANSFER_SCHEDULE : Color := TColor( $00C0C0DC);
	end;

	Service.Close;
	Service.Transaction := _tran;
	Service.ParamByName( 'typCategory').AsInteger := Category;
	Service.ParamByName( 'keyInstance').AsInteger := keyService;
	Service.ParamByName( 'datAvailableAt').AsDate := datSchedule;
	Service.Open;
	Service.FetchAll;

	Exchange.Close;
	Exchange.Transaction := _tran;
	Exchange.ParamByName( 'keyInstance').AsInteger := keyExchange;
	Exchange.ParamByName( 'datAvailableAt').AsDate := datSchedule;

	cboProgress.ItemIndex := typProgress;
	cboService.KeyValue := keyService;
	cboExchange.KeyValue := keyExchange;

	SelectComboWithoutFail( cboService, keyService);
	cboService_Click( cboService);

	Notice := strNotice;
end;

procedure TServiceSelector.Reset( keyService, keyExchange : Integer; strNotice : String);
begin
	Reset( Transaction, AvailableAt, Category, Progress, keyService, keyExchange, strNotice);
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServiceSelector.SetFocus();
begin
	inherited SetFocus;

	if not ReadOnly then cboService.SetFocus;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServiceSelector.cboProgress_Click(Sender: TObject);
begin
	cboExchange_Click( cboExchange);
end;

procedure TServiceSelector.cboService_Click(Sender: TObject);
begin
	Exchange.Close;
	Exchange.ParamByName( 'keyService').AsInteger := Service.FieldByName( 'keyInstance').AsInteger;
	Exchange.Open;
	Exchange.FetchAll;
	SelectComboWithoutFail( cboExchange, VarToInt( cboExchange.KeyValue));

	cboProgress_Click( cboProgress);
end;

procedure TServiceSelector.cboExchange_Click(Sender: TObject);
begin
	with Exchange do
	begin
		pnlExchange.Caption := Format( '%s ( %s )', [
			aExchange[ FieldByName( 'typCategory').AsInteger],
			AmountToText(
				FieldByName( 'typCategory').AsInteger,
				FieldByName( 'curAmountPerCount').AsCurrency,
				FieldByName( 'curAmountPerHour').AsCurrency,
				FMinutes
			)
		]);
	end;
end;

end.
