unit Publisher_CandidatesCount;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, StrUtils, ExtCtrls, Provider, DB, DBClient, DBLocal,
  MainDatastore, DBLocalI, IB, IBErrorCodes, IBSQL, IBDatabase, IBCustomDataSet,
  IBQuery, DBCtrls, ComCtrls, DateUtils, Base_Publisher, Grids, DBGrids,
  Buttons, Math, Misc_Constants, Misc_Utilities;

type
  TCandidatesCountPublisher = class(TPublisherTemplate)
    Branch: TIBQuery;
    DataSourceOf_Barnch: TDataSource;

    Region: TIBQuery;
    DataSourceOf_Region: TDataSource;

    lblBranch: TLabel;
    cboBranch: TDBLookupComboBox;
    lblBranchAnd: TLabel;

    lblRegion: TLabel;
    cboRegion: TDBLookupComboBox;
    lblRegionAnd: TLabel;

    lblTitle: TLabel;
    txtTitle: TEdit;
    lblTitleAnd: TLabel;

    lblContent: TLabel;
    txtContent: TEdit;
    lblContentAnd: TLabel;

    cboCategory: TComboBox;
    lblCategory: TLabel;

    cboPivot: TComboBox;
    lblPivot: TLabel;

    pnlAvailableFrom: TPanel;
    btnAvailableFrom: TButton;
    lblAvailableFrom: TLabel;

    pnlAvailableTo: TPanel;
    btnAvailableTo: TButton;
    lblAvailableTo: TLabel;

    txtName: TEdit;
    lblName: TLabel;

    procedure btnAvailableFrom_Click(Sender: TObject);
    procedure btnAvailableTo_Click(Sender: TObject);

  private
    { Private 錾 }
    FAvailableFrom : TDate;
    FAvailableTo : TDate;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
  end;

  CCandidatesCountPublisher = class of TCandidatesCountPublisher;

var
  CandidatesCountPublisher: TCandidatesCountPublisher;

implementation

{$R *.dfm}

uses Chooser_Date, Report_CandidatesCount;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCandidatesCountPublisher.BeforePopup();
begin
	FAvailableFrom := StartOfTheYear( Today);
	FAvailableTo := EndOfTheYear( FAvailableFrom);
	pnlAvailableFrom.Caption := FormatDateTime( 'gg ee "N" yyyy "N" MM ""', FAvailableFrom);
	pnlAvailableTo.Caption := FormatDateTime( 'gg ee "N" yyyy "N" MM ""', FAvailableTo);

	Branch.Open;
	Branch.FetchAll;
	SelectComboWithoutFail( cboBranch, -1);

	Region.Open;
	Region.FetchAll;
	SelectComboWithoutFail( cboRegion, -1);
end;

procedure TCandidatesCountPublisher.AfterPopup();
begin
	if FAvailableFrom >= FAvailableTo then
		ErrorMessages.Add( 'i݊ԂtɂȂĂ܂B');

	ErrorCheck_Empty( '̖O', txtName.Text, ErrorMessages);

	if ErrorMessages.Count > 0 then exit;

	TCandidatesCountReport.Prepare(
		cboBranch.KeyValue,
		cboRegion.KeyValue,
		Trim( txtTitle.Text),
		Trim( txtContent.Text),
		cboCategory.ItemIndex - 1,
		cboPivot.ItemIndex,
		FAvailableFrom,
		FAvailableTo,
		Trim( txtName.Text)
	).Preview;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCandidatesCountPublisher.btnAvailableFrom_Click(Sender: TObject);
begin
	if ChooseDate( FAvailableFrom) then
	begin
		pnlAvailableFrom.Caption := FormatDateTime( 'gg ee "N" yyyy "N" MM ""', FAvailableFrom);
	end;
end;

procedure TCandidatesCountPublisher.btnAvailableTo_Click(Sender: TObject);
begin
	if ChooseDate( FAvailableTo) then
	begin
		pnlAvailableTo.Caption := FormatDateTime( 'gg ee "N" yyyy "N" MM ""', FAvailableTo);
	end;
end;

end.
