unit Publisher_PaybackLabels;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, StrUtils, ExtCtrls, Provider, DB, DBClient, DBLocal,
  MainDatastore, DBLocalI, IB, IBErrorCodes, IBSQL, IBDatabase, IBCustomDataSet,
  IBQuery, DBCtrls, ComCtrls, DateUtils, Base_Publisher, Grids, DBGrids,
  Buttons, Math, Misc_Constants, Misc_Utilities;

type
  TPaybackLabelsPublisher = class(TPublisherTemplate)
    SourceOf_Payback: TIBQuery;
    ProviderOf_Payback: TDataSetProvider;
    Payback: TClientDataSet;
    DataSourceOf_Payback: TDataSource;

    pnlTimeStamp: TPanel;
    btnTimeStamp: TButton;

    gridPayback: TDBGrid;

    btnBrowse: TButton;
    btnExclude: TButton;
    btnInvert: TButton;

    pbrProgress: TProgressBar;

    procedure btnTimeStamp_Click(Sender: TObject);

    procedure gridPayback_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
    procedure gridPayback_TitleClick(Column: TColumn);

    procedure btnBrowse_Click( Sender : TObject);
    procedure btnExclude_Click( Sender : TObject);
    procedure btnInvert_Click(Sender: TObject);

  private
    { Private 錾 }
    FAvailableAt : TDate;
    FFrom : TDate;
    FTo : TDate;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
    constructor Prepare( datFrom, datTo : TDate);
  end;

var
  PaybackLabelsPublisher: TPaybackLabelsPublisher;

implementation

{$R *.dfm}

uses Chooser_Date, Set_Payback, Report_Payback, Report_NameLabels;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TPaybackLabelsPublisher.Prepare( datFrom, datTo : TDate);
begin
	inherited Prepare;

	FAvailableAt := Today;
	FFrom := datFrom;
	FTo := datTo;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackLabelsPublisher.BeforePopup();
begin
	Payback.Close;
	SourceOf_Payback.ParamByName( 'datFrom').AsDate := FFrom;
	SourceOf_Payback.ParamByName( 'datTo').AsDate := FTo;
	SourceOf_Payback.ParamByName( 'datAt').AsDate := FAvailableAt;
	Payback.Open;
	// update query

	pnlTimeStamp.Caption := FormatDateTime( 'gg ee "N" yyyy "N" MM "" dd "" (ddd)', FAvailableAt);

	btnBrowse.Enabled := not Payback.IsEmpty;
	btnExclude.Enabled := not Payback.IsEmpty;
	btnInvert.Enabled := not Payback.IsEmpty;

	gridPayback.SelectedRows.CurrentRowSelected := true;
end;

procedure TPaybackLabelsPublisher.AfterPopup();
begin
	TNameLabelsReport.Prepare( Payback).Preview;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackLabelsPublisher.btnTimeStamp_Click(Sender: TObject);
begin
	if ChooseDate( FAvailableAt) then BeforePopup;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackLabelsPublisher.gridPayback_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
	selected : Boolean;
	dummy : Integer;
begin
	selected := gridPayback.SelectedRows.Find( Payback.Bookmark, dummy);
	with gridPayback.Canvas do if not IntToBool( Payback.FieldByName( 'blnAvailable').AsInteger) then
	begin
		Font.Color := IfThen( selected, clHighlightText, clWindowText);
		Brush.Color := IfThen( selected, clSelectedExcluded, clDefaultExcluded);
	end
	else
	begin
		Font.Color := IfThen( selected, clHighlightText, Column.Font.Color);
		Brush.Color := IfThen( selected, clHighlight, Column.Color);
	end;

	if Column.Alignment = taRightJustify then
	begin
		gridPayback.Canvas.TextRect(
			Rect, Rect.Right - 2 - gridPayback.Canvas.TextWidth( Column.Field.AsString), Rect.Top + 2, Column.Field.AsString
		);
	end
	else
	begin
		gridPayback.Canvas.TextRect(
			Rect, Rect.Left + 2, Rect.Top + 2, Column.Field.AsString
		);
	end;
end;

procedure TPaybackLabelsPublisher.gridPayback_TitleClick(Column: TColumn);
var
	ACol : Integer;
begin
	if Column.Title.Color = clMenu then exit;

	if Column.FieldName = 'STRCODE' then Payback.IndexFieldNames := 'strCode;datPublished';
	if Column.FieldName = 'STRNAMEREAD' then Payback.IndexFieldNames := 'strNameRead;datPublished';
	if Column.FieldName = 'DATPUBLISHED' then Payback.IndexFieldNames := 'datPublished;strNameRead';
	if Column.FieldName = 'INTMARGIN' then Payback.IndexFieldNames := 'intMargin;strNameRead;datPublished';
	if Column.FieldName = 'INTPAYBACK' then Payback.IndexFieldNames := 'intPayback;strNameRead;datPublished';

	with gridPayback.Columns do for ACol := 0 to Count - 1 do Items[ ACol].Color := clWindow;

	Column.Color := clSorted;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackLabelsPublisher.btnBrowse_Click( Sender : TObject);
begin
	with Payback do if not IsEmpty then TPaybackSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
end;

procedure TPaybackLabelsPublisher.btnExclude_Click( Sender : TObject);
var
	index : Integer;
begin
	if Payback.IsEmpty then exit;

	Payback.DisableControls;
	for index := 0 to gridPayback.SelectedRows.Count - 1 do
	begin
		with Payback do
		begin
			Bookmark := gridPayback.SelectedRows.Items[ index];
			Edit;
			FieldByName( 'blnAvailable').AsInteger := BoolToInt( not IntToBool( FieldByName( 'blnAvailable').AsInteger));
			Post;
		end;
	end;
	gridPayback.SelectedRows.Refresh;
	gridPayback.SelectedRows.CurrentRowSelected := true;
	Payback.EnableControls;
end;

procedure TPaybackLabelsPublisher.btnInvert_Click(Sender: TObject);
var
	defaultRecNo : Integer;
begin
        with Payback do
        begin
		if IsEmpty then exit;
		defaultRecNo := RecNo;
        	DisableControls;
		First;
	        while not EOF do
	        begin
			Edit;
			FieldByName( 'blnAvailable').AsInteger := BoolToInt( not IntToBool( FieldByName( 'blnAvailable').AsInteger));
			Post;
        	        Next;
	        end;
		RecNo := defaultRecNo;
		EnableControls;
        end;
end;

end.
