unit Publisher_PaymentLabels;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, StrUtils, ExtCtrls, Provider, DB, DBClient, DBLocal,
  MainDatastore, DBLocalI, IB, IBErrorCodes, IBSQL, IBDatabase, IBCustomDataSet,
  IBQuery, DBCtrls, ComCtrls, DateUtils, Base_Publisher, Grids, DBGrids,
  Buttons, Math, Misc_Constants, Misc_Utilities;

type
  TPaymentLabelsPublisher = class(TPublisherTemplate)
    SourceOf_Payment: TIBQuery;
    ProviderOf_Payment: TDataSetProvider;
    Payment: TClientDataSet;
    DataSourceOf_Payment: TDataSource;

    pnlTimeStamp: TPanel;
    btnTimeStamp: TButton;

    gridPayment: TDBGrid;

    btnBrowse: TButton;
    btnExclude: TButton;
    btnInvert: TButton;

    pbrProgress: TProgressBar;

    procedure btnTimeStamp_Click(Sender: TObject);

    procedure gridPayment_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
    procedure gridPayment_TitleClick(Column: TColumn);

    procedure btnBrowse_Click( Sender : TObject);
    procedure btnExclude_Click( Sender : TObject);
    procedure btnInvert_Click(Sender: TObject);

  private
    { Private 錾 }
    FAvailableAt : TDate;
    FFrom : TDate;
    FTo : TDate;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
    constructor Prepare( datFrom, datTo : TDate);
  end;

var
  PaymentLabelsPublisher: TPaymentLabelsPublisher;

implementation

{$R *.dfm}

uses Chooser_Date, Set_Payment, Report_Payment, Report_NameLabels;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TPaymentLabelsPublisher.Prepare( datFrom, datTo : TDate);
begin
	inherited Prepare;

	FAvailableAt := Today;
	FFrom := datFrom;
	FTo := datTo;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentLabelsPublisher.BeforePopup();
begin
	Payment.Close;
	SourceOf_Payment.ParamByName( 'datFrom').AsDate := FFrom;
	SourceOf_Payment.ParamByName( 'datTo').AsDate := FTo;
	SourceOf_Payment.ParamByName( 'datAt').AsDate := FAvailableAt;
	Payment.Open;
	// update query

	pnlTimeStamp.Caption := FormatDateTime( 'gg ee "N" yyyy "N" MM "" dd "" (ddd)', FAvailableAt);

	btnBrowse.Enabled := not Payment.IsEmpty;
	btnExclude.Enabled := not Payment.IsEmpty;
	btnInvert.Enabled := not Payment.IsEmpty;

	gridPayment.SelectedRows.CurrentRowSelected := true;
end;

procedure TPaymentLabelsPublisher.AfterPopup();
begin
	TNameLabelsReport.Prepare( Payment).Preview;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentLabelsPublisher.btnTimeStamp_Click(Sender: TObject);
begin
	if ChooseDate( FAvailableAt) then BeforePopup;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentLabelsPublisher.gridPayment_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
	selected : Boolean;
	dummy : Integer;
begin
	selected := gridPayment.SelectedRows.Find( Payment.Bookmark, dummy);
	with gridPayment.Canvas do if not IntToBool( Payment.FieldByName( 'blnAvailable').AsInteger) then
	begin
		Font.Color := IfThen( selected, clHighlightText, clWindowText);
		Brush.Color := IfThen( selected, clSelectedExcluded, clDefaultExcluded);
	end
	else
	begin
		Font.Color := IfThen( selected, clHighlightText, Column.Font.Color);
		Brush.Color := IfThen( selected, clHighlight, Column.Color);
	end;

	if Column.Alignment = taRightJustify then
	begin
		gridPayment.Canvas.TextRect(
			Rect, Rect.Right - 2 - gridPayment.Canvas.TextWidth( Column.Field.AsString), Rect.Top + 2, Column.Field.AsString
		);
	end
	else
	begin
		gridPayment.Canvas.TextRect(
			Rect, Rect.Left + 2, Rect.Top + 2, Column.Field.AsString
		);
	end;
end;

procedure TPaymentLabelsPublisher.gridPayment_TitleClick(Column: TColumn);
var
	ACol : Integer;
begin
	if Column.Title.Color = clMenu then exit;

	if Column.FieldName = 'STRCODE' then Payment.IndexFieldNames := 'strCode;datPublished';
	if Column.FieldName = 'STRNAMEREAD' then Payment.IndexFieldNames := 'strNameRead;datPublished';
	if Column.FieldName = 'DATPUBLISHED' then Payment.IndexFieldNames := 'datPublished;strNameRead';
	if Column.FieldName = 'INTMARGIN' then Payment.IndexFieldNames := 'intMargin;strNameRead;datPublished';
	if Column.FieldName = 'INTPAYMENT' then Payment.IndexFieldNames := 'intPayment;strNameRead;datPublished';

	with gridPayment.Columns do for ACol := 0 to Count - 1 do Items[ ACol].Color := clWindow;

	Column.Color := clSorted;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentLabelsPublisher.btnBrowse_Click( Sender : TObject);
begin
	with Payment do if not IsEmpty then TPaymentSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
end;

procedure TPaymentLabelsPublisher.btnExclude_Click( Sender : TObject);
var
	index : Integer;
begin
	if Payment.IsEmpty then exit;

	Payment.DisableControls;
	for index := 0 to gridPayment.SelectedRows.Count - 1 do
	begin
		with Payment do
		begin
			Bookmark := gridPayment.SelectedRows.Items[ index];
			Edit;
			FieldByName( 'blnAvailable').AsInteger := BoolToInt( not IntToBool( FieldByName( 'blnAvailable').AsInteger));
			Post;
		end;
	end;
	gridPayment.SelectedRows.Refresh;
	gridPayment.SelectedRows.CurrentRowSelected := true;
	Payment.EnableControls;
end;

procedure TPaymentLabelsPublisher.btnInvert_Click(Sender: TObject);
var
	defaultRecNo : Integer;
begin
        with Payment do
        begin
		if IsEmpty then exit;
		defaultRecNo := RecNo;
        	DisableControls;
		First;
	        while not EOF do
	        begin
			Edit;
			FieldByName( 'blnAvailable').AsInteger := BoolToInt( not IntToBool( FieldByName( 'blnAvailable').AsInteger));
			Post;
        	        Next;
	        end;
		RecNo := defaultRecNo;
		EnableControls;
        end;
end;

end.
