unit Publisher_ServerSchedules;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, StrUtils, ExtCtrls, Provider, DB, DBClient, DBLocal,
  MainDatastore, DBLocalI, IB, IBErrorCodes, IBSQL, IBDatabase, IBCustomDataSet,
  IBQuery, DBCtrls, ComCtrls, DateUtils, Base_Publisher, Grids, DBGrids,
  Buttons, Math, Misc_Constants, Misc_Utilities, Base_Report;

type
  TServerSchedulesPublisher = class(TPublisherTemplate)
    SourceOf_Server: TIBQuery;
    ProviderOf_Server: TDataSetProvider;
    Server: TClientDataSet;
    DataSourceOf_Server: TDataSource;
    Center: TIBQuery;

    cboCategory: TComboBox;
    pnlTimeStamp: TPanel;
    btnTimeStamp: TButton;

    gridServer: TDBGrid;

    btnBrowse: TButton;
    btnExclude: TButton;
    btnInvert: TButton;

    pbrProgress: TProgressBar;
    btnAbort: TButton;
    chkPublishToFax: TCheckBox;
    chkPublishWithMaps: TCheckBox;

    procedure Selector_Change(Sender: TObject);
    procedure btnTimeStamp_Click(Sender: TObject);

    procedure gridServer_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
    procedure gridServer_TitleClick(Column: TColumn);

    procedure chkPublishToFax_Click(Sender: TObject);

    procedure btnBrowse_Click( Sender : TObject);
    procedure btnExclude_Click( Sender : TObject);
    procedure btnInvert_Click(Sender: TObject);

    procedure btnAbort_Click(Sender: TObject);

  private
    { Private 錾 }
    FPivot : Tdate;
    FPrinting : Boolean;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
    constructor Prepare( datPivot : TDate);
  end;

var
  ServerSchedulesPublisher: TServerSchedulesPublisher;

implementation

{$R *.dfm}

uses Chooser_Date,
     Set_Server,
     Report_DailyServerSchedule,
     Report_WeeklyServerSchedule,
     Report_MonthlyServerSchedule,
     Report_DailyServerScheduleWithMap,
     Report_WeeklyServerScheduleWithMap,
     Report_MonthlyServerScheduleWithMap,
     Report_Picture;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TServerSchedulesPublisher.Prepare( datPivot : TDate);
begin
	inherited Create( Screen.ActiveForm);

	FPivot := datPivot;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServerSchedulesPublisher.BeforePopup();
begin
	Center.Open;
	Selector_Change( self);
end;

procedure TServerSchedulesPublisher.AfterPopup();
var
	Report : TReportTemplate;
	CenterName : String;
begin
	gridServer.Enabled := false;
	btnBrowse.Enabled := false;
	btnExclude.Enabled := false;
	btnInvert.Enabled := false;
	btnAbort.Enabled := true;
	btnOK.Enabled := false;
	btnCancel.Enabled := false;

	FPrinting := true;
	CenterName := Center.FieldByName( 'strTradeName').AsString;

	Server.First;
	pbrProgress.Max := Server.RecordCount;
	with Server do while ( not EOF) and FPrinting do
	begin
		if IntToBool( FieldByName( 'blnAvailable').AsInteger) then
		begin
			if chkPublishWithMaps.Checked then
				case cboCategory.ItemIndex of
				0 : Report := TDailyServerScheduleWithMapReport.Prepare( FieldByName( 'keyInstance').AsInteger, FPivot);
				1 : Report := TWeeklyServerScheduleWithMapReport.Prepare( FieldByName( 'keyInstance').AsInteger, FPivot);
				2 : Report := TMonthlyServerScheduleWithMapReport.Prepare( FieldByName( 'keyInstance').AsInteger, FPivot);
				end
			else
				case cboCategory.ItemIndex of
				0 : Report := TDailyServerScheduleReport.Prepare( FieldByName( 'keyInstance').AsInteger, FPivot);
				1 : Report := TWeeklyServerScheduleReport.Prepare( FieldByName( 'keyInstance').AsInteger, FPivot);
				2 : Report := TMonthlyServerScheduleReport.Prepare( FieldByName( 'keyInstance').AsInteger, FPivot);
				end;

			if chkPublishToFax.Checked then
				Report.Facsimile( FieldByName( 'strName').AsString, FieldByName( 'strFaxNumber1').AsString, CenterName)
			else
				Report.Printout;
		end;

		pbrProgress.Position := RecNo;
		Next;

		Application.ProcessMessages;
	end;

	if FPrinting then
	begin
		Application.MessageBox( 'v^ւ̃f[^MI܂', 'hXPW[\̈ꊇ', MB_OK);
		exit;
	end;

	gridServer.Enabled := true;
	btnBrowse.Enabled := true;
	btnExclude.Enabled := true;
	btnInvert.Enabled := true;
	btnAbort.Enabled := false;
	btnOK.Enabled := true;
	btnCancel.Enabled := true;
	pbrProgress.Position := 0;

	Application.MessageBox( '𒆒f܂', 'hXPW[\̈ꊇ', MB_OK);
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServerSchedulesPublisher.Selector_Change(Sender: TObject);
begin
	Server.Close;
	case cboCategory.ItemIndex of
	0 :
		begin
			SourceOf_Server.ParamByName( 'datFrom').AsDate := FPivot;
			SourceOf_Server.ParamByName( 'datTo').AsDate := FPivot;
			pnlTimeStamp.Caption := FormatDateTime( 'gg ee "N" yyyy "N" MM "" dd "" (ddd)', FPivot);
		end;
	1 :
		begin
			SourceOf_Server.ParamByName( 'datFrom').AsDate := StartOfTheWeek( FPivot);
			SourceOf_Server.ParamByName( 'datTo').AsDate := DateOf( EndOfTheWeek( FPivot));
			pnlTimeStamp.Caption := FormatDateTime( 'gg ee "N" yyyy "N" MM "" dd " ()`()"', StartOfTheWeek( FPivot));
		end;
	2 :
		begin
			SourceOf_Server.ParamByName( 'datFrom').AsDate := StartOfTheMonth( FPivot);
			SourceOf_Server.ParamByName( 'datTo').AsDate := DateOf( EndOfTheMonth( FPivot));
			pnlTimeStamp.Caption := FormatDateTime( 'gg ee "N" yyyy "N" MM ""', FPivot);
		end;
	end;
	SourceOf_Server.ParamByName( 'datAt').AsDate := Today;
	Server.Open;
	// update query

	btnBrowse.Enabled := not Server.IsEmpty;
	btnExclude.Enabled := not Server.IsEmpty;
	btnInvert.Enabled := not Server.IsEmpty;
end;

procedure TServerSchedulesPublisher.btnTimeStamp_Click(Sender: TObject);
begin
	if ChooseDate( FPivot) then Selector_Change( Sender);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServerSchedulesPublisher.gridServer_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
	selected : Boolean;
	dummy : Integer;
begin
	selected := gridServer.SelectedRows.Find( Server.Bookmark, dummy);

	with gridServer.Canvas do if not IntToBool( Server.FieldByName( 'blnAvailable').AsInteger) then
	begin
		Font.Color := IfThen( selected, clHighlightText, clWindowText);
		Brush.Color := IfThen( selected, clSelectedExcluded, clDefaultExcluded);
	end
	else
	begin
		Font.Color := IfThen( selected, clHighlightText, Column.Font.Color);
		Brush.Color := IfThen( selected, clHighlight, Column.Color);
	end;

	if Column.Alignment = taRightJustify then
	begin
		gridServer.Canvas.TextRect(
			Rect, Rect.Right - 2 - gridServer.Canvas.TextWidth( Column.Field.AsString), Rect.Top + 2, Column.Field.AsString
		);
	end
	else
	begin
		gridServer.Canvas.TextRect(
			Rect, Rect.Left + 2, Rect.Top + 2, Column.Field.AsString
		);
	end;
end;

procedure TServerSchedulesPublisher.gridServer_TitleClick(Column: TColumn);
var
	ACol : Integer;
begin
	if Column.Title.Color = clMenu then exit;

	if Column.FieldName = 'STRCODE' then Server.IndexFieldNames := 'strCode;strNameRead;keyInstance';
	if Column.FieldName = 'STRNAMEREAD' then Server.IndexFieldNames := 'strNameRead;strCode;keyInstance';
	if Column.FieldName = 'STRBRANCH' then Server.IndexFieldNames := 'strBranch;strNameRead;strName;keyInstance';
	if Column.FieldName = 'STRREGION' then Server.IndexFieldNames := 'strRegion;strNameRead;strName;keyInstance';
	if Column.FieldName = 'STRFAXNUMBER1' then Server.IndexFieldNames := 'strFaxNumber1;strNameRead;strName;keyInstance';

	with gridServer.Columns do for ACol := 0 to Count - 1 do Items[ ACol].Color := clWindow;

	Column.Color := clSorted;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServerSchedulesPublisher.chkPublishToFax_Click(Sender: TObject);
begin
	if chkPublishToFax.Checked then
		Server.Filter := 'strFaxNumber1 <> '''''
	else
		Server.Filter := '';
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServerSchedulesPublisher.btnBrowse_Click( Sender : TObject);
begin
	with Server do if not IsEmpty then TServerSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
end;

procedure TServerSchedulesPublisher.btnExclude_Click( Sender : TObject);
var
	index : Integer;
begin
	if Server.IsEmpty then exit;

	Server.DisableControls;
	for index := 0 to gridServer.SelectedRows.Count - 1 do
	begin
		with Server do
		begin
			Bookmark := gridServer.SelectedRows.Items[ index];
			Edit;
			FieldByName( 'blnAvailable').AsInteger := BoolToInt( not IntToBool( FieldByName( 'blnAvailable').AsInteger));
			Post;
		end;
	end;
	gridServer.SelectedRows.Refresh;
	gridServer.SelectedRows.CurrentRowSelected := true;
	Server.EnableControls;
end;

procedure TServerSchedulesPublisher.btnInvert_Click(Sender: TObject);
var
	defaultRecNo : Integer;
begin
	with Server do
	begin
		if IsEmpty then exit;
		defaultRecNo := RecNo;
		DisableControls;
		First;
		while not EOF do
		begin
			Edit;
			FieldByName( 'blnAvailable').AsInteger := BoolToInt( not IntToBool( FieldByName( 'blnAvailable').AsInteger));
			Post;
			Next;
		end;
		RecNo := defaultRecNo;
		EnableControls;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServerSchedulesPublisher.btnAbort_Click(Sender: TObject);
begin
	FPrinting := false;
end;

end.
