unit Report_Billings;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  MainDataStore;

type
  TBillingsReport = class(TReportTemplate)

    bTitle: TFlexReportBand;
    FlexReportPanel1: TFlexReportPanel;
    rTimeStamp: TFlexReportDateTime;
    bFooter: TFlexReportBand;
    bSummary: TFlexReportBand;
    bTable: TFlexReportLayout;
    bTableHeader: TFlexReportBand;
    FlexReportPanel3: TFlexReportPanel;
    FlexReportPanel4: TFlexReportPanel;
    bTableDetail: TFlexReportBand;
    rPublished: TFlexReportPanel;
    rCode: TFlexReportPanel;
    rPageNumber: TFlexReportPageNumber;
    rScheduleFrom: TFlexReportDateTime;
    rScheduleTo: TFlexReportDateTime;
    FlexReportPanel2: TFlexReportPanel;
    FlexReportPanel5: TFlexReportPanel;
    rBilling: TFlexReportDecimal;
    rMargin: TFlexReportDecimal;
    MainTransaction: TIBTransaction;
    SourceOf_Billing: TIBQuery;
    ProviderOf_Billing: TDataSetProvider;
    Billing: TClientDataSet;
    rMigrationCash: TFlexReportDecimal;
    rTransferCash: TFlexReportDecimal;
    rCareCash: TFlexReportDecimal;
    rMenageCash: TFlexReportDecimal;
    rName: TFlexReportPanel;
    FlexReportPanel7: TFlexReportPanel;
    FlexReportPanel8: TFlexReportPanel;
    FlexReportPanel9: TFlexReportPanel;
    FlexReportPanel10: TFlexReportPanel;
    FlexReportPanel12: TFlexReportPanel;
    FlexReportPanel15: TFlexReportPanel;
    rCareTotal: TFlexReportDecimal;
    rMenageTotal: TFlexReportDecimal;
    rMigrationTotal: TFlexReportDecimal;
    rTransferTotal: TFlexReportDecimal;
    rBillingTotal: TFlexReportDecimal;
    rMarginTotal: TFlexReportDecimal;
    rCount: TFlexReportDecimal;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);

    procedure bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
  private
    { Private 錾 }
    FFrom : TDate;
    FTo : TDate;

    FCareTotal : Currency;
    FMenageTotal : Currency;
    FMigrationTotal : Currency;
    FTransferTotal : Currency;

    FMarginTotal : Currency;
    FBillingTotal : Currency;
  public
    { Public 錾 }
    constructor Prepare( datFrom, datTo : TDate; collation : String);
  end;

var
  BillingsReport: TBillingsReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TBillingsReport.Prepare( datFrom, datTo : TDate; collation : String);
begin
	inherited Create( Screen.ActiveForm);

	FFrom := datFrom;
	FTo := datTo;

	SourceOf_Billing.ParamByName( 'datFrom').AsDate := FFrom;
	SourceOf_Billing.ParamByName( 'datTo').AsDate := FTo;
	Billing.IndexFieldNames := collation;
	Billing.Open;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingsReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Billing.IsEmpty);
end;

procedure TBillingsReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bSummary.Printed);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBillingsReport.bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bTitle.Printed);

	rScheduleFrom.Value := FFrom;
	rScheduleTo.Value := FTo;

	FCareTotal := 0;
	FMenageTotal := 0;
	FMigrationTotal := 0;
	FTransferTotal := 0;

	FMarginTotal := 0;
	FBillingTotal := 0;
end;

procedure TBillingsReport.bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Billing.Eof);
end;

procedure TBillingsReport.bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Billing.Eof);
	printif( Report.AvailableHeight > bTableDetail.Height + bFooter.Height);

	with Billing do
	begin
		rCode.Lines.Text := FieldByName( 'strCode').AsString;
		rName.Lines.Text := FieldByName( 'strName').AsString;

		rCareCash.Value := FieldByName( 'intCareCash').AsCurrency;
		rMenageCash.Value := FieldByName( 'intMenageCash').AsCurrency;
		rMigrationCash.Value := FieldByName( 'intMigrationCash').AsCurrency;
		rTransferCash.Value := FieldByName( 'intTransferCash').AsCurrency;

		rMargin.Value := FieldByName( 'intMargin').AsCurrency;
		rBilling.Value := FieldByName( 'intBilling').AsCurrency;

		rPublished.Lines.Text := FormatDateTime( 'MM""dd""', FieldByName( 'datPublished').AsDateTime);
	end;

	FCareTotal := FCareTotal + rCareCash.Value;
	FMenageTotal := FMenageTotal + rMenageCash.Value;
	FMigrationTotal := FMigrationTotal + rMigrationCash.Value;
	FTransferTotal := FTransferTotal + rTransferCash.Value;

	FMarginTotal := FMarginTotal + rMargin.Value;
	FBillingTotal := FBillingTotal + rBilling.Value;

	Billing.Next;
end;

procedure TBillingsReport.bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( Billing.Eof);
	printif( Report.AvailableHeight > bSummary.Height + bFooter.Height);

	rCareTotal.Value := FCareTotal;
	rMenageTotal.Value := FMenageTotal;
	rMigrationTotal.Value := FMigrationTotal;
	rTransferTotal.Value := FTransferTotal;

	rMarginTotal.Value := FMarginTotal;
	rBillingTotal.Value := FBillingTotal;

	rCount.Value := Billing.RecordCount;
end;

end.
