unit Report_Branches;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  MainDataStore, Misc_Utilities, Misc_Constants;

type
  TBranchesReport = class(TReportTemplate)
    MainTransaction: TIBTransaction;
    SourceOf_Branch: TIBQuery;

    bTitle: TFlexReportBand;
    FlexReportPanel1: TFlexReportPanel;
    rTimeStamp: TFlexReportDateTime;
    bFooter: TFlexReportBand;
    rPageNumber: TFlexReportPageNumber;
    bSummary: TFlexReportBand;
    FlexReportPanel11: TFlexReportPanel;
    rTotalCount: TFlexReportDecimal;
    bTable: TFlexReportLayout;
    bTableHeader: TFlexReportBand;
    FlexReportPanel5: TFlexReportPanel;
    bTableDetail: TFlexReportBand;
    rName: TFlexReportPanel;
    FlexReportPanel2: TFlexReportPanel;
    rAvailableFrom: TFlexReportDateTime;
    rAvailableTo: TFlexReportDateTime;
    ProviderOf_Branch: TDataSetProvider;
    Branch: TClientDataSet;
    rCatalogue: TFlexReportPanel;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);

    procedure bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
  private
    { Private 錾 }
  public
    { Public 錾 }
    constructor Prepare( typCatalogue : Integer);
  end;

var
  BranchesReport: TBranchesReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TBranchesReport.Prepare( typCatalogue : Integer);
begin
	inherited Create( Screen.ActiveForm);

	Branch.Filter := CatalogueFilter( typCatalogue);
	Branch.Open;

	rCatalogue.Lines.Text := aCatalogue[ typCatalogue];
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBranchesReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Branch.IsEmpty);
end;

procedure TBranchesReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bSummary.Printed);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBranchesReport.bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bTitle.Printed);
end;

procedure TBranchesReport.bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Branch.Eof);
end;

procedure TBranchesReport.bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Branch.Eof);
	printif( Report.AvailableHeight > bTableDetail.Height + bFooter.Height);

	with Branch do
	begin
		rName.Lines.Text := FieldByName( 'strName').AsString;
		rAvailableFrom.Value := FieldByName( 'datAvailableFrom').AsDateTime;
		rAvailableTo.Value := FieldByName( 'datAvailableTo').AsDateTime;
	end;

	Branch.Next;
end;

procedure TBranchesReport.bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( Branch.Eof);
	printif( Report.AvailableHeight > bSummary.Height + bFooter.Height);

	rTotalCount.Value := Branch.RecordCount;
end;

end.
