unit Report_CandidatesCount;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  Math, StrUtils, MainDataStore, Misc_Utilities, Misc_Constants, DBLocal, DBLocalI;

const
  GROUP_BY_PROFILE_FROM = 0;
  GROUP_BY_PROFILE_TO = 1;
  GROUP_BY_NOTICE_FROM = 2;
  GROUP_BY_NOTICE_TO = 3;

type
  TCandidatesCountReport = class(TReportTemplate)

    bTitle: TFlexReportBand;
    rTitle: TFlexReportPanel;
    rTimeStamp: TFlexReportDateTime;
    bFooter: TFlexReportBand;
    bSummary: TFlexReportBand;
    bTable: TFlexReportLayout;
    bTableHeader: TFlexReportBand;
    bTableDetail: TFlexReportBand;
    rPageNumber: TFlexReportPageNumber;
    FlexReportPanel4: TFlexReportPanel;
    rYearMonth: TFlexReportPanel;
    FlexReportPanel21: TFlexReportPanel;
    FlexReportPanel11: TFlexReportPanel;
    rTotalCount: TFlexReportDecimal;
    MainTransaction: TIBTransaction;
    SourceOf_CountByProfileFrom: TIBQuery;
    ProviderOf_Count: TDataSetProvider;
    Count: TClientDataSet;
    rCount: TFlexReportDecimal;
    rGraph: TFlexReportPanel;
    FlexReportPanel2: TFlexReportPanel;
    SourceOf_CountByProfileTo: TIBQuery;
    SourceOf_CountByNoticeFrom: TIBQuery;
    SourceOf_CountByNoticeTo: TIBQuery;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);

    procedure bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
  private
    { Private 錾 }
    FCurrMonth : TDate;
    FLastMonth : TDate;

    FMaxCount : Integer;
    FTotalCount : Integer;
  public
    { Public 錾 }
    constructor Prepare( refBranch, refRegion : Integer; strTitle, strContent : String; typCategory, typPivot : Integer; datFrom, datTo : TDate; strReportName : String);
  end;

var
  CandidatesCountReport: TCandidatesCountReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TCandidatesCountReport.Prepare(
	refBranch, refRegion : Integer;
	strTitle, strContent : String;
	typCategory, typPivot : Integer;
	datFrom, datTo : TDate;
	strReportName : String
);
begin
	inherited Create( Screen.ActiveForm);

	case typPivot of
	GROUP_BY_PROFILE_FROM : ProviderOf_Count.DataSet := SourceOf_CountByProfileFrom;
	  GROUP_BY_PROFILE_TO : ProviderOf_Count.DataSet := SourceOf_CountByProfileTo;
	 GROUP_BY_NOTICE_FROM : ProviderOf_Count.DataSet := SourceOf_CountByNoticeFrom;
	   GROUP_BY_NOTICE_TO : ProviderOf_Count.DataSet := SourceOf_CountByNoticeTo;
	end;

	with ProviderOf_Count.DataSet as TIBQuery do
	begin
		ParamByName( 'keyBranch').AsInteger := refBranch;
		ParamByName( 'keyRegion').AsInteger := refRegion;
		ParamByName( 'strTitle').AsString := strTitle;
		ParamByName( 'strContent').AsString := strContent;
		ParamByName( 'typCategory').AsInteger := typCategory;
		ParamByName( 'datFrom').AsDate := datFrom;
		ParamByName( 'datTo').AsDate := datTo;
	end;
	Count.Open;

	FCurrMonth := StartOfTheMonth( datFrom);
	FLastMonth := StartOfTheMonth( datTo);

	Caption := strReportName;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCandidatesCountReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	FMaxCount := 0;
	FTotalCount := 0;

	Count.First;
	while not Count.Eof do
	begin
		FMaxCount := Max( FMaxCount, Count.FieldByName( 'intCount').AsInteger);
		FTotalCount := FTotalCount + Count.FieldByName( 'intCount').AsInteger;
		Count.Next;
	end;
	Count.First;
end;

procedure TCandidatesCountReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bSummary.Printed);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCandidatesCountReport.bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bTitle.Printed);

	rTitle.Lines.Text := Caption;
end;

procedure TCandidatesCountReport.bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( FCurrMonth <= FLastMonth);
end;

procedure TCandidatesCountReport.bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( FCurrMonth <= FLastMonth);
	printif( Report.AvailableHeight > bTableDetail.Height + bFooter.Height);

	rYearMonth.Lines.Text := FormatDateTime( 'gg ee "N" yyyy "N" MM ""', FCurrMonth);

	if ( Count.FieldByName( 'intYear').AsInteger = YearOf( FCurrMonth))
		and ( Count.FieldByName( 'intMonth').AsInteger = MonthOf( FCurrMonth))
	then
	begin
		rCount.Value := Count.FieldByName( 'intCount').AsInteger;
		rGraph.Lines.Text := StringOfChar( '*', Round( rCount.Value * 54 / FMaxCount));
		Count.Next;
	end
	else
	begin
		rCount.Value := 0;
		rGraph.Lines.Text := '';
	end;

	FCurrMonth := IncMonth( FCurrMonth);
end;

procedure TCandidatesCountReport.bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( FCurrMonth > FLastMonth);
	printif( Report.AvailableHeight > bSummary.Height + bFooter.Height);

	rTotalCount.Value := FTotalCount;
end;

end.
