unit Report_DailyServerSchedule;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  StrUtils, MainDataStore, Misc_Utilities, Misc_Constants;

type
  TDailyServerScheduleReport = class(TReportTemplate)
    MainTransaction: TIBTransaction;
    Profile: TIBQuery;
    SourceOf_Schedule: TIBQuery;
    ProviderOf_Schedule: TDataSetProvider;
    Schedule: TClientDataSet;
    bFooter: TFlexReportBand;
    rPageNumber: TFlexReportPageNumber;
    bSummary: TFlexReportBand;
    FlexReportPanel11: TFlexReportPanel;
    rTotalCount: TFlexReportDecimal;
    bTable: TFlexReportLayout;
    bTableCategory: TFlexReportBand;
    rScheduleAt: TFlexReportDateTime;
    bTitle: TFlexReportLayout;
    FlexReportBand3: TFlexReportBand;
    rName: TFlexReportPanel;
    FlexReportPanel8: TFlexReportPanel;
    FlexReportBand2: TFlexReportBand;
    FlexReportPanel13: TFlexReportPanel;
    rNameRead: TFlexReportPanel;
    FlexReportBand9: TFlexReportBand;
    FlexReportPanel7: TFlexReportPanel;
    rCode: TFlexReportPanel;
    FlexReportBand1: TFlexReportBand;
    FlexReportPanel1: TFlexReportPanel;
    rTimeStamp: TFlexReportDateTime;
    Padding: TFlexReportBand;
    rAddressRead: TFlexReportPanel;
    FlexReportPanel10: TFlexReportPanel;
    FlexReportPanel12: TFlexReportPanel;
    rAddress: TFlexReportPanel;
    rZip: TFlexReportPanel;
    FlexReportBand4: TFlexReportBand;
    aTableDetail: TFlexReportArranger;
    rMinutes: TFlexReportPanel;
    FlexReportPanel16: TFlexReportPanel;
    rSeparator: TFlexReportPanel;
    rAddressFrom: TFlexReportPanel;
    rPlaceFrom: TFlexReportPanel;
    FlexReportPanel14: TFlexReportPanel;
    rAddressTo: TFlexReportPanel;
    rPlaceTo: TFlexReportPanel;
    rService: TFlexReportPanel;
    rClient: TFlexReportPanel;
    Arrow: TImage;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);

    procedure bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure aTableDetail_BeforeArrange(Sender: TObject; ARow,
      ACol: Integer; var Arrangement: TFlexReportArrangement);
  private
    { Private 錾 }
  public
    { Public 錾 }
    constructor Prepare( keyServer : Integer; datAt : TDate);
  end;

var
  DailyServerScheduleReport: TDailyServerScheduleReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TDailyServerScheduleReport.Prepare( keyServer : Integer; datAt : TDate);
begin
	inherited Create( Screen.ActiveForm);

	Profile.ParamByName( 'keyInstance').AsInteger := keyServer;
	Profile.ParamByName( 'datAvailableAt').AsDate := Today;
	Profile.Open;

	SourceOf_Schedule.ParamByName( 'keyServer').AsInteger := keyServer;
	SourceOf_Schedule.ParamByName( 'datFrom').AsDate := datAt;
	SourceOf_Schedule.ParamByName( 'datTo').AsDate := datAt;
	Schedule.Open;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TDailyServerScheduleReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Schedule.IsEmpty);
end;

procedure TDailyServerScheduleReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bSummary.Printed);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TDailyServerScheduleReport.bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bTitle.Printed);

	with Profile do
	begin
		rCode.Lines.Text := FieldByName( 'strCode').AsString;

		rNameRead.Lines.Text := FieldByName( 'strNameRead').AsString;
		rName.Lines.Text := FieldByName( 'strName').AsString;

		rZip.Lines.Text := '' + ToZipText( FieldByName( 'refZip').AsInteger);
		rAddressRead.Lines.Text := FieldByName( 'strAddressRead').AsString;
		rAddress.Lines.Text := FieldByName( 'strAddress').AsString;
	end;

	rScheduleAt.Value := SourceOf_Schedule.ParamByName( 'datFrom').AsDate;

	Caption := Format( '%s - %s', [ Caption, Trim( rName.Lines.Text)]);
end;

procedure TDailyServerScheduleReport.bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Schedule.Eof);
end;

procedure TDailyServerScheduleReport.aTableDetail_BeforeArrange(Sender: TObject; ARow, ACol: Integer; var Arrangement: TFlexReportArrangement);

	function NameOf( strPlace : String) : String;
	begin
		result := MidStr( strPlace, Pos( '@', strPlace) + 1, 999)
	end;
var
	FromHome, ToHome : Boolean;
begin
	rMinutes.Lines.Clear;

	rPlaceFrom.Lines.Clear;
	rAddressFrom.Lines.Clear;
	rPlaceTo.Lines.Clear;
	rAddressTo.Lines.Clear;
	rService.Lines.Clear;

	rClient.Lines.Clear;

	printif( not Schedule.Eof);

	with Schedule do
	begin
		if FieldByName( 'typProgress').AsInteger = UNCLEAR_PROGRESS then
			Arrangement.Brush.Color := TColor( $D0D0D0)
		else
			Arrangement.Brush.Color := clWhite;

		if FieldByName( 'intMinutesFor').AsInteger > 0 then
		begin
			rMinutes.Lines.Add( MinutesToText( FieldByName( 'intMinutesAt').AsInteger));
			rMinutes.Lines.Add( '');
			rMinutes.Lines.Add( MinutesToText( FieldByName( 'intMinutesAt').AsInteger + FieldByName( 'intMinutesFor').AsInteger));
		end
		else if FieldByName( 'intMinutesAt').AsInteger <= FieldByName( 'intSubjectAt').AsInteger then
		begin
			rMinutes.Lines.Add( MinutesToText( FieldByName( 'intMinutesAt').AsInteger));
			rMinutes.Lines.Add( '');
			rMinutes.Lines.Add( MinutesToText( FieldByName( 'intSubjectAt').AsInteger));
		end
		else
		begin
			rMinutes.Lines.Add( MinutesToText( FieldByName( 'intMinutesAt').AsInteger));
		end;
		// assign minutes label

		FromHome := ( FieldByName( 'typPlaceFrom').AsInteger = PROFILE_ADDRESS)
			and ( FieldByName( 'refResidentFrom').AsInteger = FieldByName( 'refServer').AsInteger);

		ToHome := ( FieldByName( 'typPlaceTo').AsInteger = PROFILE_ADDRESS)
			and ( FieldByName( 'refResidentTo').AsInteger = FieldByName( 'refServer').AsInteger);

		case FieldByName( 'typSchedule').AsInteger of CARE_SCHEDULE, MENAGE_SCHEDULE :
			begin
				rPlaceFrom.Lines.Text := IfThen( FromHome, '', NameOf( FieldByName( 'strPlaceFrom').AsString));
				rAddressFrom.Lines.Text := IfThen( FromHome, '', Copy( FieldByName( 'strAddressFrom').AsString, 7, 999));

				rPlaceTo.Lines.Text := '';
				rAddressTo.Lines.Text := '';
			end;
		else
			begin
				rPlaceFrom.Lines.Text := IfThen( FromHome, '', NameOf( FieldByName( 'strPlaceFrom').AsString));
				rAddressFrom.Lines.Text := IfThen( FromHome, '', Copy( FieldByName( 'strAddressFrom').AsString, 7, 999));

				rPlaceTo.Lines.Text := IfThen( ToHome, '', NameOf( FieldByName( 'strPlaceTo').AsString));
				rAddressTo.Lines.Text := IfThen( ToHome, '', Copy( FieldByName( 'strAddressTo').AsString, 7, 999));

				Report.Draw(
					Arrangement.Left + 255,
					Arrangement.Top + 2,
					Arrangement.Left + 267,
					Arrangement.Top + 14,
					Arrow.Picture.Graphic
				);
			end;
		end;
		// assign place and minutes label

		if FieldByName( 'refClient').AsInteger <> FieldByName( 'refServer').AsInteger then
		begin
			rClient.Lines.Add( FieldByName( 'strClientCode').AsString);
			rClient.Lines.Add( FieldByName( 'strClientName').AsString);
		end
		else
			rClient.Lines.Add( '');

		if FieldByName( 'curAmountPerCount').AsCurrency + FieldByName( 'curAmountPerHour').AsCurrency > 0 then
			rClient.Lines.Add( Format( '(%s)', [
					AmountToText(
						FieldByName( 'typExchange').AsInteger,
						FieldByName( 'curAmountPerCount').AsCurrency,
						FieldByName( 'curAmountPerHour').AsCurrency,
						FieldByName( 'intMinutesFor').AsInteger
					)
				])
			);
		// assign client label

		if FieldByName( 'strNotice').AsString <> '' then
			rService.Lines.Text := Format( '%s / %s', [
				FieldByName( 'strService').AsString,
				FieldByName( 'strNotice').AsString
			])
		else
			rService.Lines.Text := FieldByName( 'strService').AsString;
		// assign notice label
	end;

	Schedule.Next;
end;

procedure TDailyServerScheduleReport.bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( Schedule.Eof);
	printif( Report.AvailableHeight > bSummary.Height + bFooter.Height);

	rTotalCount.Value := Schedule.RecordCount;
end;

end.
