unit Report_NameLabels;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  MainDataStore, Misc_Constants, Misc_Utilities;

type
  TNameLabelsReport = class(TReportTemplate)
    FlexReportBand1: TFlexReportBand;
    aNameLabel: TFlexReportArranger;
    rName: TFlexReportPanel;
    rAddress: TFlexReportPanel;
    rZip: TFlexReportPanel;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure aNameLabel_BeforeArrange(Sender: TObject; ARow, ACol: Integer;
      var Arrangement: TFlexReportArrangement);
    procedure aNameLabel_AfterArrange(Sender: TObject; ARow, ACol: Integer;
      var Arrangement: TFlexReportArrangement);
  private
    { Private 錾 }
    Profile : TDataSet;
    FPostfix : String;
  public
    { Public 錾 }
    constructor Prepare( Source : TDataSet);
  end;

var
  NameLabelsReport: TNameLabelsReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TNameLabelsReport.Prepare( Source : TDataSet);
begin
	inherited Create( Screen.ActiveForm);

	Profile := Source;
	Profile.First;
	FPostfix := ' l';
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TNameLabelsReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Profile.IsEmpty);
	rAddress.Lines.Clear;
	rName.Lines.Clear;
end;

procedure TNameLabelsReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Profile.Eof);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TNameLabelsReport.aNameLabel_BeforeArrange(Sender: TObject; ARow, ACol: Integer; var Arrangement: TFlexReportArrangement);
begin
	printif( not Profile.Eof);

	rZip.Lines.Text := '' + ToZipText( Profile.FieldByName( 'keyZip').AsInteger);
	rAddress.Lines.Add( Profile.FieldByName( 'strZipAddress').AsString);
	rAddress.Lines.Text := rAddress.Lines.Text + StringReplace( Profile.FieldByName( 'strAddress').AsString, '@', #13#10, []);
	rName.Lines.Text := Profile.FieldByName( 'strName').AsString + FPostfix;
end;

procedure TNameLabelsReport.aNameLabel_AfterArrange(Sender: TObject; ARow, ACol: Integer; var Arrangement: TFlexReportArrangement);
begin
	rZip.Lines.Clear;
	rAddress.Lines.Clear;
	rName.Lines.Clear;

	Profile.Next;
	with Profile do while ( not Eof) and ( not IntToBool( FieldByName( 'blnAvailable').AsInteger))do
	begin
		Profile.Next;
	end;
end;

end.
