unit Report_OfficialSchedule;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  MainDataStore, Misc_Constants, Misc_Utilities;

type
  TOfficialScheduleReport = class(TReportTemplate)

    bTitle: TFlexReportBand;
    FlexReportPanel1: TFlexReportPanel;
    rSchedule: TFlexReportDateTime;
    rTitle: TFlexReportPanel;
    bFooter: TFlexReportBand;
    bSummary: TFlexReportBand;
    FlexReportPanel11: TFlexReportPanel;
    rTotalCount: TFlexReportDecimal;
    bTable: TFlexReportLayout;
    bTableHeader: TFlexReportBand;
    FlexReportPanel3: TFlexReportPanel;
    FlexReportPanel4: TFlexReportPanel;
    FlexReportPanel5: TFlexReportPanel;
    bTableDetail: TFlexReportBand;
    rPageNumber: TFlexReportPageNumber;
    FlexReportPanel2: TFlexReportPanel;
    FlexReportPanel6: TFlexReportPanel;
    FlexReportPanel12: TFlexReportPanel;
    FlexReportPanel13: TFlexReportPanel;
    FlexReportPanel14: TFlexReportPanel;
    FlexReportPanel15: TFlexReportPanel;
    rTransferCount: TFlexReportDecimal;
    rEscortCount: TFlexReportDecimal;
    rMigrationCount: TFlexReportDecimal;
    FlexReportPanel16: TFlexReportPanel;
    FlexReportPanel17: TFlexReportPanel;
    rMenageCount: TFlexReportDecimal;
    rCareCount: TFlexReportDecimal;
    rHelpersCount: TFlexReportDecimal;
    rDriversCount: TFlexReportDecimal;
    FlexReportPanel18: TFlexReportPanel;
    FlexReportPanel19: TFlexReportPanel;
    MainTransaction: TIBTransaction;
    SourceOf_Schedule: TIBQuery;
    ProviderOf_Schedule: TDataSetProvider;
    Schedule: TClientDataSet;
    rDetail: TFlexReportPanel;
    rMinutes: TFlexReportPanel;
    FlexReportPanel7: TFlexReportPanel;
    rExchange: TFlexReportPanel;
    rService: TFlexReportPanel;
    FlexReportPanel9: TFlexReportPanel;
    rClientRead: TFlexReportPanel;
    rClient: TFlexReportPanel;
    rClientAddress: TFlexReportPanel;
    FlexReportPanel8: TFlexReportPanel;
    rServerRead: TFlexReportPanel;
    rServer: TFlexReportPanel;
    rServerAddress: TFlexReportPanel;
    FlexReportPanel10: TFlexReportPanel;
    rActionPlace: TFlexReportPanel;
    rActionPlace2: TFlexReportPanel;
    rNotice: TFlexReportPanel;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);

    procedure bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
  private
    { Private 錾 }
    FCareCount : Integer;
    FMenageCount : Integer;
    FMigrationCount : Integer;
    FTransferCount : Integer;
    FEscortCount : Integer;
  public
    { Public 錾 }
    constructor Prepare( datAt : TDate; optService, optProgress : Integer; strTitle : String);
  end;

var
  OfficialScheduleReport: TOfficialScheduleReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TOfficialScheduleReport.Prepare( datAt : TDate; optService, optProgress : Integer; strTitle : String);
begin
	inherited Create( Screen.ActiveForm);

	rTitle.Lines.Text := strTitle;
	SourceOf_Schedule.ParamByName( 'datAt').AsDate := datAt;
	SourceOf_Schedule.ParamByName( 'optService').AsInteger := optService;
	SourceOf_Schedule.ParamByName( 'optProgress').AsInteger := optProgress;
	Schedule.Open;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TOfficialScheduleReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Schedule.IsEmpty);
end;

procedure TOfficialScheduleReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bSummary.Printed);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TOfficialScheduleReport.bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bTitle.Printed);

	FCareCount := 0;
	FMenageCount := 0;
	FMigrationCount := 0;
	FTransferCount := 0;
	FEscortCount := 0;

	rSchedule.Value := SourceOf_Schedule.ParamByName( 'datAt').AsDate;
end;

procedure TOfficialScheduleReport.bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Schedule.Eof);
end;

procedure TOfficialScheduleReport.bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
var
	strPlaceFrom, strPlaceTo : String;
begin
	printif( not Schedule.Eof);
	printif( Report.AvailableHeight > bTableDetail.Height + bFooter.Height);

	with Schedule do
	begin
		if FieldByName( 'typProgress').AsInteger = UNCLEAR_PROGRESS then
			rDetail.Brush.Color := TColor( $00BBBBBB)
		else
			rDetail.Brush.Color := clWhite;
		// select row color

		rService.Lines.Text := FieldByName( 'strService').AsString;

		if FieldByName( 'curAmountPerCount').AsCurrency + FieldByName( 'curAmountPerHour').AsCurrency > 0 then
			rExchange.Lines.Text := AmountToText(
				FieldByName( 'typExchange').AsInteger,
				FieldByName( 'curAmountPerCount').AsCurrency,
				FieldByName( 'curAmountPerHour').AsCurrency,
				FieldByName( 'intMinutesFor').AsInteger
			)
		else
			rExchange.Lines.Text := '';

		rNotice.Lines.Text := FieldByName( 'strNotice').AsString;
		// assign service labels

		rMinutes.Lines.Clear;
		if FieldByName( 'intMinutesFor').AsInteger > 0 then
		begin
			rMinutes.Lines.Add( MinutesToText( FieldByName( 'intMinutesAt').AsInteger));
			rMinutes.Lines.Add( MinutesToText( FieldByName( 'intMinutesAt').AsInteger + FieldByName( 'intMinutesFor').AsInteger));
		end
		else if FieldByName( 'intMinutesAt').AsInteger <= FieldByName( 'intSubjectAt').AsInteger then
		begin
			rMinutes.Lines.Add( MinutesToText( FieldByName( 'intMinutesAt').AsInteger));
			rMinutes.Lines.Add( MinutesToText( FieldByName( 'intSubjectAt').AsInteger));
		end
		else
		begin
			rMinutes.Lines.Add( MinutesToText( FieldByName( 'intMinutesAt').AsInteger));
		end;
		// assign minutes label

		if ( FieldByName( 'typPlaceFrom').AsInteger = PROFILE_ADDRESS)
		    and ( FieldByName( 'refResidentFrom').AsInteger = FieldByName( 'refClient').AsInteger) then
			strPlaceFrom := 'p҂̎'
		else
			strPlaceFrom := FieldByName( 'strPlaceFrom').AsString;

		if ( FieldByName( 'typPlaceTo').AsInteger = PROFILE_ADDRESS)
		    and ( FieldByName( 'refResidentTo').AsInteger = FieldByName( 'refClient').AsInteger) then
			strPlaceTo := 'p҂̎'
		else
			strPlaceTo := FieldByName( 'strPlaceTo').AsString;
		// prepare place label

		if FieldByName( 'refAddressFrom').AsInteger = FieldByName( 'refAddressTo').AsInteger then
		begin
			rActionPlace.Lines.Text := strPlaceFrom;
			rActionPlace2.Lines.Text := '';
		end
		else if ( FieldByName( 'typPlaceFrom').AsInteger = PROFILE_ADDRESS)
		    and ( FieldByName( 'refResidentFrom').AsInteger = FieldByName( 'refClient').AsInteger) then
		begin
			rActionPlace.Lines.Text := '@' + strPlaceTo;
			rActionPlace2.Lines.Text := '';
		end
		else if ( FieldByName( 'typPlaceTo').AsInteger = PROFILE_ADDRESS)
		    and ( FieldByName( 'refResidentTo').AsInteger = FieldByName( 'refClient').AsInteger) then
		begin
			rActionPlace.Lines.Text := '' + strPlaceFrom;
			rActionPlace2.Lines.Text := '';
		end
		else
		begin
			rActionPlace.Lines.Text := '' + strPlaceFrom;
			rActionPlace2.Lines.Text := strPlaceTo;
		end;
		// assign place label

		rClientRead.Lines.Text := FieldByName( 'strClientRead').AsString;
		rClient.Lines.Text := FieldByName( 'strClient').AsString;
		rClientAddress.Lines.Text := FieldByName( 'strClientAddress').AsString;
		// assign labels at client col

		rServerRead.Lines.Text := FieldByName( 'strServerRead').AsString;
		rServer.Lines.Text := FieldByName( 'strServer').AsString;
		rServerAddress.Lines.Text := FieldByName( 'strServerAddress').AsString;
		// assign labels at server col

		case FieldByName( 'typSchedule').AsInteger of
		CARE_SCHEDULE : Inc( FCareCount);
		MENAGE_SCHEDULE : Inc( FMenageCount);
		MIGRATION_SCHEDULE : Inc( FMigrationCount);
		TRANSFER_SCHEDULE :
			if ( not FieldByName( 'refSubject').IsNull) and ( FieldByName( 'typSubject').AsInteger <> TRANSFER_SCHEDULE) then
				Inc( FEscortCount)
			else
				Inc( FTransferCount);
		end;
	end;

	Schedule.Next;
end;

procedure TOfficialScheduleReport.bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( Schedule.Eof);
	printif( Report.AvailableHeight > bSummary.Height + bFooter.Height);

	rCareCount.Value := FCareCount;
	rMenageCount.Value := FMenageCount;
	rHelpersCount.Value := FCareCount + FMenageCount;

	rMigrationCount.Value := FMigrationCount;
	rTransferCount.Value := FTransferCount;
	rEscortCount.Value := FEscortCount;
	rDriversCount.Value := FMigrationCount + FTransferCount + FEscortCount;

	rTotalCount.Value := Schedule.RecordCount;
end;

end.
