unit Report_Payback;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  MainDataStore, Misc_Utilities, Misc_Constants;

type
  TPaybackReport = class(TReportTemplate)
    MainTransaction: TIBTransaction;
    Payback: TIBQuery;
    Proof: TIBQuery;

    bFooter: TFlexReportBand;
    rPageNumber: TFlexReportPageNumber;
    bSummary: TFlexReportBand;
    bTable: TFlexReportLayout;
    bTableCategory: TFlexReportBand;
    bTableDetail: TFlexReportBand;
    bTableFooter: TFlexReportBand;
    bTableHeader: TFlexReportBand;
    FlexReportPanel5: TFlexReportPanel;
    FlexReportPanel4: TFlexReportPanel;
    rScheduleAt: TFlexReportDateTime;
    FlexReportPanel7: TFlexReportPanel;
    bTitle: TFlexReportLayout;
    FlexReportBand1: TFlexReportBand;
    FlexReportPanel1: TFlexReportPanel;
    rTimeStamp: TFlexReportDateTime;
    rPaybackCode: TFlexReportInteger;
    FlexReportBand9: TFlexReportBand;
    FlexReportPanel2: TFlexReportPanel;
    rCode: TFlexReportPanel;
    FlexReportLayout1: TFlexReportLayout;
    FlexReportBand2: TFlexReportBand;
    FlexReportPanel3: TFlexReportPanel;
    rNameRead: TFlexReportPanel;
    FlexReportBand3: TFlexReportBand;
    rName: TFlexReportPanel;
    FlexReportPanel6: TFlexReportPanel;
    FlexReportLayout2: TFlexReportLayout;
    FlexReportBand4: TFlexReportBand;
    FlexReportPanel8: TFlexReportPanel;
    rAddressRead: TFlexReportPanel;
    FlexReportBand5: TFlexReportBand;
    FlexReportPanel9: TFlexReportPanel;
    FlexReportPanel10: TFlexReportPanel;
    rAddress: TFlexReportPanel;
    rZip: TFlexReportPanel;
    bPoint: TFlexReportBand;
    FlexReportBand7: TFlexReportBand;
    FlexReportPanel13: TFlexReportPanel;
    FlexReportBand8: TFlexReportBand;
    FlexReportPanel15: TFlexReportPanel;
    rPublished: TFlexReportDateTime;
    rScheduleTo: TFlexReportDateTime;
    rScheduleFrom: TFlexReportDateTime;
    FlexReportPanel12: TFlexReportPanel;
    rPoint: TFlexReportDecimal;
    FlexReportPanel14: TFlexReportPanel;
    FlexReportPanel16: TFlexReportPanel;
    FlexReportPanel17: TFlexReportPanel;
    rTransferPoint: TFlexReportDecimal;
    FlexReportPanel18: TFlexReportPanel;
    FlexReportPanel19: TFlexReportPanel;
    rMenagePoint: TFlexReportDecimal;
    Padding: TFlexReportBand;
    rDetail: TFlexReportPanel;
    rExchange: TFlexReportPanel;
    rService: TFlexReportPanel;
    FlexReportPanel20: TFlexReportPanel;
    FlexReportPanel11: TFlexReportPanel;
    rTotalCount: TFlexReportDecimal;
    rCenterCall: TFlexReportPanel;
    rCenterName: TFlexReportPanel;
    rCenterLocation: TFlexReportPanel;
    Center: TIBQuery;
    rCarePoint: TFlexReportDecimal;
    FlexReportPanel21: TFlexReportPanel;
    FlexReportPanel22: TFlexReportPanel;
    rMigrationPoint: TFlexReportDecimal;
    bCash: TFlexReportBand;
    FlexReportPanel23: TFlexReportPanel;
    rSummary: TFlexReportPanel;
    rMinutes: TFlexReportPanel;
    rLocation: TFlexReportPanel;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);

    procedure bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTableCategory_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
  private
    { Private 錾 }
  public
    { Public 錾 }
    constructor Prepare( keyInstance : Integer);
  end;

var
  PaybackReport: TPaybackReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TPaybackReport.Prepare( keyInstance : Integer);
begin
	inherited Create( Screen.ActiveForm);

	Payback.ParamByName( 'keyInstance').AsInteger := keyInstance;
	Payback.Open;

	Proof.ParamByName( 'keyPayback').AsInteger := keyInstance;
	Proof.Open;

	Center.Open;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Payback.IsEmpty);
end;

procedure TPaybackReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bSummary.Printed);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackReport.bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bTitle.Printed);

	with Payback do
	begin
		rPaybackCode.Value := FieldByName( 'keyInstance').AsInteger;

		rPublished.Value := FieldByName( 'datPublished').AsDateTime;
		rScheduleFrom.Value := FieldByName( 'datMonthFirstday').AsDateTime;
		rScheduleTo.Value := FieldByName( 'datMonthLastday').AsDateTime;

		rCode.Lines.Text := FieldByName( 'strCode').AsString;

		rNameRead.Lines.Text := FieldByName( 'strNameRead').AsString;
		rName.Lines.Text := FieldByName( 'strName').AsString;

		rZip.Lines.Text := '' + ToZipText( FieldByName( 'refZip').AsInteger);
		rAddressRead.Lines.Text := FieldByName( 'strAddressRead').AsString;
		rAddress.Lines.Text := FieldByName( 'strAddress').AsString;

		rCarePoint.Value := FieldByName( 'curCarePoint').AsCurrency;
		rMenagePoint.Value := FieldByName( 'curMenagePoint').AsCurrency;
		rMigrationPoint.Value := FieldByName( 'curMigrationPoint').AsCurrency;
		rTransferPoint.Value := FieldByName( 'curTransferPoint').AsCurrency;

		rPoint.Value := FieldByName( 'curPoint').AsCurrency;

		if FieldByName( 'intMargin').AsCurrency > 0 then
			rSummary.Lines.Text := Format( ' %0.2n _ ~ %0.0n ~ | %0.0n ~ (萔)  %0.0n ~', [
				FieldByName( 'curPoint').AsCurrency,
				FieldByName( 'intPricePerPoint').AsCurrency,
				FieldByName( 'intMargin').AsCurrency,
				CurrToMoney( FieldByName( 'curPoint').AsCurrency * FieldByName( 'intPricePerPoint').AsCurrency)
					- FieldByName( 'intMargin').AsCurrency
			])
		else
			rSummary.Lines.Text := Format( ' %0.2n _ ~ %0.0n ~  %0.0n ~', [
				FieldByName( 'curPoint').AsCurrency,
				FieldByName( 'intPricePerPoint').AsCurrency,
				CurrToMoney( FieldByName( 'curPoint').AsCurrency * FieldByName( 'intPricePerPoint').AsCurrency)
			]);
	end;

	rScheduleAt.Value := 0; // see bTableCategory_BeforePrint
end;

procedure TPaybackReport.bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Proof.Eof);
	printif( Report.AvailableHeight > bTableCategory.Height + bTableHeader.Height + bTableDetail.Height + bFooter.Height);
end;

procedure TPaybackReport.bTableCategory_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( rScheduleAt.Value <> Proof.FieldByName( 'datSchedule').AsDateTime);

	rScheduleAt.Value := Proof.FieldByName( 'datSchedule').AsDateTime;
end;

procedure TPaybackReport.bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Proof.Eof);
	printif( rScheduleAt.Value = Proof.FieldByName( 'datSchedule').AsDateTime);
	printif( Report.AvailableHeight > bTableDetail.Height + bFooter.Height);

	with Proof do
	begin
		rService.Lines.Text := FieldByName( 'strService').AsString;

		case FieldByName( 'typSchedule').AsInteger of
		CARE_SCHEDULE, MENAGE_SCHEDULE :
			begin
				rMinutes.Lines.Text := RangeToText( FieldByName( 'intMinutesAt').AsInteger, FieldByName( 'intMinutesFor').AsInteger);
				rLocation.Lines.Text := Format( '%s%s', [
					FieldByName( 'strClient').AsString,
					FieldByName( 'strAddressFrom').AsString
				]);
			end;

		MIGRATION_SCHEDULE, TRANSFER_SCHEDULE :
			begin
				rMinutes.Lines.Text := MinutesToText( FieldByName( 'intMinutesAt').AsInteger);
				rLocation.Lines.Text := Format( '%s%s%s', [
					FieldByName( 'strClient').AsString,
					FieldByName( 'strAddressFrom').AsString,
					FieldByName( 'strAddressTo').AsString
				]);
			end;
		end;

		rExchange.Lines.Text := AmountToText(
			FieldByName( 'typExchange').AsInteger,
			FieldByName( 'curAmountPerCount').AsCurrency,
			FieldByName( 'curAmountPerHour').AsCurrency,
			FieldByName( 'intMinutesFor').AsInteger
		);
	end;

	Proof.Next;
end;

procedure TPaybackReport.bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( Proof.Eof);
	printif( Report.AvailableHeight > bSummary.Height + bFooter.Height);

	rTotalCount.Value := Proof.RecordCount;

	with Center do
	begin
		rCenterLocation.Lines.Strings[ 0] := Format( '%s@%s%s', [
			ToZipText( FieldByName( 'refZip').AsInteger),
			FieldByName( 'strZipAddress').AsString,
			FieldByName( 'strAddress').AsString
		]);
		rCenterLocation.Lines.Strings[ 1] := FieldByName( 'strLegalName').AsString;
		rCenterName.Lines.Text := FieldByName( 'strTradeName').AsString;

		if FieldByName( 'strPhoneNumber2').AsString <> '' then
			rCenterCall.Lines.Strings[ 0] := Format( 'dbF%s & %s', [
				FieldByName( 'strPhoneNumber1').AsString,
				FieldByName( 'strPhoneNumber2').AsString
			])
		else
			rCenterCall.Lines.Strings[ 0] := Format( 'dbF%s', [
				FieldByName( 'strPhoneNumber1').AsString
			]);

		if FieldByName( 'strFaxNumber2').AsString <> '' then
			rCenterCall.Lines.Strings[ 1] := Format( 'FAXF%s & %s', [
				FieldByName( 'strFaxNumber1').AsString,
				FieldByName( 'strFaxNumber2').AsString
			])
		else
			rCenterCall.Lines.Strings[ 1] := Format( 'FAXF%s', [
				FieldByName( 'strFaxNumber1').AsString
			]);
	end;
end;

end.
