unit Report_PickupSchedule;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  MainDataStore, Misc_Constants, Misc_Utilities;

type
  TPickupScheduleReport = class(TReportTemplate)
    bFooter: TFlexReportBand;
    rPageNumber: TFlexReportPageNumber;
    MainTransaction: TIBTransaction;
    SourceOf_Schedule: TIBQuery;
    ProviderOf_Schedule: TDataSetProvider;
    Schedule: TClientDataSet;
    bTitle: TFlexReportBand;
    FlexReportPanel1: TFlexReportPanel;
    rSchedule: TFlexReportDateTime;
    bSummary: TFlexReportBand;
    FlexReportPanel11: TFlexReportPanel;
    rTotalCount: TFlexReportDecimal;
    bTable: TFlexReportLayout;
    bTableHeader: TFlexReportBand;
    FlexReportPanel3: TFlexReportPanel;
    FlexReportPanel5: TFlexReportPanel;
    FlexReportPanel2: TFlexReportPanel;
    FlexReportPanel6: TFlexReportPanel;
    bTableDetail: TFlexReportBand;
    rMinutes: TFlexReportPanel;
    FlexReportPanel10: TFlexReportPanel;
    rActionPlace: TFlexReportPanel;
    rActionPlace2: TFlexReportPanel;
    FlexReportPanel9: TFlexReportPanel;
    rClientRead: TFlexReportPanel;
    rClient: TFlexReportPanel;
    rService: TFlexReportPanel;
    FlexReportPanel8: TFlexReportPanel;
    rServerRead: TFlexReportPanel;
    rServer: TFlexReportPanel;
    rNotice: TFlexReportPanel;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);

    procedure bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
  private
    { Private 錾 }
  public
    { Public 錾 }
    constructor Prepare( datAt : TDate);
  end;

var
  PickupScheduleReport: TPickupScheduleReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TPickupScheduleReport.Prepare( datAt : TDate);
begin
	inherited Create( Screen.ActiveForm);

	SourceOf_Schedule.ParamByName( 'datAt').AsDate := datAt;
	Schedule.Open;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPickupScheduleReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Schedule.IsEmpty);
end;

procedure TPickupScheduleReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bSummary.Printed);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPickupScheduleReport.bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bTitle.Printed);

	rSchedule.Value := SourceOf_Schedule.ParamByName( 'datAt').AsDate;
end;

procedure TPickupScheduleReport.bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Schedule.Eof);
end;

procedure TPickupScheduleReport.bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
var
	strPlaceFrom, strPlaceTo : String;
begin
	printif( not Schedule.Eof);
	printif( Report.AvailableHeight > bTableDetail.Height + bFooter.Height);

	with Schedule do
	begin
		if ( FieldByName( 'typPlaceFrom').AsInteger = PROFILE_ADDRESS)
		    and ( FieldByName( 'refResidentFrom').AsInteger = FieldByName( 'refClient').AsInteger) then
			strPlaceFrom := 'p҂̎'
		else
			strPlaceFrom := FieldByName( 'strPlaceFrom').AsString;

		if ( FieldByName( 'typPlaceTo').AsInteger = PROFILE_ADDRESS)
		    and ( FieldByName( 'refResidentTo').AsInteger = FieldByName( 'refClient').AsInteger) then
			strPlaceTo := 'p҂̎'
		else
			strPlaceTo := FieldByName( 'strPlaceTo').AsString;
		// prepare place label

		if FieldByName( 'refAddressFrom').AsInteger = FieldByName( 'refAddressTo').AsInteger then
		begin
			rActionPlace.Lines.Text := strPlaceFrom;
			rActionPlace2.Lines.Text := '';
		end
		else if ( FieldByName( 'typPlaceFrom').AsInteger = PROFILE_ADDRESS)
		    and ( FieldByName( 'refResidentFrom').AsInteger = FieldByName( 'refClient').AsInteger) then
		begin
			rActionPlace.Lines.Text := '@' + strPlaceTo;
			rActionPlace2.Lines.Text := '';
		end
		else if ( FieldByName( 'typPlaceTo').AsInteger = PROFILE_ADDRESS)
		    and ( FieldByName( 'refResidentTo').AsInteger = FieldByName( 'refClient').AsInteger) then

		begin
			rActionPlace.Lines.Text := '' + strPlaceFrom;
			rActionPlace2.Lines.Text := '';
		end
		else
		begin
			rActionPlace.Lines.Text := '' + FieldByName( 'strPlaceFrom').AsString;
			rActionPlace2.Lines.Text := FieldByName( 'strPlaceTo').AsString;
		end;
		// assign place label

		rClientRead.Lines.Text := FieldByName( 'strClientRead').AsString;
		rClient.Lines.Text := FieldByName( 'strClient').AsString;
		rService.Lines.Text := FieldByName( 'strService').AsString;
		// assign labels at client col

		rServerRead.Lines.Text := FieldByName( 'strServerRead').AsString;
		rServer.Lines.Text := FieldByName( 'strServer').AsString;


		if FieldByName( 'curAmountPerCount').AsCurrency + FieldByName( 'curAmountPerHour').AsCurrency > 0 then
			rNotice.Lines.Text := Format( '(%s) %s', [
				AmountToText(
					FieldByName( 'typExchange').AsInteger,
					FieldByName( 'curAmountPerCount').AsCurrency,
					FieldByName( 'curAmountPerHour').AsCurrency,
					FieldByName( 'intMinutesFor').AsInteger
				),
				FieldByname( 'strNotice').AsString
			])
		else
			rNotice.Lines.Text := FieldByname( 'strNotice').AsString;
		// assign labels at server col
	end;

	Schedule.Next;
end;

procedure TPickupScheduleReport.bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( Schedule.Eof);
	printif( Report.AvailableHeight > bSummary.Height + bFooter.Height);

	rTotalCount.Value := Schedule.RecordCount;
end;

end.
