unit Report_Picture;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  StrUtils, JPEG, IBBlob, MainDataStore, Misc_Utilities, Misc_Constants,
  AxCtrls, OleCtrls, DBOleCtl, ImgeditLibCtl_TLB;

type
  TPictureReport = class(TReportTemplate)
    MainTransaction: TIBTransaction;
    Picture: TIBQuery;
    FlexReportBand3: TFlexReportBand;
    rName: TFlexReportPanel;
    FlexReportPanel8: TFlexReportPanel;
    FlexReportPanel10: TFlexReportPanel;
    FlexReportPanel12: TFlexReportPanel;
    rAddress: TFlexReportPanel;
    rZip: TFlexReportPanel;
    FlexReportBand2: TFlexReportBand;
    FlexReportPanel13: TFlexReportPanel;
    rNameRead: TFlexReportPanel;
    rAddressRead: TFlexReportPanel;
    FlexReportBand9: TFlexReportBand;
    FlexReportPanel7: TFlexReportPanel;
    bTitle: TFlexReportBand;
    FlexReportPanel1: TFlexReportPanel;
    rTimeStamp: TFlexReportDateTime;
    rNotice: TFlexReportPanel;
    bPicture: TFlexReportBand;
    Center: TIBQuery;
    Profile: TIBQuery;
    Address: TIBQuery;
    rPicture: TFlexReportPanel;
    ImageEditor: TImgEdit;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);

    procedure bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure rPicture_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
  private
    { Private 錾 }
  public
    { Public 錾 }
    constructor Prepare( keyInstance : Integer; datAt : TDate);
  end;

var
  PictureReport: TPictureReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TPictureReport.Prepare( keyInstance : Integer; datAt : TDate);
begin
	inherited Create( Screen.ActiveForm);

	Picture.ParamByName( 'keyInstance').AsInteger := keyInstance;
	Picture.Open;

	Profile.ParamByName( 'datAt').AsDate := datAt;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPictureReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Picture.IsEmpty);
end;

procedure TPictureReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bTitle.Printed);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPictureReport.bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
var
	PictureOwner : TIBQuery;
begin
	printif( not bTitle.Printed);


	case Picture.FieldByName( 'typOwner').AsInteger of
	OWNER_CENTER : PictureOwner := Center;
	OWNER_PROFILE : PictureOwner := Profile;
	OWNER_ADDRESS : PictureOwner := Address;
	end;

	PictureOwner.ParamByName( 'keyInstance').AsInteger := Picture.FieldByName( 'refOwner').AsInteger;
	PictureOwner.Open;

	with PictureOwner do
	begin
		rNameRead.Lines.Text := FieldByName( 'strNameRead').AsString;
		rName.Lines.Text := FieldByName( 'strName').AsString;

		rZip.Lines.Text := '' + ToZipText( FieldByName( 'refZip').AsInteger);
		rAddressRead.Lines.Text := FieldByName( 'strAddressRead').AsString;
		rAddress.Lines.Text := FieldByName( 'strAddress').AsString;
	end;

	rNotice.Lines.Text := Format( '%s %s', [
		Picture.FieldByName( 'strName').AsString,
		Picture.FieldByName( 'strNotice').AsString
	]);
end;

procedure TPictureReport.rPicture_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
var
	Temporary : TFileStream;
	Bitmap : TBitmap;
begin
	ImageEditor.Image := TemporaryFileName();

	with Picture do
	begin
		Temporary := TFileStream.Create( ImageEditor.Image, fmCreate);
		try
			Temporary.CopyFrom( CreateBlobStream( FieldByName( 'Stream'), bmRead), 0);
		finally
			Temporary.Free;
		end;

		ImageEditor.Display;
		ImageEditor.SaveAs( ImageEditor.Image, 3);

		Bitmap := TBitmap.Create;
		try
			Bitmap.LoadFromFile( ImageEditor.Image);
			Report.BeginClip( 0, 0, bPicture.Width, bPicture.Height);
			Report.Draw(
				8,
				8,
				8 + Bitmap.Width * bPicture.Width div 1490,
				8 + Bitmap.Height * bPicture.Width div 1490,
				Bitmap
			);
			Report.EndClip();
		finally
			Bitmap.Free;
		end;
	end;

	DeleteFile( ImageEditor.Image);
end;

end.
