unit Report_Profiles;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  Math, StrUtils, MainDataStore, Misc_Utilities, Misc_Constants, DBLocal, DBLocalI;

type
  TProfilesReport = class(TReportTemplate)

    bTitle: TFlexReportBand;
    rTitle: TFlexReportPanel;
    rTimeStamp: TFlexReportDateTime;
    bFooter: TFlexReportBand;
    bSummary: TFlexReportBand;
    bTable: TFlexReportLayout;
    bTableHeader: TFlexReportBand;
    bTableDetail: TFlexReportBand;
    rPageNumber: TFlexReportPageNumber;
    FlexReportPanel9: TFlexReportPanel;
    FlexReportPanel10: TFlexReportPanel;
    rAddress: TFlexReportPanel;
    rAddressRead: TFlexReportPanel;
    FlexReportPanel4: TFlexReportPanel;
    FlexReportPanel18: TFlexReportPanel;
    rName: TFlexReportPanel;
    rNameRead: TFlexReportPanel;
    FlexReportPanel21: TFlexReportPanel;
    rPhoneAndFax: TFlexReportPanel;
    FlexReportPanel11: TFlexReportPanel;
    rTotalCount: TFlexReportDecimal;
    FlexReportPanel12: TFlexReportPanel;
    rSex: TFlexReportPanel;
    rSelection: TFlexReportPanel;
    FlexReportPanel2: TFlexReportPanel;
    rCode: TFlexReportPanel;
    FlexReportPanel5: TFlexReportPanel;
    rAge: TFlexReportInteger;
    FlexReportPanel6: TFlexReportPanel;
    rBirthday: TFlexReportDateTime;
    MainTransaction: TIBTransaction;
    SourceOf_Profile: TIBQuery;
    ProviderOf_Profile: TDataSetProvider;
    Profile: TClientDataSet;
    rCatalogue: TFlexReportPanel;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);

    procedure bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
  private
    { Private 錾 }
  public
    { Public 錾 }
    constructor Prepare( typCatalogue, typCategory, refRegion, refBranch : Integer; collation : String);
  end;

var
  ProfilesReport: TProfilesReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TProfilesReport.Prepare( typCatalogue, typCategory, refRegion, refBranch : Integer; collation : String);
begin
	inherited Create( Screen.ActiveForm);

	SourceOf_Profile.ParamByName( 'typCategory').AsInteger := typCategory;
	SourceOf_Profile.ParamByName( 'refRegion').AsInteger := refRegion;
	SourceOf_Profile.ParamByName( 'refBranch').AsInteger := refBranch;
	SourceOf_Profile.ParamByName( 'datAvailableAt').AsDate := Today;
	case typCatalogue of
	AVAILABLE_ITEM :
		Profile.Filter := CatalogueFilter( AVAILABLE_ITEM) + ' and optAvailability <> 0';

	UNAVAILABLE_ITEM :
		Profile.Filter := Format(
			'( (%s) or ( typStatus=%d and optAvailability = 0))',
			[ CatalogueFilter( AVAILABLE_ITEM), DATA_ENABLED]
		);

	DISABLED_ITEM :
		Profile.Filter := CatalogueFilter( DISABLED_ITEM);
	end;
	Profile.IndexFieldNames := collation;
	Profile.Open;

	Caption := aProfile[ SourceOf_Profile.ParamByName( 'typCategory').AsInteger] + '';

	case typCatalogue of
	  AVAILABLE_ITEM : rCatalogue.Lines.Text := '';
	UNAVAILABLE_ITEM : rCatalogue.Lines.Text := ' Lx~̂̂̈ꗗ ';
	   DISABLED_ITEM : rCatalogue.Lines.Text := ' 폜ꂽ̂̈ꗗ ';
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfilesReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Profile.IsEmpty);
end;

procedure TProfilesReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bSummary.Printed);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TProfilesReport.bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
var
	Selection : String;
begin
	printif( not bTitle.Printed);

	rTitle.Lines.Text := Caption;

	if SourceOf_Profile.ParamByName( 'refRegion').AsInteger > 0 then
		Selection := Profile.FieldByName( 'strRegion').AsString
	else
		Selection := 'ׂ';

	if SourceOf_Profile.ParamByName( 'refBranch').AsInteger > 0 then
		Selection := Selection + '~' + Profile.FieldByName( 'strBranch').AsString
	else
		Selection := Selection + '~ׂ';

	rSelection.Lines.Text := Selection;
end;

procedure TProfilesReport.bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Profile.Eof);
end;

procedure TProfilesReport.bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Profile.Eof);
	printif( Report.AvailableHeight > bTableDetail.Height + bFooter.Height);

	rCode.Lines.Text := Profile.FieldByName( 'strCode').AsString;
	rNameRead.Lines.Text := Profile.FieldByName( 'strNameRead').AsString;
	rName.Lines.Text := Profile.FieldByName( 'strName').AsString;
	rSex.Lines.Text := aSex[ Profile.FieldByName( 'typSex').AsInteger];
	rAge.Value := YearsBetween( Today, Profile.FieldByName( 'datBirthday').AsDateTime);
	rBirthday.Value := Profile.FieldByName( 'datBirthday').AsDateTime;
	rAddressRead.Lines.Text := Profile.FieldByName( 'strAddressRead').AsString;
	rAddress.Lines.Text := Format( '%s %s', [
		ToZipText( Profile.FieldByName( 'refZip').AsInteger),
		Profile.FieldByName( 'strAddress').AsString
	]);
	rPhoneAndFax.Lines.Clear;
	rPhoneAndFax.Lines.Add( Profile.FieldByName( 'strPhoneNumber1').AsString);
	rPhoneAndFax.Lines.Add( Profile.FieldByName( 'strFaxNumber1').AsString);

	Profile.Next;
end;

procedure TProfilesReport.bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( Profile.Eof);
	printif( Report.AvailableHeight > bSummary.Height + bFooter.Height);

	rTotalCount.Value := Profile.RecordCount;
end;

end.
