unit Report_Regions;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  MainDataStore, Misc_Utilities, Misc_Constants;

type
  TRegionsReport = class(TReportTemplate)
    MainTransaction: TIBTransaction;
    SourceOf_Region: TIBQuery;

    bTitle: TFlexReportBand;
    FlexReportPanel1: TFlexReportPanel;
    rTimeStamp: TFlexReportDateTime;
    bFooter: TFlexReportBand;
    rPageNumber: TFlexReportPageNumber;
    bSummary: TFlexReportBand;
    FlexReportPanel11: TFlexReportPanel;
    rTotalCount: TFlexReportDecimal;
    bTable: TFlexReportLayout;
    bTableHeader: TFlexReportBand;
    FlexReportPanel5: TFlexReportPanel;
    bTableDetail: TFlexReportBand;
    rName: TFlexReportPanel;
    FlexReportPanel2: TFlexReportPanel;
    rAvailableFrom: TFlexReportDateTime;
    rAvailableTo: TFlexReportDateTime;
    ProviderOf_Region: TDataSetProvider;
    Region: TClientDataSet;
    rCatalogue: TFlexReportPanel;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);

    procedure bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
  private
    { Private 錾 }
  public
    { Public 錾 }
    constructor Prepare( typCatalogue : Integer);
  end;

var
  RegionsReport: TRegionsReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TRegionsReport.Prepare( typCatalogue : Integer);
begin
	inherited Create( Screen.ActiveForm);

	Region.Filter := CatalogueFilter( typCatalogue);
	Region.Open;

	rCatalogue.Lines.Text := aCatalogue[ typCatalogue];
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TRegionsReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Region.IsEmpty);
end;

procedure TRegionsReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bSummary.Printed);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TRegionsReport.bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bTitle.Printed);
end;

procedure TRegionsReport.bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Region.Eof);
end;

procedure TRegionsReport.bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Region.Eof);
	printif( Report.AvailableHeight > bTableDetail.Height + bFooter.Height);

	with Region do
	begin
		rName.Lines.Text := FieldByName( 'strName').AsString;
		rAvailableFrom.Value := FieldByName( 'datAvailableFrom').AsDateTime;
		rAvailableTo.Value := FieldByName( 'datAvailableTo').AsDateTime;
	end;

	Region.Next;
end;

procedure TRegionsReport.bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( Region.Eof);
	printif( Report.AvailableHeight > bSummary.Height + bFooter.Height);

	rTotalCount.Value := Region.RecordCount;
end;

end.
