unit Report_Servers;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  MainDataStore, Misc_Constants, Misc_Utilities, DBLocal, DBLocalI;

type
  TServersReport = class(TReportTemplate)

    bTitle: TFlexReportBand;
    FlexReportPanel1: TFlexReportPanel;
    rTimeStamp: TFlexReportDateTime;
    bFooter: TFlexReportBand;
    bSummary: TFlexReportBand;
    bTable: TFlexReportLayout;
    bTableHeader: TFlexReportBand;
    bTableDetail: TFlexReportBand;
    rPageNumber: TFlexReportPageNumber;
    FlexReportPanel2: TFlexReportPanel;
    rFaxNumber: TFlexReportPanel;
    FlexReportPanel5: TFlexReportPanel;
    FlexReportPanel6: TFlexReportPanel;
    rName: TFlexReportPanel;
    rNameRead: TFlexReportPanel;
    FlexReportPanel9: TFlexReportPanel;
    FlexReportPanel10: TFlexReportPanel;
    rAddress: TFlexReportPanel;
    rAddressRead: TFlexReportPanel;
    FlexReportPanel21: TFlexReportPanel;
    rPhoneNumber2: TFlexReportPanel;
    FlexReportPanel23: TFlexReportPanel;
    rPhoneNumber1: TFlexReportPanel;
    FlexReportPanel11: TFlexReportPanel;
    rTotalCount: TFlexReportDecimal;
    FlexReportPanel12: TFlexReportPanel;
    MainTransaction: TIBTransaction;
    Server: TIBClientDataSet;
    rRange: TFlexReportPanel;
    rAvailability: TFlexReportPanel;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);

    procedure bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
  private
    { Private 錾 }
  public
    { Public 錾 }
    constructor Daily( datAt : TDate);
    constructor Monthly( datAt : TDate);
  end;

var
  ServersReport: TServersReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TServersReport.Daily( datAt : TDate);
begin
	inherited Create( Screen.ActiveForm);

	Server.Params.ParamByName( 'datFrom').AsDate := datAt;
	Server.Params.ParamByName( 'datTo').AsDate := datAt;
	Server.IndexFieldNames := 'strNameRead;strName;keyInstance';
	Server.Open;
end;

constructor TServersReport.Monthly( datAt : TDate);
begin
	inherited Create( Screen.ActiveForm);

	Server.Params.ParamByName( 'datFrom').AsDate := StartOfTheMonth( datAt);
	Server.Params.ParamByName( 'datTo').AsDate := EndOfTheMonth( datAt);
	Server.IndexFieldNames := 'strNameRead;strName;keyInstance';
	Server.Open;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServersReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Server.IsEmpty);
end;

procedure TServersReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bSummary.Printed);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServersReport.bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bTitle.Printed);

	with Server do if Params.ParamByName( 'datFrom').AsDate = Params.ParamByName( 'datTo').AsDate then
		rRange.Lines.Text := FormatDateTime( 'ggee"N"MM""dd""(ddd)', Params.ParamByName( 'datFrom').AsDate)
	else
		rRange.Lines.Text := FormatDateTime( 'ggee"N"MM""', Params.ParamByName( 'datFrom').AsDate);
end;

procedure TServersReport.bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Server.Eof);
end;

procedure TServersReport.bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Server.Eof);
	printif( Report.AvailableHeight > bTableDetail.Height + bFooter.Height);

	rNameRead.Lines.Text := Server.FieldByName( 'strNameRead').AsString;
	rName.Lines.Text := Server.FieldByName( 'strName').AsString;
	rAddressRead.Lines.Text := Server.FieldByName( 'strAddressRead').AsString;
	rAddress.Lines.Text := Server.FieldByName( 'strAddress').AsString;
	rPhoneNumber1.Lines.Text := Server.FieldByName( 'strPhoneNumber1').AsString;
	rPhoneNumber2.Lines.Text := Server.FieldByName( 'strPhoneNumber2').AsString;
	rFaxNumber.Lines.Text := Server.FieldByName( 'strFaxNumber1').AsString;
	rAvailability.Lines.Text := Server.FieldByName( 'strAvailability').AsString;

	Server.Next;
end;

procedure TServersReport.bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( Server.Eof);
	printif( Report.AvailableHeight > bSummary.Height + bFooter.Height);

	rTotalCount.Value := Server.RecordCount;
end;

end.
