unit Report_Service;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  StrUtils, MainDataStore, Misc_Utilities, Misc_Constants;

type
  TServiceReport = class(TReportTemplate)

    MainTransaction: TIBTransaction;
    Service: TIBQuery;

    bTitle: TFlexReportBand;
    FlexReportPanel1: TFlexReportPanel;
    rTimeStamp: TFlexReportDateTime;
    bFooter: TFlexReportBand;
    rPageNumber: TFlexReportPageNumber;
    bExchangeTable: TFlexReportLayout;
    bExchangeTableDetail: TFlexReportBand;
    rExchange: TFlexReportPanel;
    rExchangeAmountPerHour: TFlexReportDecimal;
    rExchangeAmountPerCount: TFlexReportDecimal;
    bExchangeTableHeader: TFlexReportBand;
    FlexReportPanel2: TFlexReportPanel;
    rExchangeAvailableFrom: TFlexReportDateTime;
    rExchangeAvailableTo: TFlexReportDateTime;
    FlexReportPanel5: TFlexReportPanel;
    FlexReportPanel25: TFlexReportPanel;
    FlexReportPanel26: TFlexReportPanel;
    FlexReportPanel24: TFlexReportPanel;
    FlexReportPanel21: TFlexReportPanel;
    FlexReportPanel22: TFlexReportPanel;
    FlexReportPanel23: TFlexReportPanel;
    rCategory: TFlexReportPanel;
    rName: TFlexReportPanel;
    rAvailability: TFlexReportPanel;
    rAvailableFrom: TFlexReportDateTime;
    rAvailableTo: TFlexReportDateTime;
    FlexReportPanel27: TFlexReportPanel;
    Exchange: TIBQuery;
    bExchangeSummary: TFlexReportBand;
    FlexReportPanel9: TFlexReportPanel;
    rExchangeCount: TFlexReportDecimal;
    FlexReportPanel31: TFlexReportPanel;
    FlexReportPanel32: TFlexReportPanel;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);

    procedure bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bExchangeTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bExchangeTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bExchangeSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
  private
    { Private 錾 }
  public
    { Public 錾 }
    constructor Prepare( keyInstance : Integer);
  end;

var
  ServiceReport: TServiceReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TServiceReport.Prepare( keyInstance : Integer);
begin
	inherited Create( Screen.ActiveForm);

	Service.ParamByName( 'keyInstance').AsInteger := keyInstance;
	Service.Open;

	Exchange.ParamByName( 'keyService').AsInteger := keyInstance;
	Exchange.Open;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServiceReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Service.IsEmpty);
end;

procedure TServiceReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bExchangeSummary.Printed);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServiceReport.bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
var
	availabilityBits : Integer;
	availabilityLabel : String;
begin
	printif( not bTitle.Printed);

	availabilityBits := Service.FieldByName( 'optAvailability').AsInteger;
	availabilityLabel := availabilityLabel + IfThen( ( availabilityBits and SUNDAY_AVAILABLE) <> 0, ' ', '~ ');
	availabilityLabel := availabilityLabel + IfThen( ( availabilityBits and MONDAY_AVAILABLE) <> 0, ' ', '~ ');
	availabilityLabel := availabilityLabel + IfThen( ( availabilityBits and TUESDAY_AVAILABLE) <> 0, ' ', '~ ');
	availabilityLabel := availabilityLabel + IfThen( ( availabilityBits and WEDNESDAY_AVAILABLE) <> 0, ' ', '~ ');
	availabilityLabel := availabilityLabel + IfThen( ( availabilityBits and THURSDAY_AVAILABLE) <> 0, ' ', '~ ');
	availabilityLabel := availabilityLabel + IfThen( ( availabilityBits and FRIDAY_AVAILABLE) <> 0, ' ', '~ ');
	availabilityLabel := availabilityLabel + IfThen( ( availabilityBits and SATURDAY_AVAILABLE) <> 0, 'y ', '~ ');

	with Service do
	begin
		rCategory.Lines.Text := aService[ FieldByName( 'typCategory').AsInteger];
		rName.Lines.Text := FieldByName( 'strName').AsString;
		rAvailability.Lines.Text := availabilityLabel;
		rAvailableFrom.Value := FieldByName( 'datAvailableFrom').AsDateTime;
		rAvailableTo.Value := FieldByName( 'datAvailableTo').AsDateTime;
	end;
end;

procedure TServiceReport.bExchangeTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bExchangeSummary.Printed);
	printif( Report.AvailableHeight > bExchangeTableHeader.Height + bExchangeTableDetail.Height + bExchangeSummary.Height + bFooter.Height);
end;

procedure TServiceReport.bExchangeTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Exchange.Eof);
	printif( not bExchangeSummary.Printed);
	printif( Report.AvailableHeight > bExchangeTableDetail.Height + bExchangeSummary.Height + bFooter.Height);

	with Exchange do
	begin
		rExchange.Lines.Text := FieldByName( 'strName').AsString;

		case FieldByName( 'typCategory').AsInteger of
		TICKET_EXCHANGE :
			begin
				rExchangeAmountPerCount.Lines.Text := '%0.2n _';
				rExchangeAmountPerHour.Lines.Text := '%0.2n _';
			end;
		MONEY_EXCHANGE :
			begin
				rExchangeAmountPerCount.Lines.Text := '%0.0n ~';
				rExchangeAmountPerHour.Lines.Text := '%0.0n ~';
			end;
		end;

		rExchangeAmountPerCount.Value := FieldByName( 'curAmountPerCount').AsCurrency;
		rExchangeAmountPerHour.Value := FieldByName( 'curAmountPerHour').AsCurrency;

		rExchangeAvailableFrom.Value := FieldByName( 'datAvailableFrom').AsDateTime;
		rExchangeAvailableTo.Value := FieldByName( 'datAvailableTo').AsDateTime;
	end;

	Exchange.Next;
end;

procedure TServiceReport.bExchangeSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( Exchange.Eof);
	printif( not bExchangeSummary.Printed);
	printif( Report.AvailableHeight > bExchangeSummary.Height + bFooter.Height);

	rExchangeCount.Value := Exchange.RecordCount;
end;

end.
