unit Report_Tickets;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  MainDataStore;

type
  TTicketsReport = class(TReportTemplate)

    bTitle: TFlexReportBand;
    FlexReportPanel1: TFlexReportPanel;
    rTimeStamp: TFlexReportDateTime;
    bFooter: TFlexReportBand;
    bSummary: TFlexReportBand;
    bTable: TFlexReportLayout;
    bTableHeader: TFlexReportBand;
    FlexReportPanel3: TFlexReportPanel;
    FlexReportPanel4: TFlexReportPanel;
    bTableDetail: TFlexReportBand;
    rPublished: TFlexReportPanel;
    rCode: TFlexReportPanel;
    rPageNumber: TFlexReportPageNumber;
    rScheduleFrom: TFlexReportDateTime;
    FlexReportPanel2: TFlexReportPanel;
    rMargin: TFlexReportDecimal;
    MainTransaction: TIBTransaction;
    SourceOf_Ticket: TIBQuery;
    ProviderOf_Ticket: TDataSetProvider;
    Ticket: TClientDataSet;
    rPricePerPoint: TFlexReportDecimal;
    rName: TFlexReportPanel;
    FlexReportPanel8: TFlexReportPanel;
    FlexReportPanel12: TFlexReportPanel;
    FlexReportPanel15: TFlexReportPanel;
    rPointTotal: TFlexReportDecimal;
    rMarginTotal: TFlexReportDecimal;
    rCount: TFlexReportDecimal;
    FlexReportPanel6: TFlexReportPanel;
    rPoint: TFlexReportDecimal;
    FlexReportPanel5: TFlexReportPanel;
    rBorrow: TFlexReportDecimal;
    rBorrowTotal: TFlexReportDecimal;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);

    procedure bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
  private
    { Private 錾 }
    FPointTotal : Currency;
    FMarginTotal : Currency;
    FBorrowTotal : Currency;
  public
    { Public 錾 }
    constructor Prepare( datFrom, datTo : TDate; collation : String);
  end;

var
  TicketsReport: TTicketsReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TTicketsReport.Prepare( datFrom, datTo : TDate; collation : String);
begin
	inherited Create( Screen.ActiveForm);

	SourceOf_Ticket.ParamByName( 'datFrom').AsDate := datFrom;
	SourceOf_Ticket.ParamByName( 'datTo').AsDate := datTo;
	Ticket.IndexFieldNames := collation;
	Ticket.Open;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketsReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Ticket.IsEmpty);
end;

procedure TTicketsReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bSummary.Printed);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketsReport.bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bTitle.Printed);

	rScheduleFrom.Value := SourceOf_Ticket.ParamByName( 'datFrom').AsDate;

	FPointTotal := 0;
	FMarginTotal := 0;
	FBorrowTotal := 0;
end;

procedure TTicketsReport.bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Ticket.Eof);
end;

procedure TTicketsReport.bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Ticket.Eof);
	printif( Report.AvailableHeight > bTableDetail.Height + bFooter.Height);

	with Ticket do
	begin
		rCode.Lines.Text := FieldByName( 'strCode').AsString;
		rName.Lines.Text := FieldByName( 'strName').AsString;

		rPricePerPoint.Value := FieldByName( 'intPricePerPoint').AsCurrency;
		rPoint.Value := FieldByName( 'curPoint').AsCurrency;
		rMargin.Value := FieldByName( 'intMargin').AsCurrency;
		rBorrow.Value := FieldByName( 'intBorrow').AsCurrency;

		rPublished.Lines.Text := FormatDateTime( 'MM""dd""', FieldByName( 'datPublished').AsDateTime);
	end;

	FPointTotal := FPointTotal + rPoint.Value;
	FMarginTotal := FMarginTotal + rMargin.Value;
	FBorrowTotal := FBorrowTotal + rBorrow.Value;

	Ticket.Next;
end;

procedure TTicketsReport.bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( Ticket.Eof);
	printif( Report.AvailableHeight > bSummary.Height + bFooter.Height);

	rPointTotal.Value := FPointTotal;
	rMarginTotal.Value := FMarginTotal;
	rBorrowTotal.Value := FBorrowTotal;

	rCount.Value := Ticket.RecordCount;
end;

end.
