unit Report_WeeklySurvey;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Report, FlexReport, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  DateUtils, DBClient, Provider, DB, IBCustomDataSet, IBQuery, IBDatabase,
  MainDataStore, Misc_Constants, Misc_Utilities;

type
  TWeeklySurveyReport = class(TReportTemplate)
    SourceOf_Schedule: TIBQuery;
    ProviderOf_Schedule: TDataSetProvider;
    Schedule: TClientDataSet;
    bTitle: TFlexReportBand;
    FlexReportPanel1: TFlexReportPanel;
    rSchedule: TFlexReportDateTime;
    rPeriod: TFlexReportDateTime;
    bTable: TFlexReportLayout;
    bTableHeader: TFlexReportBand;
    FlexReportPanel4: TFlexReportPanel;
    FlexReportPanel5: TFlexReportPanel;
    FlexReportPanel6: TFlexReportPanel;
    rCategory: TFlexReportPanel;
    FlexReportPanel2: TFlexReportPanel;
    FlexReportPanel3: TFlexReportPanel;
    FlexReportPanel7: TFlexReportPanel;
    FlexReportPanel8: TFlexReportPanel;
    bTableDetail: TFlexReportBand;
    rService: TFlexReportPanel;
    rHours: TFlexReportDecimal;
    rCount: TFlexReportDecimal;
    rServerCount: TFlexReportDecimal;
    rClientCount: TFlexReportDecimal;
    rPoint: TFlexReportDecimal;
    rCash: TFlexReportDecimal;
    bTableFooter: TFlexReportBand;
    bSummary: TFlexReportBand;
    bFooter: TFlexReportBand;
    rPageNumber: TFlexReportPageNumber;
    FlexReportPanel9: TFlexReportPanel;
    rCountSummary: TFlexReportDecimal;
    rHoursSummary: TFlexReportDecimal;
    rServerCountSummary: TFlexReportDecimal;
    rClientCountSummary: TFlexReportDecimal;
    rPointSummary: TFlexReportDecimal;
    rCashSummary: TFlexReportDecimal;
    FlexReportPanel10: TFlexReportPanel;
    FlexReportPanel11: TFlexReportPanel;
    rCountTotal: TFlexReportDecimal;
    rHoursTotal: TFlexReportDecimal;
    rServerCountTotal: TFlexReportDecimal;
    rClientCountTotal: TFlexReportDecimal;
    rPointTotal: TFlexReportDecimal;
    rCashTotal: TFlexReportDecimal;
    MainTransaction: TIBTransaction;
    Summary: TIBQuery;
    Total: TIBQuery;

    procedure Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);

    procedure bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTableHeader_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bTableFooter_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
    procedure bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
  private
    { Private 錾 }
    FCategory : Integer;
    FFooterNeeded : Boolean;
  public
    { Public 錾 }
    constructor Prepare( datAt : TDate);
  end;

var
  WeeklySurveyReport: TWeeklySurveyReport;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TWeeklySurveyReport.Prepare( datAt : TDate);
begin
	inherited Create( Screen.ActiveForm);

	rPeriod.Value := StartOfTheWeek( datAt);

	SourceOf_Schedule.ParamByName( 'datFrom').AsDate := StartOfTheWeek( datAt);
	SourceOf_Schedule.ParamByName( 'datTo').AsDate := EndOfTheWeek( datAt);
	Schedule.Open;

	Summary.ParamByName( 'datFrom').AsDate := SourceOf_Schedule.ParamByName( 'datFrom').AsDate;
	Summary.ParamByName( 'datTo').AsDate := SourceOf_Schedule.ParamByName( 'datTo').AsDate;

	Total.ParamByName( 'datFrom').AsDate := SourceOf_Schedule.ParamByName( 'datFrom').AsDate;
	Total.ParamByName( 'datTo').AsDate := SourceOf_Schedule.ParamByName( 'datTo').AsDate;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TWeeklySurveyReport.Report_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Schedule.IsEmpty);
end;

procedure TWeeklySurveyReport.Paper_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bSummary.Printed);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TWeeklySurveyReport.bTitle_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not bTitle.Printed);

	FCategory := -1;
	FFooterNeeded := false;
end;

procedure TWeeklySurveyReport.bTable_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not Schedule.Eof);
end;

procedure TWeeklySurveyReport.bTableHeader_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not FFooterNeeded);
	printif( not Schedule.Eof);
	printif( Report.AvailableHeight > bTableHeader.Height + bTableDetail.Height + bTableFooter.Height + bFooter.Height);

	if Schedule.FieldByName( 'typCategory').AsInteger <> FCategory then
	begin
		FCategory := Schedule.FieldByName( 'typCategory').AsInteger;
		rCategory.Lines.Text := aService[ FCategory];
	end;
end;

procedure TWeeklySurveyReport.bTableDetail_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( not FFooterNeeded);

	try
		printif( not Schedule.Eof);
		printif( Schedule.FieldByName( 'typCategory').AsInteger = FCategory);
	except
		FFooterNeeded := true;
		raise;
	end;

	printif( Report.AvailableHeight > bTableDetail.Height + bTableFooter.Height + bFooter.Height);

	with Schedule do
	begin
		rService.Lines.Text := FieldByName( 'strService').AsString;
		rCount.Value := FieldByName( 'intCount').AsInteger;
		rHours.Value := FieldByName( 'intMinutes').AsInteger / 60;
		rClientCount.Value := FieldByName( 'intClientCount').AsInteger;
		rServerCount.Value := FieldByName( 'intServerCount').AsInteger;
		rPoint.Value := CurrToPoint( FieldByName( 'curTotalPoint').AsCurrency);
		rCash.Value := CurrToMoney( FieldByName( 'curTotalCash').AsCurrency);
	end;

	Schedule.Next;
end;

procedure TWeeklySurveyReport.bTableFooter_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( FFooterNeeded);
	printif( Report.AvailableHeight > bTableFooter.Height + bFooter.Height);

	with Summary do
	begin
		ParamByName( 'typCategory').AsInteger := FCategory;

		Open;
		rCountSummary.Value := FieldByName( 'intCount').AsInteger;
		rHoursSummary.Value := FieldByName( 'intMinutes').AsInteger / 60;
		rClientCountSummary.Value := FieldByName( 'intClientCount').AsInteger;
		rServerCountSummary.Value := FieldByName( 'intServerCount').AsInteger;
		rPointSummary.Value := CurrToPoint( FieldByName( 'curTotalPoint').AsCurrency);
		rCashSummary.Value := CurrToMoney( FieldByName( 'curTotalCash').AsCurrency);
		Close;
	end;

	FFooterNeeded := false;
end;

procedure TWeeklySurveyReport.bSummary_BeforePrint(Sender: TObject; Report: TFlexCustomReport);
begin
	printif( Schedule.Eof);
	printif( Report.AvailableHeight > bSummary.Height + bFooter.Height);

	with Total do
	begin
		Open;
		rCountTotal.Value := FieldByName( 'intCount').AsInteger;
		rHoursTotal.Value := FieldByName( 'intMinutes').AsInteger / 60;
		rClientCountTotal.Value := FieldByName( 'intClientCount').AsInteger;
		rServerCountTotal.Value := FieldByName( 'intServerCount').AsInteger;
		rPointTotal.Value := CurrToPoint( FieldByName( 'curTotalPoint').AsCurrency);
		rCashTotal.Value := CurrToMoney( FieldByName( 'curTotalCash').AsCurrency);
		Close;
	end;
end;

end.
