unit Set_Address;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, MainDatastore, DBCtrls, DB, IBCustomDataSet,
  IBTable, StrUtils, IBQuery, IB, IBErrorCodes, DBClient, Provider,
  DBLocal, DBLocalI, IBSQL, IBDatabase, ComCtrls, DateUtils, IBUpdateSQL,
  Misc_Constants, Misc_Utilities, Base_Set, Piece_ValiditySelector;

type
  TAddressSet = class(TSetTemplate)
    Address: TIBQuery;
    UpdaterOf_Address: TIBUpdateSQL;

    Zip: TIBQuery;

    Validity: TValiditySelector;

    txtNameRead: TLabeledEdit;
    txtName: TLabeledEdit;
    bvlName: TBevel;

    txtZipCode: TLabeledEdit;
    btnChooseZip: TButton;
    txtZipAddressRead: TLabeledEdit;
    txtZipAddress: TLabeledEdit;
    txtAddressRead: TEdit;
    txtAddress: TEdit;
    bvlLocation: TBevel;

    txtPhoneNumber1: TLabeledEdit;
    txtPhoneNumber2: TLabeledEdit;
    txtPhoneNumber3: TLabeledEdit;
    txtFaxNumber1: TLabeledEdit;
    txtFaxNumber2: TLabeledEdit;
    txtFaxNumber3: TLabeledEdit;

    btnPrint: TButton;
    btnPictureAlbum: TButton;
    btnLocator: TButton;

    procedure btnChooseZip_Click(Sender: TObject);
    procedure txtZipCode_Change(Sender: TObject);

    procedure btnLocator_Click(Sender: TObject);
    procedure btnPictureAlbum_Click(Sender: TObject);
    procedure btnPrint_Click(Sender: TObject);

  private
    { Private 錾 }
    FLocatorX : Integer;
    FLocatorY : Integer;
  protected
    { Protected 錾 }
    procedure DefineTable( var nameOfTable : String; var modifyFlag, cancelFlag : Boolean); override;

    procedure BeforeInput(); override;
    procedure AfterInput(); override;

    procedure BeforeSelect(); override;
    procedure AfterSelect(); override;

    procedure BeforeAppend(); override;
    procedure AfterAppend(); override;

    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  end;

var
  AddressSet: TAddressSet;

implementation

{$R *.dfm}

uses Chooser_Zip, Report_Address, Misc_Locator, Misc_PictureAlbum;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressSet.DefineTable( var nameOfTable : String; var modifyFlag, cancelFlag : Boolean);
begin
	nameOfTable := 'Address';
	modifyFlag := true;
	cancelFlag := true;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressSet.BeforeInput();
begin
	Address.ParamByName( 'keyInstance').AsInteger := Primarykey;
	Address.Open;
end;

procedure TAddressSet.AfterInput();
begin
	with Address do
	begin
		if Appending then Append else Edit;
		FieldByName( 'keyInstance').AsInteger := RealizedKey;
		FieldByName( 'typCategory').AsInteger := PUBLIC_ADDRESS;
		FieldByName( 'datAvailableFrom').AsDateTime := Validity.AvailableFrom;
		FieldByName( 'datAvailableTo').AsDateTime := Validity.AvailableTo;
		FieldByName( 'strName').AsString := Trim( txtName.Text);
		FieldByName( 'strNameRead').AsString := Trim( txtNameRead.Text);
		FieldByName( 'refZip').AsInteger := ToZipCode( txtZipCode.Text);
		FieldByName( 'strAddress').AsString := Trim( txtAddress.Text);
		FieldByName( 'strAddressRead').AsString := Trim( txtAddressRead.Text);
		FieldByName( 'strPhoneNumber1').AsString := Trim( txtPhoneNumber1.Text);
		FieldByName( 'strPhoneNumber2').AsString := Trim( txtPhoneNumber2.Text);
		FieldByName( 'strPhoneNumber3').AsString := Trim( txtPhoneNumber3.Text);
		FieldByName( 'strFaxNumber1').AsString := Trim( txtFaxNumber1.Text);
		FieldByName( 'strFaxNumber2').AsString := Trim( txtFaxNumber2.Text);
		FieldByName( 'strFaxNumber3').AsString := Trim( txtFaxNumber3.Text);
		FieldByName( 'intLocatorX').AsInteger := FLocatorX;
		FieldByName( 'intLocatorY').AsInteger := FLocatorY;
		Post;
		ApplyUpdates;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressSet.BeforeSelect();
begin
	with Address do
	begin
		Validity.AvailableFrom := FieldByName( 'datAvailableFrom').AsDateTime;
		Validity.AvailableTo := FieldByName( 'datAvailableTo').AsDateTime;
		txtNameRead.Text := Trim( FieldByName( 'strNameRead').AsString);
		txtName.Text := Trim( FieldByName( 'strName').AsString);
		txtZipCode.Text := ToZipText( FieldByName( 'refZip').AsInteger);
		txtAddress.Text := Trim( FieldByName( 'strAddress').AsString);
		txtAddressRead.Text := Trim( FieldByName( 'strAddressRead').AsString);
		txtPhoneNumber1.Text := Trim( FieldByName( 'strPhoneNumber1').AsString);
		txtPhoneNumber2.Text := Trim( FieldByName( 'strPhoneNumber2').AsString);
		txtPhoneNumber3.Text := Trim( FieldByName( 'strPhoneNumber3').AsString);
		txtFaxNumber1.Text := Trim( FieldByName( 'strFaxNumber1').AsString);
		txtFaxNumber2.Text := Trim( FieldByName( 'strFaxNumber2').AsString);
		txtFaxNumber3.Text := Trim( FieldByName( 'strFaxNumber3').AsString);
		FLocatorX := FieldByName( 'intLocatorX').AsInteger;
		FLocatorY := FieldByName( 'intLocatorY').AsInteger;
	end;
end;

procedure TAddressSet.AfterSelect();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressSet.BeforeAppend();
begin
	Validity.AvailableFrom := StartOfTheMonth( Today);
	Validity.AvailableTo := StrToDate( '2087/12/31');
	txtName.Text := '(n͂Ă)';
	txtNameRead.Text := '(n݂̂Ȃ͂Ă)';
	txtAddress.Text := '(Z͂Ă)';
	txtAddressRead.Text := '(Ẑ݂Ȃ͂Ă)';
	FLocatorX := 320;
	FLocatorY := 256;
end;

procedure TAddressSet.AfterAppend();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressSet.BeforePopup();
begin
	Validity.ReadOnly := Browsing;
	txtNameRead.ReadOnly := Browsing or ( ( PrimaryKey > 0) and ( Address.FieldByName( 'typCategory').AsInteger = PROFILE_ADDRESS));
	txtName.ReadOnly := txtNameRead.ReadOnly;
	txtZipCode.ReadOnly := Browsing;
	btnChooseZip.Enabled := not Browsing;
	txtAddress.ReadOnly := Browsing;
	txtAddressRead.ReadOnly := Browsing;
	txtPhoneNumber1.ReadOnly := Browsing;
	txtPhoneNumber2.ReadOnly := Browsing;
	txtPhoneNumber3.ReadOnly := Browsing;
	txtFaxNumber1.ReadOnly := Browsing;
	txtFaxNumber2.ReadOnly := Browsing;
	txtFaxNumber3.ReadOnly := Browsing;

	btnLocator.Enabled := not Browsing;
	btnPictureAlbum.Visible := not Appending;
	btnPrint.Visible := not Appending;
end;

procedure TAddressSet.AfterPopup();
begin
	ErrorCheck_Empty( 'O݂', txtNameRead.Text, ErrorMessages);
	ErrorCheck_Reading( 'O݂', txtNameRead.Text, ErrorMessages);
	ErrorCheck_Empty( 'O', txtName.Text, ErrorMessages);
	ErrorCheck_Empty( 'X֔ԍ', txtZipCode.Text, ErrorMessages);
	if txtZipAddress.Text = '*********' then ErrorMessages.Add( 'X֔ԍ܂B');
	ErrorCheck_Reading( 'Z݂', txtAddressRead.Text, ErrorMessages);
	ErrorCheck_Digits( 'dbԍP', txtPhoneNumber1.Text, ErrorMessages);
	ErrorCheck_Digits( 'dbԍQ', txtPhoneNumber2.Text, ErrorMessages);
	ErrorCheck_Digits( 'dbԍR', txtPhoneNumber3.Text, ErrorMessages);
	ErrorCheck_Digits( 'FAXԍP', txtFaxNumber1.Text, ErrorMessages);
	ErrorCheck_Digits( 'FAXԍQ', txtFaxNumber2.Text, ErrorMessages);
	ErrorCheck_Digits( 'FAXԍR', txtFaxNumber3.Text, ErrorMessages);

	if ErrorMessages.Count > 0 then exit;

	if Trim( txtAddress.Text) = '' then
        begin
		if ShowConfirmation(
			'Z󗓂ɂȂĂ̂ŉ͈ƂȂ܂B'
				+ #13#10 + '݂𒆎~ďC܂H',
			'Z󗓂ł',
			MB_YESNO
		) = IDYES
		then
			ErrorMessages.Add( 'f[^݂̏𒆎~܂B');
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressSet.btnChooseZip_Click(Sender: TObject);
var
	keyZip : Integer;
begin
	if ChooseZip( Transaction, keyZip) then
	begin
		txtZipCode.Text := ToZipText( keyZip);
		txtAddressRead.SetFocus;
	end;
end;

procedure TAddressSet.txtZipCode_Change(Sender: TObject);
begin
	Zip.ParamByName( 'keyZIP').AsInteger := ToZipCode( txtZipCode.Text);
	Zip.Open;
	if not Zip.IsEmpty then
	begin
		txtZipAddressRead.Text := Trim( Zip.FieldByName( 'strAddressRead').AsString);
		txtZipAddress.Text := Trim( Zip.FieldByName( 'strAddress').AsString);
	end
	else
	begin
		txtZipAddressRead.Text := '*********';
		txtZipAddress.Text := '*********';
	end;
	Zip.Close;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TAddressSet.btnLocator_Click(Sender: TObject);
begin
	if Browsing then
		BrowseLocator( FLocatorX, FLocatorY)
	else
		SelectLocator( FLocatorX, FLocatorY);
end;

procedure TAddressSet.btnPictureAlbum_Click(Sender: TObject);
begin
	PopupPictureAlbum( OWNER_ADDRESS, PrimaryKey);
end;

procedure TAddressSet.btnPrint_Click(Sender: TObject);
begin
	TAddressReport.Prepare( PrimaryKey).Preview;
end;

end.
