unit Set_Branch;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, MainDatastore, DBCtrls, DB, IBCustomDataSet,
  IBTable, StrUtils, IBQuery, IB, IBErrorCodes, DBClient, Provider,
  DBLocal, DBLocalI, IBSQL, IBDatabase, ComCtrls, DateUtils, IBUpdateSQL,
  Misc_Constants, Misc_Utilities, Base_Set, Piece_ValiditySelector;

type
  TBranchSet = class(TSetTemplate)
    Branch: TIBQuery;
    UpdaterOf_Branch: TIBUpdateSQL;

    Validity: TValiditySelector;
    txtName: TLabeledEdit;

  private
    { Private 錾 }
  protected
    { Protected 錾 }
    procedure DefineTable( var nameOfTable : String; var modifyFlag, cancelFlag : Boolean); override;

    procedure BeforeInput(); override;
    procedure AfterInput(); override;

    procedure BeforeSelect(); override;
    procedure AfterSelect(); override;

    procedure BeforeAppend(); override;
    procedure AfterAppend(); override;

    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
  end;

var
  BranchSet: TBranchSet;

implementation

{$R *.dfm}

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBranchSet.DefineTable( var nameOfTable : String; var modifyFlag, cancelFlag : Boolean);
begin
	nameOfTable := 'Branch';
	modifyFlag := true;
	cancelFlag := true;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBranchSet.BeforeInput();
begin
	Branch.ParamByName( 'keyInstance').AsInteger := Primarykey;
	Branch.Open;
end;

procedure TBranchSet.AfterInput();
begin
	with Branch do
	begin
		if Appending then Append else Edit;
		FieldByName( 'keyInstance').AsInteger := RealizedKey;
		FieldByName( 'datAvailableFrom').AsDateTime := Validity.AvailableFrom;
		FieldByName( 'datAvailableTo').AsDateTime := Validity.AvailableTo;
		FieldByName( 'strName').AsString := Trim( txtName.Text);
		Post;
		ApplyUpdates;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBranchSet.BeforeSelect();
begin
	with Branch do
	begin
		Validity.AvailableFrom := FieldByName( 'datAvailableFrom').AsDateTime;
		Validity.AvailableTo := FieldByName( 'datAvailableTo').AsDateTime;
		txtName.Text := Trim( FieldByName( 'strName').AsString);
	end;
end;

procedure TBranchSet.AfterSelect();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBranchSet.BeforeAppend();
begin
	Validity.AvailableFrom := StartOfTheMonth( Today);
	Validity.AvailableTo := StrToDate( '2087/12/31');

	txtName.Text := '(O͂Ă)';
end;

procedure TBranchSet.AfterAppend();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBranchSet.BeforePopup();
begin
	Validity.ReadOnly := Browsing;
	txtName.ReadOnly := Browsing;
end;

procedure TBranchSet.AfterPopup();
begin
	ErrorCheck_Empty( 'O', txtName.Text, ErrorMessages);
end;

end.
