unit Set_Center;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, MainDatastore, DBCtrls, DB, IBCustomDataSet,
  IBTable, StrUtils, IBQuery, IB, IBErrorCodes, DBClient, Provider,
  DBLocal, DBLocalI, IBSQL, IBDatabase, ComCtrls, DateUtils, IBUpdateSQL,
  Misc_Constants, Misc_Utilities, Base_Set, Piece_ValiditySelector;

type
  TCenterSet = class(TSetTemplate)
    Center: TIBQuery;
    UpdaterOf_Center: TIBUpdateSQL;

    Zip: TIBQuery;

    txtTradeName: TLabeledEdit;
    txtLegalName: TLabeledEdit;
    bvlName: TBevel;

    txtZipCode: TLabeledEdit;
    btnChooseZip: TButton;
    txtZipAddressRead: TLabeledEdit;
    txtZipAddress: TLabeledEdit;
    txtAddressRead: TEdit;
    txtAddress: TEdit;
    bvlLocation: TBevel;

    txtPhoneNumber1: TLabeledEdit;
    txtPhoneNumber2: TLabeledEdit;
    txtPhoneNumber3: TLabeledEdit;
    txtFaxNumber1: TLabeledEdit;
    txtFaxNumber2: TLabeledEdit;
    txtFaxNumber3: TLabeledEdit;
    bvlPhoneAndFax: TBevel;

    txtPricePerPoint: TLabeledEdit;
    lblPricePerPoint: TLabel;
    bvlPricePerPoint: TBevel;

    grpTicketMargin: TGroupBox;
    txtTicketMarginPerCheck: TLabeledEdit;
    lblTicketMarginPerEvent: TLabel;
    txtTicketMarginPerEvent: TLabeledEdit;
    cboTicketMarginPerEvent: TComboBox;
    lblTicketClosingDay: TLabel;
    cboTicketClosingDay: TComboBox;

    grpPaybackMargin: TGroupBox;
    txtPaybackMarginPerCheck: TLabeledEdit;
    lblPaybackMarginPerEvent: TLabel;
    txtPaybackMarginPerEvent: TLabeledEdit;
    cboPaybackMarginPerEvent: TComboBox;
    lblPaybackClosingDay: TLabel;
    cboPaybackClosingDay: TComboBox;

    grpBillingMargin: TGroupBox;
    lblBillingMarginPerEvent: TLabel;
    txtBillingMarginPerEvent: TLabeledEdit;
    txtBillingMarginPerCheck: TLabeledEdit;
    cboBillingMarginPerEvent: TComboBox;
    lblBillingClosingDay: TLabel;
    cboBillingClosingDay: TComboBox;

    grpPaymentMargin: TGroupBox;
    txtPaymentMarginPerCheck: TLabeledEdit;
    lblPaymentMarginPerEvent: TLabel;
    txtPaymentMarginPerEvent: TLabeledEdit;
    cboPaymentMarginPerEvent: TComboBox;
    lblPaymentClosingDay: TLabel;
    cboPaymentClosingDay: TComboBox;
    btnPictureAlbum: TButton;

    procedure btnChooseZip_Click(Sender: TObject);
    procedure txtZipCode_Change(Sender: TObject);

    procedure btnPictureAlbum_Click(Sender: TObject);

  private
    { Private 錾 }
  protected
    { Protected 錾 }
    procedure DefineTable( var nameOfTable : String; var modifyFlag, cancelFlag : Boolean); override;

    procedure BeforeInput(); override;
    procedure AfterInput(); override;

    procedure BeforeSelect(); override;
    procedure AfterSelect(); override;

    procedure BeforeAppend(); override;
    procedure AfterAppend(); override;

    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  end;

var
  CenterSet: TCenterSet;

implementation

{$R *.dfm}

uses Chooser_Zip, Misc_PictureAlbum;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCenterSet.DefineTable( var nameOfTable : String; var modifyFlag, cancelFlag : Boolean);
begin
	nameOfTable := 'Center';
	modifyFlag := true;
	cancelFlag := true;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCenterSet.BeforeInput();
begin
	Center.ParamByName( 'keyInstance').AsInteger := Primarykey;
	Center.Open;
end;

procedure TCenterSet.AfterInput();
begin
	with Center do
	begin
		if Appending then Append else Edit;
		FieldByName( 'keyInstance').AsInteger := RealizedKey;

		FieldByName( 'strLegalName').AsString := Trim( txtLegalName.Text);
		FieldByName( 'strTradeName').AsString := Trim( txtTradeName.Text);

		FieldByName( 'refZip').AsInteger := ToZipCode( txtZipCode.Text);
		FieldByName( 'strAddress').AsString := Trim( txtAddress.Text);
		FieldByName( 'strAddressRead').AsString := Trim( txtAddressRead.Text);

		FieldByName( 'strPhoneNumber1').AsString := Trim( txtPhoneNumber1.Text);
		FieldByName( 'strPhoneNumber2').AsString := Trim( txtPhoneNumber2.Text);
		FieldByName( 'strPhoneNumber3').AsString := Trim( txtPhoneNumber3.Text);
		FieldByName( 'strFaxNumber1').AsString := Trim( txtFaxNumber1.Text);
		FieldByName( 'strFaxNumber2').AsString := Trim( txtFaxNumber2.Text);
		FieldByName( 'strFaxNumber3').AsString := Trim( txtFaxNumber3.Text);

		FieldByName( 'intPricePerPoint').AsInteger := StrToInt( txtPricePerPoint.Text);

		FieldByName( 'intTicketMarginPerCheck').AsInteger := StrToInt( txtTicketMarginPerCheck.Text);
		FieldByName( 'intTicketMarginPerEvent').AsInteger := StrToInt( txtTicketMarginPerEvent.Text);
		FieldByName( 'typTicketMarginPerEvent').AsInteger := cboTicketMarginPerEvent.ItemIndex;
		FieldByName( 'intTicketClosingDay').AsInteger := cboTicketClosingDay.ItemIndex + 1;

		FieldByName( 'intPaybackMarginPerCheck').AsInteger := StrToInt( txtPaybackMarginPerCheck.Text);
		FieldByName( 'intPaybackMarginPerEvent').AsInteger := StrToInt( txtPaybackMarginPerEvent.Text);
		FieldByName( 'typPaybackMarginPerEvent').AsInteger := cboPaybackMarginPerEvent.ItemIndex;
		FieldByName( 'intPaybackClosingDay').AsInteger := cboPaybackClosingDay.ItemIndex + 1;

		FieldByName( 'intBillingMarginPerCheck').AsInteger := StrToInt( txtBillingMarginPerCheck.Text);
		FieldByName( 'intBillingMarginPerEvent').AsInteger := StrToInt( txtBillingMarginPerEvent.Text);
		FieldByName( 'typBillingMarginPerEvent').AsInteger := cboBillingMarginPerEvent.ItemIndex;
		FieldByName( 'intBillingClosingDay').AsInteger := cboBillingClosingDay.ItemIndex + 1;

		FieldByName( 'intPaymentMarginPerCheck').AsInteger := StrToInt( txtPaymentMarginPerCheck.Text);
		FieldByName( 'intPaymentMarginPerEvent').AsInteger := StrToInt( txtPaymentMarginPerEvent.Text);
		FieldByName( 'typPaymentMarginPerEvent').AsInteger := cboPaymentMarginPerEvent.ItemIndex;
		FieldByName( 'intPaymentClosingDay').AsInteger := cboPaymentClosingDay.ItemIndex + 1;

		Post;
		ApplyUpdates;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCenterSet.BeforeSelect();
begin
	with Center do
	begin
		txtTradeName.Text := Trim( FieldByName( 'strTradeName').AsString);
		txtLegalName.Text := Trim( FieldByName( 'strLegalName').AsString);

		txtZipCode.Text := ToZipText( FieldByName( 'refZip').AsInteger);
		txtAddress.Text := Trim( FieldByName( 'strAddress').AsString);
		txtAddressRead.Text := Trim( FieldByName( 'strAddressRead').AsString);

		txtPhoneNumber1.Text := Trim( FieldByName( 'strPhoneNumber1').AsString);
		txtPhoneNumber2.Text := Trim( FieldByName( 'strPhoneNumber2').AsString);
		txtPhoneNumber3.Text := Trim( FieldByName( 'strPhoneNumber3').AsString);
		txtFaxNumber1.Text := Trim( FieldByName( 'strFaxNumber1').AsString);
		txtFaxNumber2.Text := Trim( FieldByName( 'strFaxNumber2').AsString);
		txtFaxNumber3.Text := Trim( FieldByName( 'strFaxNumber3').AsString);

		txtPricePerPoint.Text := FieldByName( 'intPricePerPoint').AsString;

		txtTicketMarginPerCheck.Text := FieldByName( 'intTicketMarginPerCheck').AsString;
		txtTicketMarginPerEvent.Text := FieldByName( 'intTicketMarginPerEvent').AsString;
		cboTicketMarginPerEvent.ItemIndex := FieldByName( 'typTicketMarginPerEvent').AsInteger;
		cboTicketClosingDay.ItemIndex := FieldByName( 'intTicketClosingDay').AsInteger - 1;

		txtPaybackMarginPerCheck.Text := FieldByName( 'intPaybackMarginPerCheck').AsString;
		txtPaybackMarginPerEvent.Text := FieldByName( 'intPaybackMarginPerEvent').AsString;
		cboPaybackMarginPerEvent.ItemIndex := FieldByName( 'typPaybackMarginPerEvent').AsInteger;
		cboPaybackClosingDay.ItemIndex := FieldByName( 'intPaybackClosingDay').AsInteger - 1;

		txtBillingMarginPerCheck.Text := FieldByName( 'intBillingMarginPerCheck').AsString;
		txtBillingMarginPerEvent.Text := FieldByName( 'intBillingMarginPerEvent').AsString;
		cboBillingMarginPerEvent.ItemIndex := FieldByName( 'typBillingMarginPerEvent').AsInteger;
		cboBillingClosingDay.ItemIndex := FieldByName( 'intBillingClosingDay').AsInteger - 1;

		txtPaymentMarginPerCheck.Text := FieldByName( 'intPaymentMarginPerCheck').AsString;
		txtPaymentMarginPerEvent.Text := FieldByName( 'intPaymentMarginPerEvent').AsString;;
		cboPaymentMarginPerEvent.ItemIndex := FieldByName( 'typPaymentMarginPerEvent').AsInteger;
		cboPaymentClosingDay.ItemIndex := FieldByName( 'intPaymentClosingDay').AsInteger - 1;
	end;
end;

procedure TCenterSet.AfterSelect();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCenterSet.BeforeAppend();
begin
	{ N/A }
end;

procedure TCenterSet.AfterAppend();
begin
	{ N/A }
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCenterSet.BeforePopup();
begin
	txtTradeName.ReadOnly := Browsing;
	txtLegalName.ReadOnly := Browsing;

	txtZipCode.ReadOnly := Browsing;
	btnChooseZip.Enabled := not Browsing;
	txtAddress.ReadOnly := Browsing;
	txtAddressRead.ReadOnly := Browsing;

	txtPhoneNumber1.ReadOnly := Browsing;
	txtPhoneNumber2.ReadOnly := Browsing;
	txtPhoneNumber3.ReadOnly := Browsing;
	txtFaxNumber1.ReadOnly := Browsing;
	txtFaxNumber2.ReadOnly := Browsing;
	txtFaxNumber3.ReadOnly := Browsing;

	txtPricePerPoint.ReadOnly := Browsing;

	grpTicketMargin.Enabled := not Browsing;
	grpPaybackMargin.Enabled := not Browsing;
	grpBillingMargin.Enabled := not Browsing;
	grpPaybackMargin.Enabled := not Browsing;
end;

procedure TCenterSet.AfterPopup();
begin
	ErrorCheck_Empty( '@l', txtLegalName.Text, ErrorMessages);
	ErrorCheck_Empty( '', txtTradeName.Text, ErrorMessages);

	ErrorCheck_Empty( 'X֔ԍ', txtZipCode.Text, ErrorMessages);
	if txtZipAddress.Text = '*********' then ErrorMessages.Add( 'X֔ԍ܂B');
	ErrorCheck_Empty( 'Z', txtAddress.Text, ErrorMessages);
	ErrorCheck_Reading( 'Z݂', txtAddressRead.Text, ErrorMessages);

	ErrorCheck_Digits( 'dbԍP', txtPhoneNumber1.Text, ErrorMessages);
	ErrorCheck_Digits( 'dbԍQ', txtPhoneNumber2.Text, ErrorMessages);
	ErrorCheck_Digits( 'dbԍR', txtPhoneNumber3.Text, ErrorMessages);
	ErrorCheck_Digits( 'FAXԍP', txtFaxNumber1.Text, ErrorMessages);
	ErrorCheck_Digits( 'FAXԍQ', txtFaxNumber2.Text, ErrorMessages);
	ErrorCheck_Digits( 'FAXԍR', txtFaxNumber3.Text, ErrorMessages);

	if StrToIntDef( txtPricePerPoint.Text, 0) <= 0 then
		ErrorMessages.Add( '_Pɂ͔ppPȏ̐w肵ĂB');

	if StrToIntDef( txtTicketMarginPerCheck.Text, -1) < 0 then
		ErrorMessages.Add( '`Pbgs萔̌Œ蕪ɂ͔ppOȏ̐w肵ĂB');

	if StrToIntDef( txtTicketMarginPerEvent.Text, -1) < 0 then
		ErrorMessages.Add( '`Pbgs萔̏]ʕɂ͔ppOȏ̐w肵ĂB');

	if StrToIntDef( txtPaybackMarginPerCheck.Text, -1) < 0 then
		ErrorMessages.Add( '`PbgZ萔̌Œ蕪ɂ͔ppOȏ̐w肵ĂB');

	if StrToIntDef( txtPaybackMarginPerEvent.Text, -1) < 0 then
		ErrorMessages.Add( '`PbgZ萔̏]ʕɂ͔ppOȏ̐w肵ĂB');

	if StrToIntDef( txtBillingMarginPerCheck.Text, -1) < 0 then
		ErrorMessages.Add( '萔̌Œ蕪ɂ͔ppOȏ̐w肵ĂB');

	if StrToIntDef( txtBillingMarginPerEvent.Text, -1) < 0 then
		ErrorMessages.Add( '萔̏]ʕɂ͔ppOȏ̐w肵ĂB');

	if StrToIntDef( txtPaymentMarginPerCheck.Text, -1) < 0 then
		ErrorMessages.Add( 'Z萔̌Œ蕪ɂ͔ppOȏ̐w肵ĂB');

	if StrToIntDef( txtPaymentMarginPerEvent.Text, -1) < 0 then
		ErrorMessages.Add( 'Z萔̏]ʕɂ͔ppOȏ̐w肵ĂB');
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCenterSet.btnChooseZip_Click(Sender: TObject);
var
	keyZip : Integer;
begin
	if ChooseZip( Transaction, keyZip) then
	begin
		txtZipCode.Text := ToZipText( keyZip);
		txtAddressRead.SetFocus;
	end;
end;

procedure TCenterSet.txtZipCode_Change(Sender: TObject);
begin
	Zip.ParamByName( 'keyZIP').AsInteger := ToZipCode( txtZipCode.Text);
	Zip.Open;
	if not Zip.IsEmpty then
	begin
		txtZipAddressRead.Text := Trim( Zip.FieldByName( 'strAddressRead').AsString);
		txtZipAddress.Text := Trim( Zip.FieldByName( 'strAddress').AsString);
	end
	else
	begin
		txtZipAddressRead.Text := '*********';
		txtZipAddress.Text := '*********';
	end;
	Zip.Close;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TCenterSet.btnPictureAlbum_Click(Sender: TObject);
begin
	PopupPictureAlbum( OWNER_CENTER, 1);
end;

end.
