unit Set_Payback;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, IBSQL, IBDatabase, StdCtrls, ExtCtrls, ComCtrls, Grids, DBGrids,
  DB, DBClient, Provider, IBCustomDataSet, IBQuery, StrUtils, DateUtils,
  DBCtrls, Base_Set, IBEvents, Math, ValEdit, IBUpdateSQL,
  Misc_Constants, Misc_Utilities, Piece_ValiditySelector;

type
  TPaybackSet = class(TSetTemplate)
    Center: TIBQuery;

    Unregistered_Payback: TIBQuery;
    UpdaterOf_Payback: TIBUpdateSQL;
    Registered_Payback: TIBQuery;

    Unregistered_Proof: TIBQuery;
    UpdaterOf_Proof: TIBUpdateSQL;
    Registered_Proof: TIBQuery;
    ProviderOf_Proof: TDataSetProvider;
    Proof: TClientDataSet;
    DataSourceOf_Proof: TDataSource;

    PrevLastday: TIBQuery;

    lblCode: TLabel;
    lblPublish: TLabel;
    dtpPublish: TDateTimePicker;
    bvlUpperBorder: TBevel;

    txtCode: TLabeledEdit;
    btnBrowseProfile: TButton;
    btnChooseProfile: TButton;
    txtFamilyNameRead: TLabeledEdit;
    txtFamilyName: TLabeledEdit;
    txtFirstNameRead: TLabeledEdit;
    txtFirstName: TLabeledEdit;
    lblBirthday: TLabel;
    pnlSex: TPanel;
    pnlBirthday: TPanel;
    txtInformation: TEdit;
    vlstPoint: TValueListEditor;
    vlstCount: TValueListEditor;
    bvlMidBorder: TBevel;

    txtPricePerPoint: TLabeledEdit;
    lblPricePerPoint: TLabel;
    txtSummary: TEdit;
    txtMargin: TLabeledEdit;
    lblMargin: TLabel;
    bvlLowerBorder: TBevel;

    pnlSpan: TPanel;
    btnChooseSpan: TButton;
    btnQuoteSpanHead: TButton;

    gridProof: TDBGrid;

    btnBrowseProof: TButton;
    btnRemoveProof: TButton;

    btnPrint: TButton;

    procedure dtpPublish_Change(Sender: TObject);

    procedure btnBrowseProfile_Click(Sender: TObject);
    procedure btnChooseProfile_Click(Sender: TObject);

    procedure txtAmount_Change(Sender: TObject);
    procedure txtMargin_Change(Sender: TObject);

    procedure btnChooseSpan_Click(Sender: TObject);
    procedure btnQuoteSpanHead_Click(Sender: TObject);

    procedure Payback_AfterOpen(DataSet: TDataSet);
    procedure Proof_AfterOpen(DataSet: TDataSet);

    procedure Grid_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);

    procedure btnBrowseProof_Click(Sender: TObject);
    procedure btnRemoveProof_Click(Sender: TObject);

    procedure btnPrint_Click(Sender: TObject);

  private
    { Private 錾 }
    FMonthFirstday : TDate;
    FMonthLastday : TDate;
    FProfileKey : Integer;

    FPoint : array[ CARE_SCHEDULE..TRANSFER_SCHEDULE] of Currency;
    FCount : array[ CARE_SCHEDULE..TRANSFER_SCHEDULE] of Integer;

    procedure Recount();
    procedure Roundup();
  protected
    { Protected 錾 }
    procedure DefineTable( var nameOfTable : String; var modifyFlag, cancelFlag : Boolean); override;

    procedure BeforeInput(); override;
    procedure AfterInput(); override;

    procedure BeforeSelect(); override;
    procedure AfterSelect(); override;

    procedure BeforeAppend(); override;
    procedure AfterAppend(); override;

    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
    constructor Prepare; overload; override;
    constructor Prepare( datMonthFirstday, datMonthLastday, datPublished : TDate; keyServer : Integer); overload;
  end;

var
  PaybackSet: TPaybackSet;

implementation

{$R *.dfm}

uses Chooser_Span, Chooser_Server, Set_Server, Dialog_Snapshot, Report_Payback;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function SumOfArray( aCurrency : array of Currency) : Currency; overload;
var
	Index : Integer;
begin
	result := 0;
	for Index := Low( aCurrency) to High( aCurrency) do result := result + aCurrency[ Index];
end;

function SumOfArray( aInteger : array of Integer) : Integer; overload;
var
	Index : Integer;
begin
	result := 0;
	for Index := Low( aInteger) to High( aInteger) do result := result + aInteger[ Index];
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TPaybackSet.Prepare;
begin
	inherited Prepare;

	FMonthFirstday := StartOfTheMonth( Today);
	FMonthLastday := EndOfTheMonth( Today);
	FProfileKey := -1;
	dtpPublish.Date := Today;
end;

constructor TPaybackSet.Prepare( datMonthFirstday, datMonthLastday, datPublished : TDate; keyServer : Integer);
begin
	inherited Prepare;

	FMonthFirstday := datMonthFirstday;
	FMonthLastday := datMonthLastday;
	FProfileKey := keyServer;
	dtpPublish.Date := datPublished;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackSet.Recount();
begin
	pnlSpan.Caption := Format( '%s ` %s', [
		FormatDateTime( 'gg ee" N "yyyy" N "MM"  "dd" "', FMonthFirstday),
		FormatDateTime( 'gg ee" N "yyyy" N "MM"  "dd" "', FMonthLastday)
	]);

	if Appending then
	begin
		Proof.Close;
		Unregistered_Proof.ParamByName( 'keyServer').AsInteger := FProfileKey;
		Unregistered_Proof.ParamByName( 'datFrom').AsDate := FMonthFirstday;
		Unregistered_Proof.ParamByName( 'datTo').AsDate := FMonthLastday;
		Proof.Open;
	end
	else
	begin
		Proof.Close;
		Registered_Proof.ParamByName( 'keyPayback').AsInteger := PrimaryKey;
		Proof.Open;
	end;

	gridProof.SelectedRows.CurrentRowSelected := true;
end;

procedure TPaybackSet.Roundup();
var
	Bookmark : String;
begin
	FillChar( FPoint, SizeOf( FPoint), 0);
	FillChar( FCount, SizeOf( FCount), 0);

	Proof.DisableControls;
	Bookmark := Proof.Bookmark;
	Proof.First;
	with Proof do while not EOF do
	begin
		Edit;
		FieldByName( 'curExchange').AsCurrency := AmountOf(
			FieldByName( 'typExchange').AsInteger,
			FieldByName( 'curAmountPerCount').AsCurrency,
			FieldByName( 'curAmountPerHour').AsCurrency,
			FieldByName( 'intMinutesFor').AsInteger
		);
		Post;

		with FieldByName( 'typSchedule') do
		begin
			FPoint[ AsInteger] := FPoint[ AsInteger] + FieldByName( 'curExchange').AsCurrency;
			FCount[ AsInteger] := FCount[ AsInteger] + 1;
		end;

		Next;
	end;
	Proof.Bookmark := Bookmark;
	Proof.EnableControls;

	vlstPoint.Values[ 'T[rX_'] := Format( '%0.2n _', [ FPoint[ CARE_SCHEDULE]]);
	vlstPoint.Values[ 'ƎT[rX_'] := Format( '%0.2n _', [ FPoint[ MENAGE_SCHEDULE]]);
	vlstPoint.Values[ '}T[rX_'] := Format( '%0.2n _', [ FPoint[ MIGRATION_SCHEDULE]]);
	vlstPoint.Values[ 'ڑT[rX_'] := Format( '%0.2n _', [ FPoint[ TRANSFER_SCHEDULE]]);
	vlstPoint.Values[ 'v'] := Format( '%0.2n _', [ SumOfArray( FPoint)]);

	vlstCount.Values[ 'T[rX'] := Format( '%d ', [ FCount[ CARE_SCHEDULE]]);
	vlstCount.Values[ 'ƎT[rX'] := Format( '%d ', [ FCount[ MENAGE_SCHEDULE]]);
	vlstCount.Values[ '}T[rX'] := Format( '%d ', [ FCount[ MIGRATION_SCHEDULE]]);
	vlstCount.Values[ 'ڑT[rX'] := Format( '%d ', [ FCount[ TRANSFER_SCHEDULE]]);
	vlstCount.Values[ 'v'] := Format( '%d ', [ SumOfArray( FCount)]);

	btnBrowseProof.Enabled := not Proof.IsEmpty;
	btnRemoveProof.Enabled := ( not Proof.IsEmpty) and Appending;

	txtAmount_Change( self);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackSet.DefineTable( var nameOfTable : String; var modifyFlag, cancelFlag : Boolean);
begin
	nameOfTable := 'Payback';
	modifyFlag := false;
	cancelFlag := true;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackSet.BeforeInput();
begin
end;

procedure TPaybackSet.AfterInput();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackSet.BeforeSelect();
begin
	Registered_Payback.ParamByName( 'keyInstance').AsInteger := PrimaryKey;
	Registered_Payback.Open;

	ProviderOf_Proof.DataSet := Registered_Proof;
	// query setup

	with Registered_Payback do
	begin
		FMonthFirstday := FieldByName( 'datMonthFirstday').AsDateTime;
		FMonthLastday := FieldByName( 'datMonthLastday').AsDateTime;
		FProfileKey := FieldByName( 'refProfile').AsInteger;

		dtpPublish.Date := FieldByName( 'datPublished').AsDateTime;
		txtPricePerPoint.Text := FieldByName( 'intPricePerPoint').AsString;
		txtMargin.Text := FieldByName( 'intMargin').AsString;
	end;
	// other components setup
end;

procedure TPaybackSet.AfterSelect();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackSet.BeforeAppend();
begin
	Center.Open;

	Unregistered_Payback.ParamByName( 'keyProfile').AsInteger := FProfileKey;
	Unregistered_Payback.ParamByName( 'datPublished').AsDateTime := dtpPublish.Date;
	Unregistered_Payback.Open;

	ProviderOf_Proof.DataSet := Unregistered_Proof;

	txtPricePerPoint.Text := Center.FieldByName( 'intPricePerPoint').AsString;
end;

procedure TPaybackSet.AfterAppend();
begin
	with Unregistered_Payback do
	begin
		Edit;
		FieldByName( 'keyInstance').AsInteger := RealizedKey;

		FieldByName( 'datMonthFirstday').AsDateTime := FMonthFirstday;
		FieldByName( 'datMonthLastday').AsDateTime := FMonthLastday;
		FieldByName( 'datPublished').AsDateTime := dtpPublish.Date;

		FieldByName( 'intPricePerPoint').AsInteger := StrToInt( txtPricePerPoint.Text);
		FieldByName( 'curPoint').AsCurrency := SumOfArray( FPoint);
		FieldByName( 'intMargin').AsInteger := StrToInt( txtMargin.Text);

		FieldByName( 'curCarePoint').AsCurrency := FPoint[ CARE_SCHEDULE];
		FieldByName( 'curMenagePoint').AsCurrency := FPoint[ MENAGE_SCHEDULE];
		FieldByName( 'curMigrationPoint').AsCurrency := FPoint[ MIGRATION_SCHEDULE];
		FieldByName( 'curTransferPoint').AsCurrency := FPoint[ TRANSFER_SCHEDULE];

		Post;
		UpdaterOf_Payback.Apply( ukInsert);
	end;

	with Unregistered_Proof do
	begin
		Open;
		Proof.ApplyUpdates( 0);
		First;
		while not EOF do
		begin
			Edit;
			FieldByName( 'refPayback').AsInteger := RealizedKey;
			Post;
			UpdaterOf_Proof.Apply( ukInsert);
			Next;
		end;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackSet.BeforePopup();
begin
	dtpPublish.Enabled := Appending;
	dtpPublish_Change( dtpPublish);

	btnChooseProfile.Enabled := Appending;

	txtPricePerPoint.ReadOnly := Browsing;
	txtMargin.ReadOnly := Browsing;

	btnPrint.Visible := not Appending;

	Caption := Format( '%s - %s ` %s', [
		Caption,
		FormatDateTime( 'yyyy" N "MM"  "dd" "', FMonthFirstday),
		FormatDateTime( 'yyyy" N "MM"  "dd" "', FMonthLastday)
	]);

	Recount;

	if not Appending then lblCode.Caption := Format( 'ZԍF(%d)', [ PrimaryKey]);
end;

procedure TPaybackSet.AfterPopup();
var
	PricePerPoint, Margin : Integer;
begin
	with Unregistered_Payback do if IsEmpty then
		ErrorMessages.Add( 'w肳ꂽL[ɊYo^҂̋L^͂܂B');

	with Unregistered_Payback do if ( not IsEmpty) and FieldByName( 'strAddress').IsNull then
		ErrorMessages.Add( '̓o^҂ɂ͐Zɂ鎩Z̓o^܂B');

	if dtpPublish.Date < FMonthLastday then
		ErrorMessages.Add( 'sWvԓɂȂĂ܂B');

	PricePerPoint := StrToIntDef( txtPricePerPoint.Text, 0);
	Margin := StrToIntDef( txtMargin.Text, -1);

	if Proof.IsEmpty then
		ErrorMessages.Add( '̓o^҂ɂ͐ZΏۂƂȂт܂B');

	if PricePerPoint <= 0 then
		ErrorMessages.Add( '_P͔p݂̂pĂO傫lŎw肵ĂB');

	if Margin < 0 then
		ErrorMessages.Add( '萔͔p݂̂pĎw肵ĂB');

	if SumOfArray( FPoint) + Margin = 0 then
		ErrorMessages.Add( 'ZΏۂƂȂт萔̎w܂B');

	if Margin > PricePerPoint * SumOfArray( FPoint) then
		ErrorMessages.Add( '萔ZzĂ܂B');

	if Center.FieldByName( 'typPaybackMarginPerEvent').AsInteger = MARGIN_BY_MANUAL then
		if SilentAction then
			ErrorMessages.Add( 'N/A');
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackSet.dtpPublish_Change(Sender: TObject);
begin
	dtpPublish.Format := FormatDateTime( ' gg ee "N yyyy N MM  dd "', dtpPublish.Date);

	if Appending and ( not Preparing) then
	begin
		Unregistered_Payback.Close;
		Unregistered_Payback.ParamByName( 'datPublished').AsDateTime := dtpPublish.Date;
		Unregistered_Payback.Open;
	end;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackSet.btnBrowseProfile_Click( Sender: TObject);
begin
	TServerSet.Prepare.Browse( FProfileKey);
end;

procedure TPaybackSet.btnChooseProfile_Click(Sender: TObject);
begin
	if ChooseServer( Transaction, dtpPublish.Date, FProfileKey) then
	begin
		Unregistered_Payback.Close;
		Unregistered_Payback.ParamByName( 'keyProfile').AsInteger := FProfileKey;
		Unregistered_Payback.Open;

		Recount;

		txtMargin.SetFocus;
	end;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackSet.txtAmount_Change(Sender: TObject);
begin
	if Appending then case Center.FieldByName( 'typPaybackMarginPerEvent').AsInteger of
	MARGIN_BY_PERMILLAGE : txtMargin.Text := IntToStr( Center.FieldByName( 'intPaybackMarginPerCheck').AsInteger + Trunc( CurrToPoint( SumOfArray( FPoint)) * StrToIntDef( txtPricePerPoint.Text, 0)) * Center.FieldByName( 'intPaybackMarginPerEvent').AsInteger div 1000);
	MARGIN_BY_PERCOUNT : txtMargin.Text := IntToStr( Center.FieldByName( 'intPaybackMarginPerCheck').AsInteger + SumOfArray( FCount) * Center.FieldByName( 'intPaybackMarginPerEvent').AsInteger);
	end;

	txtMargin_Change( Sender);
end;

procedure TPaybackSet.txtMargin_Change(Sender: TObject);
begin
	if SumOfArray( FCount) = 0 then
	begin
		txtSummary.Text := ' *** ZΏۂƂȂт܂ ***';
		exit;
	end;

	if StrToIntDef( txtMargin.Text, 0) > 0 then
		txtSummary.Text := Format( ' %0.2n _ ~ %0.0n ~ | %0.0n ~  %0.0n ~', [
			CurrToPoint( SumOfArray( FPoint)),
			Int( StrToIntDef( txtPricePerPoint.Text, 0)),
			Int( StrToIntDef( txtMargin.Text, 0)),
			Int( CurrToPoint( SumOfArray( FPoint)) * StrToIntDef( txtPricePerPoint.Text, 0))
				- StrToIntDef( txtMargin.Text, 0)
		])
	else
		txtSummary.Text := Format( ' %0.2n _ ~ %0.0n ~  %0.0n ~', [
			CurrToPoint( SumOfArray( FPoint)),
			Int( StrToIntDef( txtPricePerPoint.Text, 0)),
			Int( CurrToPoint( SumOfArray( FPoint)) * StrToIntDef( txtPricePerPoint.Text, 0))
		]);
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackSet.btnChooseSpan_Click(Sender: TObject);
begin
	if ChooseSpan( FMonthFirstday, FMonthLastday) then Recount;
end;

procedure TPaybackSet.btnQuoteSpanHead_Click(Sender: TObject);
begin
	PrevLastday.ParamByName( 'keyProfile').AsInteger := FProfileKey;
	PrevLastday.Open;
	if PrevLastday.FieldByName( 'datLatestLastday').AsDateTime = 0 then
		ShowNotify( 'ZL^܂łB', '`PbgZ')
	else
		FMonthFirstday := Min( FMonthLastday, IncDay( PrevLastday.FieldByName( 'datLatestLastday').AsDateTime));
	PrevLastday.Close;
	Recount;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackSet.Payback_AfterOpen(DataSet: TDataSet);
begin
	with DataSet do if IsEmpty then
	begin
		txtCode.Text := '';
		txtFamilyNameRead.Text := 'Ă傤';
		txtFamilyName.Text := '񋟎';
		txtFirstNameRead.Text := '߂';
		txtFirstName.Text := '';
		pnlBirthday.Caption := 'N N';
		pnlSex.Caption := '';
		txtInformation.Text := 'dbԍP / FAXԍP / Z';

		btnChooseSpan.Enabled := false;
		btnQuoteSpanHead.Enabled := false;
	end
	else
	begin
		FProfileKey := FieldByName( 'refProfile').AsInteger;

		txtCode.Text := Trim( FieldByName( 'strCode').AsString);
		txtFamilyNameRead.Text := Trim( FieldByName( 'strFamilyNameRead').AsString);
		txtFamilyName.Text := Trim( FieldByName( 'strFamilyName').AsString);
		txtFirstNameRead.Text := Trim( FieldByName( 'strFirstNameRead').AsString);
		txtFirstName.Text := Trim( FieldByName( 'strFirstName').AsString);
		pnlBirthday.Caption := Format( '%s %s', [
			FormatDateTime( 'yyyy" N "MM"  "dd" "', FieldByName( 'datBirthday').AsDateTime),
			ToAgeText( dtpPublish.Date, FieldByName( 'datBirthday').AsDateTime)
		]);
		pnlSex.Caption := aSex[ FieldByName( 'typSex').AsInteger];

		txtInformation.Text := Format( '%s / %s / %s', [
			Trim( FieldByName( 'strPhoneNumber1').AsString),
			Trim( FieldByName( 'strFaxNumber1').AsString),
			Trim( FieldByName( 'strAddress').AsString)
		]);

		btnChooseSpan.Enabled := Appending;
		btnQuoteSpanHead.Enabled := Appending;
	end;
end;

procedure TPaybackSet.Proof_AfterOpen(DataSet: TDataSet);
begin
	Roundup;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackSet.Grid_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
	strText : String;
begin
	if Column.Field.IsNull then exit;

	if Column.Field.FieldName = 'INTMINUTESAT' then
	begin
		case Proof.FieldByName( 'typSchedule').AsInteger of
		CARE_SCHEDULE, MENAGE_SCHEDULE :
			( Sender as TDBGrid).Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, RangeToText(
				Column.Field.AsInteger,
				Proof.FieldByName( 'intMinutesFor').AsInteger
			));

		MIGRATION_SCHEDULE, TRANSFER_SCHEDULE :
			( Sender as TDBGrid).Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, MinutesToText( Column.Field.AsInteger));
		end;
		exit;
	end;

	if Column.Field.FieldName = 'STRADDRESSFROM' then
	begin
		case Proof.FieldByName( 'typSchedule').AsInteger of
		CARE_SCHEDULE, MENAGE_SCHEDULE :
			( Sender as TDBGrid).Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Column.Field.AsString);

		MIGRATION_SCHEDULE, TRANSFER_SCHEDULE :
			( Sender as TDBGrid).Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Format( '%s  %s', [
				Column.Field.AsString,
				Proof.FieldByName( 'strAddressTo').AsString
			]));
		end;
		exit;
	end;

	if Column.Field.FieldName = 'CUREXCHANGE' then
	begin
		strText := Format( '%0.2n_', [ Column.Field.AsCurrency]);
		( Sender as TDBGrid).Canvas.TextRect(
			Rect,
			Rect.Right - 2 - ( Sender as TDBGrid).Canvas.TextWidth( strText),
			Rect.Top + 2,
			strText
		);
	end
	else
		( Sender as TDBGrid).Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Column.Field.AsString);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackSet.btnBrowseProof_Click(Sender: TObject);
begin
	if not btnBrowseProof.Enabled then exit;
	TSnapshotDialog.Prepare( '(`PbgZ)').Browse( Transaction, Proof);
end;

procedure TPaybackSet.btnRemoveProof_Click(Sender: TObject);
var
	index : Integer;
begin
	Proof.DisableControls;
	for index := 0 to gridProof.SelectedRows.Count - 1 do
	begin
		Proof.Bookmark := gridProof.SelectedRows.Items[ index];
		Proof.Delete;
	end;
	Proof.EnableControls;
	gridProof.SelectedRows.Refresh;
	gridProof.SelectedRows.CurrentRowSelected := true;

	Roundup;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackSet.btnPrint_Click(Sender: TObject);
begin
	TPaybackReport.Prepare( PrimaryKey).Preview;
end;

end.
