unit Set_Payment;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, IBSQL, IBDatabase, StdCtrls, ExtCtrls, ComCtrls, Grids, DBGrids,
  DB, DBClient, Provider, IBCustomDataSet, IBQuery, StrUtils, DateUtils,
  DBCtrls, Base_Set, IBEvents, Math, ValEdit, IBUpdateSQL,
  Misc_Constants, Misc_Utilities;

type
  TPaymentSet = class(TSetTemplate)
    Center: TIBQuery;

    Unregistered_Payment: TIBQuery;
    UpdaterOf_Payment: TIBUpdateSQL;
    Registered_Payment: TIBQuery;

    Unregistered_Supply: TIBQuery;
    UpdaterOf_Supply: TIBUpdateSQL;
    Registered_Supply: TIBQuery;
    ProviderOf_Supply: TDataSetProvider;
    Supply: TClientDataSet;
    DataSourceOf_Supply: TDataSource;

    PrevLastday: TIBQuery;

    lblCode: TLabel;
    lblPublish: TLabel;
    dtpPublish: TDateTimePicker;
    bvlUpperBorder: TBevel;

    txtCode: TLabeledEdit;
    btnBrowseProfile: TButton;
    btnChooseProfile: TButton;
    txtFamilyNameRead: TLabeledEdit;
    txtFamilyName: TLabeledEdit;
    txtFirstNameRead: TLabeledEdit;
    txtFirstName: TLabeledEdit;
    lblBirthday: TLabel;
    pnlSex: TPanel;
    pnlBirthday: TPanel;
    txtInformation: TEdit;
    vlstCash: TValueListEditor;
    vlstCount: TValueListEditor;
    bvlMidBorder: TBevel;
    txtSummary: TEdit;
    txtMargin: TLabeledEdit;
    lblMargin: TLabel;
    bvlLowerBorder: TBevel;

    pnlSpan: TPanel;
    btnChooseSpan: TButton;
    btnQuoteSpanHead: TButton;

    gridSupply: TDBGrid;

    btnBrowseSupply: TButton;
    btnRemoveSupply: TButton;

    btnPrint: TButton;

    procedure dtpPublish_Change(Sender: TObject);

    procedure btnBrowseProfile_Click(Sender: TObject);
    procedure btnChooseProfile_Click(Sender: TObject);

    procedure txtAmount_Change(Sender: TObject);
    procedure txtMargin_Change(Sender: TObject);

    procedure btnChooseSpan_Click(Sender: TObject);
    procedure btnQuoteSpanHead_Click(Sender: TObject);

    procedure Payment_AfterOpen(DataSet: TDataSet);
    procedure Supply_AfterOpen(DataSet: TDataSet);

    procedure Grid_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);

    procedure btnBrowseSupply_Click(Sender: TObject);
    procedure btnRemoveSupply_Click(Sender: TObject);

    procedure btnPrint_Click(Sender: TObject);

  private
    { Private 錾 }
    FMonthFirstday : TDate;
    FMonthLastday : TDate;
    FProfileKey : Integer;

    FCash : array[ CARE_SCHEDULE..TRANSFER_SCHEDULE] of Integer;
    FCount : array[ CARE_SCHEDULE..TRANSFER_SCHEDULE] of Integer;

    procedure Recount();
    procedure Roundup();
  protected
    { Protected 錾 }
    procedure DefineTable( var nameOfTable : String; var modifyFlag, cancelFlag : Boolean); override;

    procedure BeforeInput(); override;
    procedure AfterInput(); override;

    procedure BeforeSelect(); override;
    procedure AfterSelect(); override;

    procedure BeforeAppend(); override;
    procedure AfterAppend(); override;

    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
    constructor Prepare; overload; override;
    constructor Prepare( datMonthFirstday, datMonthLastday, datPublished : TDate; keyServer : Integer); overload;
  end;

var
  PaymentSet: TPaymentSet;

implementation

{$R *.dfm}

uses Chooser_Server, Set_Server, Chooser_Span, Dialog_Snapshot, Report_Payment;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function SumOfArray( aInteger : array of Integer) : Integer; overload;
var
	Index : Integer;
begin
	result := 0;
	for Index := Low( aInteger) to High( aInteger) do result := result + aInteger[ Index];
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TPaymentSet.Prepare;
begin
	inherited Prepare;

	FMonthFirstday := StartOfTheMonth( Today);
	FMonthLastday := EndOfTheMonth( Today);
	FProfileKey := -1;
	dtpPublish.Date := Today;
end;

constructor TPaymentSet.Prepare( datMonthFirstday, datMonthLastday, datPublished : TDate; keyServer : Integer);
begin
	inherited Prepare;

	FMonthFirstday := datMonthFirstday;
	FMonthLastday := datMonthLastday;
	FProfileKey := keyServer;
	dtpPublish.Date := datPublished;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentSet.Recount();
begin
	pnlSpan.Caption := Format( '%s ` %s', [
		FormatDateTime( 'gg ee" N "yyyy" N "MM"  "dd" "', FMonthFirstday),
		FormatDateTime( 'gg ee" N "yyyy" N "MM"  "dd" "', FMonthLastday)
	]);

	if Appending then
	begin
		Supply.Close;
		Unregistered_Supply.ParamByName( 'keyServer').AsInteger := FProfileKey;
		Unregistered_Supply.ParamByName( 'datFrom').AsDate := FMonthFirstday;
		Unregistered_Supply.ParamByName( 'datTo').AsDate := FMonthLastday;
		Supply.Open;
	end
	else
	begin
		Supply.Close;
		Registered_Supply.ParamByName( 'keyPayment').AsInteger := PrimaryKey;
		Supply.Open;
	end;

	gridSupply.SelectedRows.CurrentRowSelected := true;
end;

procedure TPaymentSet.Roundup();
var
	Bookmark : String;
begin
	FillChar( FCash, SizeOf( FCash), 0);
	FillChar( FCount, SizeOf( FCount), 0);

	Supply.DisableControls;
	Bookmark := Supply.Bookmark;
	Supply.First;
	with Supply do while not EOF do
	begin
		Edit;
		FieldByName( 'intExchange').AsCurrency := AmountOf(
			FieldByName( 'typExchange').AsInteger,
			FieldByName( 'curAmountPerCount').AsCurrency,
			FieldByName( 'curAmountPerHour').AsCurrency,
			FieldByName( 'intMinutesFor').AsInteger
		);
		Post;

		with FieldByName( 'typSchedule') do
		begin
			FCash[ AsInteger] := FCash[ AsInteger] + FieldByName( 'intExchange').AsInteger;
			FCount[ AsInteger] := FCount[ AsInteger] + 1;
		end;

		Next;
	end;
	Supply.Bookmark := Bookmark;
	Supply.EnableControls;

	vlstCash.Values[ 'T[rXz'] := Format( '%0.0n ~', [ Int( FCash[ CARE_SCHEDULE])]);
	vlstCash.Values[ 'ƎT[rXz'] := Format( '%0.0n ~', [ Int( FCash[ MENAGE_SCHEDULE])]);
	vlstCash.Values[ '}T[rXz'] := Format( '%0.0n ~', [ Int( FCash[ MIGRATION_SCHEDULE])]);
	vlstCash.Values[ 'ڑT[rXz'] := Format( '%0.0n ~', [ Int( FCash[ TRANSFER_SCHEDULE])]);
	vlstCash.Values[ 'v'] := Format( '%0.0n ~', [ Int( SumOfArray( FCash))]);

	vlstCount.Values[ 'T[rX'] := Format( '%d ', [ FCount[ CARE_SCHEDULE]]);
	vlstCount.Values[ 'ƎT[rX'] := Format( '%d ', [ FCount[ MENAGE_SCHEDULE]]);
	vlstCount.Values[ '}T[rX'] := Format( '%d ', [ FCount[ MIGRATION_SCHEDULE]]);
	vlstCount.Values[ 'ڑT[rX'] := Format( '%d ', [ FCount[ TRANSFER_SCHEDULE]]);
	vlstCount.Values[ 'v'] := Format( '%d ', [ SumOfArray( FCount)]);

	btnBrowseSupply.Enabled := not Supply.IsEmpty;
	btnRemoveSupply.Enabled := ( not Supply.IsEmpty) and Appending;

	txtAmount_Change( self);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentSet.DefineTable( var nameOfTable : String; var modifyFlag, cancelFlag : Boolean);
begin
	nameOfTable := 'Payment';
	modifyFlag := false;
	cancelFlag := true;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentSet.BeforeInput();
begin
end;

procedure TPaymentSet.AfterInput();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentSet.BeforeSelect();
begin
	Registered_Payment.ParamByName( 'keyInstance').AsInteger := PrimaryKey;
	Registered_Payment.Open;

	ProviderOf_Supply.DataSet := Registered_Supply;
	// query setup

	with Registered_Payment do
	begin
		lblCode.Caption := 'ZԍF' + IntToStr( PrimaryKey);
		FMonthFirstday := FieldByName( 'datMonthFirstday').AsDateTime;
		FMonthLastday := FieldByName( 'datMonthLastday').AsDateTime;

		dtpPublish.Date := FieldByName( 'datPublished').AsDateTime;
		txtMargin.Text := FieldByName( 'intMargin').AsString;
	end;
	// other components setup
end;

procedure TPaymentSet.AfterSelect();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentSet.BeforeAppend();
begin
	Center.Open;

	Unregistered_Payment.ParamByName( 'keyProfile').AsInteger := FProfileKey;
	Unregistered_Payment.ParamByName( 'datPublished').AsDateTime := dtpPublish.Date;
	Unregistered_Payment.Open;

	ProviderOf_Supply.DataSet := Unregistered_Supply;
end;

procedure TPaymentSet.AfterAppend();
begin
	with Unregistered_Payment do
	begin
		Edit;
		FieldByName( 'keyInstance').AsInteger := RealizedKey;

		FieldByName( 'datMonthFirstday').AsDateTime := FMonthFirstday;
		FieldByName( 'datMonthLastday').AsDateTime := FMonthLastday;
		FieldByName( 'datPublished').AsDateTime := dtpPublish.Date;

		FieldByName( 'intCash').AsCurrency := SumOfArray( FCash);
		FieldByName( 'intMargin').AsInteger := StrToInt( txtMargin.Text);

		FieldByName( 'intCareCash').AsCurrency := FCash[ CARE_SCHEDULE];
		FieldByName( 'intMenageCash').AsCurrency := FCash[ MENAGE_SCHEDULE];
		FieldByName( 'intMigrationCash').AsCurrency := FCash[ MIGRATION_SCHEDULE];
		FieldByName( 'intTransferCash').AsCurrency := FCash[ TRANSFER_SCHEDULE];

		Post;
		UpdaterOf_Payment.Apply( ukInsert);
	end;

	with Unregistered_Supply do
	begin
		Open;
		Supply.ApplyUpdates( 0);
		First;
		while not Eof do
		begin
			Edit;
			FieldByName( 'refPayment').AsInteger := RealizedKey;
			Post;
			UpdaterOf_Supply.Apply( ukInsert);
			Next;
		end;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentSet.BeforePopup();
begin
	dtpPublish.Enabled := Appending;
	dtpPublish_Change( dtpPublish);

	btnChooseProfile.Enabled := Appending;

	txtMargin.ReadOnly := Browsing;

	btnPrint.Visible := not Appending;

	Caption := Format( '%s - %s ` %s', [
		Caption,
		FormatDateTime( 'yyyy" N "MM"  "dd" "', FMonthFirstday),
		FormatDateTime( 'yyyy" N "MM"  "dd" "', FMonthLastday)
	]);

	Recount;

	if not Appending then lblCode.Caption := Format( 'ZԍF(%d)', [ PrimaryKey]);
end;

procedure TPaymentSet.AfterPopup();
var
	Margin : Integer;
begin
	with Unregistered_Payment do if IsEmpty then
		ErrorMessages.Add( 'w肳ꂽL[ɊYo^҂̋L^͂܂B');

	with Unregistered_Payment do if ( not IsEmpty) and FieldByName( 'strAddress').IsNull then
		ErrorMessages.Add( '̓o^҂ɂ͐Zɂ鎩Z̓o^܂B');

	if dtpPublish.Date < FMonthLastday then
		ErrorMessages.Add( 'sWvԓɂȂĂ܂B');

	Margin := StrToIntDef( txtMargin.Text, -1);

	if Margin < 0 then
		ErrorMessages.Add( '萔͔p݂̂pĎw肵ĂB');

	if SumOfArray( FCash) + Margin = 0 then
		ErrorMessages.Add( 'ZΏۂƂȂт萔̎w܂B');

	if Margin > SumOfArray( FCash) then
		ErrorMessages.Add( '萔ZzĂ܂B');

	if Center.FieldByName( 'typPaymentMarginPerEvent').AsInteger = MARGIN_BY_MANUAL then
		if SilentAction then
			ErrorMessages.Add( 'N/A');
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentSet.dtpPublish_Change(Sender: TObject);
begin
	dtpPublish.Format := FormatDateTime( ' gg ee "N yyyy N MM  dd "', dtpPublish.Date);

	if Appending then
	begin
		Unregistered_Payment.Close;
		Unregistered_Payment.ParamByName( 'datPublished').AsDateTime := dtpPublish.Date;
		Unregistered_Payment.Open;
	end;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentSet.btnBrowseProfile_Click( Sender: TObject);
begin
	TServerSet.Prepare.Browse( FProfileKey);
end;

procedure TPaymentSet.btnChooseProfile_Click(Sender: TObject);
begin
	if ChooseServer( Transaction, dtpPublish.Date, FProfileKey) then
	begin
		Unregistered_Payment.Close;
		Unregistered_Payment.ParamByName( 'keyProfile').AsInteger := FProfileKey;
		Unregistered_Payment.Open;

		Recount;

		txtMargin.SetFocus;
	end;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentSet.txtAmount_Change(Sender: TObject);
begin
	if Appending then case Center.FieldByName( 'typPaymentMarginPerEvent').AsInteger of
	MARGIN_BY_PERMILLAGE : txtMargin.Text := IntToStr( Center.FieldByName( 'intPaymentMarginPerCheck').AsInteger + SumOfArray( FCash) * Center.FieldByName( 'intPaymentMarginPerEvent').AsInteger div 1000);
	MARGIN_BY_PERCOUNT : txtMargin.Text := IntToStr( Center.FieldByName( 'intPaymentMarginPerCheck').AsInteger + SumOfArray( FCount) * Center.FieldByName( 'intPaymentMarginPerEvent').AsInteger);
	end;

	txtMargin_Change( Sender);
end;

procedure TPaymentSet.txtMargin_Change(Sender: TObject);
begin
	if SumOfArray( FCount) = 0 then
	begin
		txtSummary.Text := ' *** ZΏۂƂȂт܂ ***';
		exit;
	end;

	if StrToIntDef( txtMargin.Text, 0) > 0 then
		txtSummary.Text := Format( ' %0.0n ~ | %0.0n ~  %0.0n ~', [
			Int( SumOfArray( FCash)),
			Int( StrToIntDef( txtMargin.Text, 0)),
			Int( SumOfArray( FCash) - StrToIntDef( txtMargin.Text, 0))
		])
	else
		txtSummary.Text := Format( ' %0.0n ~', [ Int( SumOfArray( FCash))]);
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentSet.btnChooseSpan_Click(Sender: TObject);
begin
	if ChooseSpan( FMonthFirstday, FMonthLastday) then Recount;
end;

procedure TPaymentSet.btnQuoteSpanHead_Click(Sender: TObject);
begin
	PrevLastday.ParamByName( 'keyProfile').AsInteger := FProfileKey;
	PrevLastday.Open;
	if PrevLastday.FieldByName( 'datLatestLastday').AsDateTime = 0 then
		ShowNotify( 'ZL^܂łB', 'Z')
	else
		FMonthFirstday := Min( FMonthLastday, IncDay( PrevLastday.FieldByName( 'datLatestLastday').AsDateTime));
	PrevLastday.Close;
	Recount;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentSet.Payment_AfterOpen(DataSet: TDataSet);
begin
	with DataSet do if IsEmpty then
	begin
		txtCode.Text := '';
		txtFamilyNameRead.Text := 'Ă傤';
		txtFamilyName.Text := '񋟎';
		txtFirstNameRead.Text := '߂';
		txtFirstName.Text := '';
		pnlBirthday.Caption := 'N N';
		pnlSex.Caption := '';
		txtInformation.Text := 'dbԍP / FAXԍP / Z';

		btnChooseSpan.Enabled := false;
		btnQuoteSpanHead.Enabled := false;
	end
	else
	begin
		FProfileKey := FieldByName( 'refProfile').AsInteger;

		txtCode.Text := Trim( FieldByName( 'strCode').AsString);
		txtFamilyNameRead.Text := Trim( FieldByName( 'strFamilyNameRead').AsString);
		txtFamilyName.Text := Trim( FieldByName( 'strFamilyName').AsString);
		txtFirstNameRead.Text := Trim( FieldByName( 'strFirstNameRead').AsString);
		txtFirstName.Text := Trim( FieldByName( 'strFirstName').AsString);
		pnlBirthday.Caption := Format( '%s %s', [
			FormatDateTime( 'yyyy" N "MM"  "dd" "', FieldByName( 'datBirthday').AsDateTime),
			ToAgeText( dtpPublish.Date, FieldByName( 'datBirthday').AsDateTime)
		]);
		pnlSex.Caption := aSex[ FieldByName( 'typSex').AsInteger];

		txtInformation.Text := Format( '%s / %s / %s', [
			Trim( FieldByName( 'strPhoneNumber1').AsString),
			Trim( FieldByName( 'strFaxNumber1').AsString),
			Trim( FieldByName( 'strAddress').AsString)
		]);

		btnChooseSpan.Enabled := Appending;
		btnQuoteSpanHead.Enabled := Appending;
	end;
end;

procedure TPaymentSet.Supply_AfterOpen(DataSet: TDataSet);
begin
	Roundup;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentSet.Grid_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
	strText : String;
begin
	if Column.Field.IsNull then exit;

	if Column.Field.FieldName = 'INTMINUTESAT' then
	begin
		case Supply.FieldByName( 'typSchedule').AsInteger of
		CARE_SCHEDULE, MENAGE_SCHEDULE :
			( Sender as TDBGrid).Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, RangeToText(
				Column.Field.AsInteger,
				Supply.FieldByName( 'intMinutesFor').AsInteger
			));

		MIGRATION_SCHEDULE, TRANSFER_SCHEDULE :
			( Sender as TDBGrid).Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, MinutesToText( Column.Field.AsInteger));
		end;
		exit;
	end;

	if Column.Field.FieldName = 'STRADDRESSFROM' then
	begin
		case Supply.FieldByName( 'typSchedule').AsInteger of
		CARE_SCHEDULE, MENAGE_SCHEDULE :
			( Sender as TDBGrid).Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Column.Field.AsString);

		MIGRATION_SCHEDULE, TRANSFER_SCHEDULE :
			( Sender as TDBGrid).Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Format( '%s  %s', [
				Column.Field.AsString,
				Supply.FieldByName( 'strAddressTo').AsString
			]));
		end;
		exit;
	end;

	if Column.Field.FieldName = 'INTEXCHANGE' then
	begin
		strText := Format( '%0.0n~', [ Column.Field.AsCurrency]);
		( Sender as TDBGrid).Canvas.TextRect(
			Rect,
			Rect.Right - 2 - ( Sender as TDBGrid).Canvas.TextWidth( strText),
			Rect.Top + 2,
			strText
		);
	end
	else
		( Sender as TDBGrid).Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Column.Field.AsString);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentSet.btnBrowseSupply_Click(Sender: TObject);
begin
	if not btnBrowseSupply.Enabled then exit;
	TSnapshotDialog.Prepare( '(Z)').Browse( Transaction, Supply);
end;

procedure TPaymentSet.btnRemoveSupply_Click(Sender: TObject);
var
	index : Integer;
begin
	Supply.DisableControls;
	for index := 0 to gridSupply.SelectedRows.Count - 1 do
	begin
		Supply.Bookmark := gridSupply.SelectedRows.Items[ index];
		Supply.Delete;
	end;
	Supply.EnableControls;
	gridSupply.SelectedRows.Refresh;
	gridSupply.SelectedRows.CurrentRowSelected := true;

	Roundup;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentSet.btnPrint_Click(Sender: TObject);
begin
	TPaymentReport.Prepare( PrimaryKey).Preview;
end;

end.
