unit Set_Service;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, DBCtrls, DB, IBCustomDataSet, IBUpdateSQL,
  IBTable, StrUtils, IBQuery, ComCtrls, Provider, DBClient, DBLocal,
  MainDatastore, DBLocalI, IB, IBErrorCodes, IBSQL, IBDatabase, Grids, DBGrids,
  Base_Set, DateUtils, Misc_Constants, Misc_Utilities,
  Piece_ValiditySelector;

type
  TServiceSet = class(TSetTemplate)
    Service: TIBQuery;
    UpdaterOf_Service: TIBUpdateSQL;

    SourceOf_Exchange: TIBQuery;
    UpdaterOf_Exchange: TIBUpdateSQL;
    ProviderOf_Exchange: TDataSetProvider;
    Exchange: TClientDataSet;
    DataSourceOf_Exchange: TDataSource;

    Validity: TValiditySelector;

    lblCategory: TLabel;
    cboCategory: TComboBox;
    txtName: TLabeledEdit;
    bvlIdentity: TBevel;

    lblAvailability: TLabel;
    chkMonday: TCheckBox;
    chkFriday: TCheckBox;
    chkWednesday: TCheckBox;
    chkTuesday: TCheckBox;
    chkThursday: TCheckBox;
    chkSunday: TCheckBox;
    chkSaturday: TCheckBox;
    bvlAvailability: TBevel;
    btnPrint: TButton;
    gridExchange: TDBGrid;
    btnAppendExchange: TButton;
    btnDeleteExchange: TButton;
    btnSelectExchange: TButton;
    chkHideUnavailableExchange: TCheckBox;

    procedure Grid_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);

    procedure Exchange_AfterUpdate(DataSet: TDataSet);
    procedure Exchange_FilterRecord(DataSet: TDataSet; var Accept: Boolean);
    procedure chkHideUnavailableExchange_Click(Sender: TObject);
    procedure btnSelectExchange_Click(Sender: TObject);
    procedure btnAppendExchange_Click(Sender: TObject);
    procedure btnDeleteExchange_Click(Sender: TObject);

    procedure btnPrint_Click(Sender: TObject);

  private
    { Private 錾 }
  protected
    { Protected 錾 }
    procedure DefineTable( var nameOfTable : String; var modifyFlag, cancelFlag : Boolean); override;

    procedure BeforeInput(); override;
    procedure AfterInput(); override;

    procedure BeforeSelect(); override;
    procedure AfterSelect(); override;

    procedure BeforeAppend(); override;
    procedure AfterAppend(); override;

    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
  end;

var
  ServiceSet: TServiceSet;

implementation

{$R *.dfm}

uses Dialog_Exchange, Report_Service;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServiceSet.DefineTable( var nameOfTable : String; var modifyFlag, cancelFlag : Boolean);
begin
	nameOfTable := 'Service';
	modifyFlag := true;
	cancelFlag := true;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServiceSet.BeforeInput();
begin
	Service.ParamByName( 'keyInstance').AsInteger := PrimaryKey;
	Service.Open;

	SourceOf_Exchange.ParamByName( 'keyService').AsInteger := PrimaryKey;
	Exchange.Open;
end;

procedure TServiceSet.AfterInput();
begin
	with Service do
	begin
		if Appending then Append else Edit;
		FieldByName( 'keyInstance').AsInteger := RealizedKey;
		FieldByName( 'typCategory').AsInteger := cboCategory.ItemIndex;
		FieldByName( 'datAvailableFrom').AsDateTime := Validity.AvailableFrom;
		FieldByName( 'datAvailableTo').AsDateTime := Validity.AvailableTo;
		FieldByName( 'strName').AsString := Trim( txtName.Text);
		FieldByName( 'optAvailability').AsInteger := CheckBoxesToOptions( [ chkSunday, chkMonday, chkTuesday, chkWednesday, chkThursday, chkFriday, chkSaturday]);
		Post;
		ApplyUpdates;
	end;

	if Exchange.ApplyUpdates( 0) > 0 then ErrorMessages.Add( 'Exchange operation error');
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServiceSet.BeforeSelect();
begin
	with Service do
	begin
		Validity.AvailableFrom := FieldByName( 'datAvailableFrom').AsDateTime;
		Validity.AvailableTo := FieldByName( 'datAvailableTo').AsDateTime;

		cboCategory.ItemIndex := FieldByName( 'typCategory').AsInteger;
		txtName.Text := Trim( FieldByName( 'strName').AsString);

		OptionsToCheckBoxes( FieldByName( 'optAvailability').AsInteger, [
			chkSunday, chkMonday, chkTuesday, chkWednesday, chkThursday, chkFriday, chkSaturday
		]);
	end;
end;

procedure TServiceSet.AfterSelect();
begin
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServiceSet.BeforeAppend();
begin
	Validity.AvailableFrom := StartOfTheMonth( Today);
	Validity.AvailableTo := StrToDate( '2087/12/31');

	txtName.Text := '(T[rX͂Ă)';
end;

procedure TServiceSet.AfterAppend();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServiceSet.BeforePopup();
begin
	Validity.ReadOnly := Browsing;

	cboCategory.Enabled := Appending;
	txtName.ReadOnly := Browsing;

	btnPrint.Visible := not Appending;
end;

procedure TServiceSet.AfterPopup();
begin
	ErrorCheck_Empty( 'O', txtName.Text, ErrorMessages);

	if CheckBoxesToOptions( [ chkSunday, chkMonday, chkTuesday, chkWednesday, chkThursday, chkFriday, chkSaturday]) = 0 then
		ErrorMessages.Add( '{jw肳Ă܂B');

	if Exchange.IsEmpty then
		ErrorMessages.Add( 'ӗ炪o^Ă܂B');
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServiceSet.Grid_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
begin
	with Column do if ( PickList.Count > 0) and ( not Field.IsNull) then
	begin
		( Sender as TDBGrid).Canvas.TextRect(
			Rect, Rect.Left + 2, Rect.Top + 2, PickList[ Field.AsInteger]
		);
	end;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServiceSet.Exchange_AfterUpdate(DataSet: TDataSet);
begin
	btnSelectExchange.Enabled := not Exchange.IsEmpty;
	btnAppendExchange.Enabled := not Browsing;
	btnDeleteExchange.Enabled := not ( Browsing or Exchange.IsEmpty);
end;

procedure TServiceSet.Exchange_FilterRecord(DataSet: TDataSet; var Accept: Boolean);
begin
	Accept := ( Exchange.FieldByName( 'typStatus').AsInteger = DATA_ENABLED)
		and ( chkHideUnavailableExchange.Checked
			or (
				( Exchange.FieldByName( 'datAvailableFrom').AsDateTime <= Today)
					and ( Today <= Exchange.FieldByName( 'datAvailableTo').AsDateTime)
			)
		);
end;

procedure TServiceSet.chkHideUnavailableExchange_Click(Sender: TObject);
begin
	Exchange.First;
end;

procedure TServiceSet.btnSelectExchange_Click(Sender: TObject);
begin
	if not btnSelectExchange.Enabled then exit;
	if Browsing then
		TExchangeDialog.Prepare( RealizedKey).Browse( Transaction, Exchange)
	else
		TExchangeDialog.Prepare( RealizedKey).Select( Transaction, Exchange);
end;

procedure TServiceSet.btnAppendExchange_Click(Sender: TObject);
begin
	TExchangeDialog.Prepare( RealizedKey).Append( Transaction, Exchange);
end;

procedure TServiceSet.btnDeleteExchange_Click(Sender: TObject);
begin
	TExchangeDialog.Prepare( RealizedKey).Delete( Transaction, Exchange);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServiceSet.btnPrint_Click(Sender: TObject);
begin
	TServiceReport.Prepare( PrimaryKey).Preview;
end;

end.
