unit Set_Ticket;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, IBSQL, IBDatabase, StdCtrls, ExtCtrls, ComCtrls, Grids, DBGrids,
  DB, DBClient, Provider, IBCustomDataSet, IBQuery, StrUtils, DateUtils,
  DBCtrls, Base_Set, IBEvents, Math, ValEdit, IBUpdateSQL,
  Misc_Constants, Misc_Utilities;

type
  TTicketSet = class(TSetTemplate)
    Center: TIBQuery;
    Unregistered_Ticket: TIBQuery;
    UpdaterOf_Ticket: TIBUpdateSQL;
    Registered_Ticket: TIBQuery;

    lblCode: TLabel;
    lblPublish: TLabel;
    dtpPublish: TDateTimePicker;

    bvlUpperBorder: TBevel;

    txtCode: TLabeledEdit;
    btnBrowseProfile: TButton;
    txtFamilyNameRead: TLabeledEdit;
    txtFamilyName: TLabeledEdit;
    txtFirstNameRead: TLabeledEdit;
    txtFirstName: TLabeledEdit;
    lblBirthday: TLabel;
    pnlSex: TPanel;
    pnlBirthday: TPanel;
    txtInformation: TEdit;

    btnPrint: TButton;
    lblPricePerPoint: TLabel;
    lblMargin: TLabel;
    txtPricePerPoint: TLabeledEdit;
    txtMargin: TLabeledEdit;
    bvlProfile: TBevel;
    lblPoint: TLabel;
    txtPoint: TLabeledEdit;
    btnChooseProfile: TButton;
    pnlPurchase: TPanel;

    procedure dtpPublish_Change(Sender: TObject);

    procedure Ticket_AfterOpen(DataSet: TDataSet);

    procedure btnBrowseProfile_Click(Sender: TObject);
    procedure btnChooseProfile_Click(Sender: TObject);

    procedure txtAmount_Change(Sender: TObject);
    procedure txtMargin_Change(Sender: TObject);

    procedure btnPrint_Click(Sender: TObject);

  private
    { Private 錾 }
    FPublished : TDate;
  protected
    { Protected 錾 }
    procedure DefineTable( var nameOfTable : String; var modifyFlag, cancelFlag : Boolean); override;

    procedure BeforeInput(); override;
    procedure AfterInput(); override;

    procedure BeforeSelect(); override;
    procedure AfterSelect(); override;

    procedure BeforeAppend(); override;
    procedure AfterAppend(); override;

    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
    constructor Prepare; overload; override;
    constructor Prepare( datPublished : TDate); overload;
  end;

var
  TicketSet: TTicketSet;

implementation

{$R *.dfm}

uses Set_Client, Chooser_Client, Report_Ticket;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

constructor TTicketSet.Prepare;
begin
	inherited Prepare;

	FPublished := Today;
end;

constructor TTicketSet.Prepare( datPublished : TDate);
begin
	inherited Prepare;

	FPublished := datPublished;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketSet.DefineTable( var nameOfTable : String; var modifyFlag, cancelFlag : Boolean);
begin
	nameOfTable := 'Ticket';
	modifyFlag := false;
	cancelFlag := true;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketSet.BeforeInput();
begin
end;

procedure TTicketSet.AfterInput();
begin
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketSet.BeforeSelect();
begin
	Registered_Ticket.ParamByName( 'keyInstance').AsInteger := PrimaryKey;
	Registered_Ticket.Open;
	// query setup

	with Registered_Ticket do
	begin
		lblCode.Caption := 'sԍF' + IntToStr( PrimaryKey);
		FPublished := FieldByName( 'datPublished').AsDateTime;

		txtPricePerPoint.Text := FieldByName( 'intPricePerPoint').AsString;
		txtPoint.Text := FieldByName( 'curPoint').AsString;
		txtMargin.Text := FieldByName( 'intMargin').AsString;
		txtAmount_Change( txtMargin);
	end;
	// other components setup
end;

procedure TTicketSet.AfterSelect();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketSet.BeforeAppend();
begin
	Unregistered_Ticket.ParamByName( 'datPublished').AsDateTime := FPublished;

	Center.Open;
	txtPricePerPoint.Text := Center.FieldByName( 'intPricePerPoint').AsString;
end;

procedure TTicketSet.AfterAppend();
begin
	with Unregistered_Ticket do
	begin
		Edit;
		FieldByName( 'keyInstance').AsInteger := RealizedKey;
		FieldByName( 'datPublished').AsDateTime := dtpPublish.Date;
		FieldByName( 'intPricePerPoint').AsInteger := StrToInt( txtPricePerPoint.Text);
		FieldByName( 'curPoint').AsCurrency := CurrToPoint( StrToCurr( txtPoint.Text));
		FieldByName( 'intMargin').AsInteger := StrToInt( txtMargin.Text);
		Post;
		UpdaterOf_Ticket.Apply( ukInsert);
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketSet.BeforePopup();
begin
	if Appending then btnChooseProfile.SetFocus;

	dtpPublish.Date := FPublished;
	dtpPublish.Enabled := Appending;
	dtpPublish_Change( dtpPublish);

	btnChooseProfile.Enabled := Appending;

	txtPricePerPoint.ReadOnly := not Appending;
	txtPoint.ReadOnly := not Appending;
	txtMargin.ReadOnly := not Appending;

	btnPrint.Visible := not Appending;
end;

procedure TTicketSet.AfterPopup();
begin
	if Unregistered_Ticket.IsEmpty then
		ErrorMessages.Add( '`PbgsΏۂ̓o^҂IĂ܂B');

	with Unregistered_Ticket do if ( not IsEmpty) and FieldByName( 'strAddress').IsNull then
		ErrorMessages.Add( '̓o^҂ɂ͓YԂɂ鎩Z̓o^܂B');

	if StrToIntDef( txtPricePerPoint.Text, 0) <= 0 then
		ErrorMessages.Add( '_P͔p݂̂pĂO傫lŎw肵ĂB');

	if CurrToPoint( StrToCurrDef( txtPoint.Text, 0)) <= 0 then
		ErrorMessages.Add( '_͔p݂̂pĂO傫lŎw肵ĂB');

	if StrToIntDef( txtMargin.Text, -1) < 0 then
		ErrorMessages.Add( '萔͔p݂̂pĎw肵ĂB');
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketSet.dtpPublish_Change(Sender: TObject);
begin
	FPublished := dtpPublish.Date;
	dtpPublish.Format := FormatDateTime( ' gg ee "N yyyy N MM  dd "', FPublished);

	if Appending then
	begin
		Unregistered_Ticket.Close;
		Unregistered_Ticket.ParamByName( 'datPublished').AsDateTime := FPublished;
		Unregistered_Ticket.Open;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketSet.Ticket_AfterOpen(DataSet: TDataSet);
begin
	with DataSet do if IsEmpty then
	begin
		txtCode.Text := '';
		txtFamilyNameRead.Text := '悤';
		txtFamilyName.Text := 'p';
		txtFirstNameRead.Text := '߂';
		txtFirstName.Text := '';
		pnlBirthday.Caption := 'N N';
		pnlSex.Caption := '';
		txtInformation.Text := 'dbԍP / FAXԍP / Z';
	end
	else
	begin
		txtCode.Text := Trim( FieldByName( 'strCode').AsString);
		txtFamilyNameRead.Text := Trim( FieldByName( 'strFamilyNameRead').AsString);
		txtFamilyName.Text := Trim( FieldByName( 'strFamilyName').AsString);
		txtFirstNameRead.Text := Trim( FieldByName( 'strFirstNameRead').AsString);
		txtFirstName.Text := Trim( FieldByName( 'strFirstName').AsString);
		pnlBirthday.Caption := Format( '%s %s', [
			FormatDateTime( 'yyyy" N "MM"  "dd" "', FieldByName( 'datBirthday').AsDateTime),
			ToAgeText( FPublished, FieldByName( 'datBirthday').AsDateTime)
		]);
		pnlSex.Caption := aSex[ FieldByName( 'typSex').AsInteger];

		txtInformation.Text := Format( '%s / %s / %s', [
			Trim( FieldByName( 'strPhoneNumber1').AsString),
			Trim( FieldByName( 'strFaxNumber1').AsString),
			Trim( FieldByName( 'strAddress').AsString)
		]);
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketSet.btnBrowseProfile_Click( Sender: TObject);
begin
	TClientSet.Prepare.Browse( Unregistered_Ticket.FieldByName( 'refProfile').AsInteger);
end;

procedure TTicketSet.btnChooseProfile_Click( Sender: TObject);
var
	keyProfile : Integer;
begin
	if ChooseClient( Transaction, FPublished, keyProfile) then
	begin
		Unregistered_Ticket.Close;
		Unregistered_Ticket.ParamByName( 'keyProfile').AsInteger := keyProfile;
		Unregistered_Ticket.Open;
		txtPoint.SetFocus;
	end;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketSet.txtAmount_Change(Sender: TObject);
begin
	if Appending then case Center.FieldByName( 'typTicketMarginPerEvent').AsInteger of
	MARGIN_BY_PERMILLAGE : txtMargin.Text := IntToStr( Center.FieldByName( 'intTicketMarginPerCheck').AsInteger + Trunc( CurrToPoint( StrToCurrDef( txtPoint.Text, 0)) * StrToIntDef( txtPricePerPoint.Text, 0)) * Center.FieldByName( 'intTicketMarginPerEvent').AsInteger div 1000);
	MARGIN_BY_PERCOUNT : txtMargin.Text := IntToStr( Center.FieldByName( 'intTicketMarginPerCheck').AsInteger + Trunc( CurrToPoint( StrToCurrDef( txtPoint.Text, 0)) * Center.FieldByName( 'intTicketMarginPerEvent').AsInteger));
	end;

	txtMargin_Change( Sender);
end;

procedure TTicketSet.txtMargin_Change(Sender: TObject);
begin
	pnlPurchase.Caption := Format( '%0.0n ~', [ Int(
		Int( CurrToPoint( StrToCurrDef( txtPoint.Text, 0)) * StrToIntDef( txtPricePerPoint.Text, 0))
			+ StrToIntDef( txtMargin.Text, 0)
	)]);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketSet.btnPrint_Click(Sender: TObject);
begin
	TTicketReport.Prepare( PrimaryKey).Preview;
end;

end.
