unit Toolbox_ExtendSchedules;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, StrUtils, ExtCtrls, Provider, DB, DBClient, DBLocal,
  MainDatastore, DBLocalI, IB, IBErrorCodes, IBSQL, IBDatabase, IBCustomDataSet,
  IBQuery, DBCtrls, ComCtrls, DateUtils, Base_Toolbox, Grids, DBGrids, Math,
  Misc_Constants, Misc_Utilities;

procedure ExtendSchedules( Reserves : TDataSet);

type
  TExtendSchedulesToolbox = class(TToolboxTemplate)
    pbrProgress: TProgressBar;
    btnAbort: TButton;

    procedure btnAbort_Click(Sender: TObject);

  private
    { Private 錾 }
    FReserves : TDataSet;
    FProcessing : Boolean;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  end;

var
  ExtendSchedulesToolbox: TExtendSchedulesToolbox;

implementation

{$R *.dfm}

uses Toolbox_SpreadSchedules;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure ExtendSchedules( Reserves : TDataSet);
begin
	with TExtendSchedulesToolbox.Create( Screen.ActiveForm) do
	begin
		FReserves := Reserves;
		Popup;
		Release;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TExtendSchedulesToolbox.BeforePopup();
begin
end;

procedure TExtendSchedulesToolbox.AfterPopup();
begin
	FProcessing := true;
	btnOK.Enabled := false;
	btnCancel.Enabled := false;
	btnAbort.Enabled := true;

	FReserves.First;
	pbrProgress.Max := FReserves.RecordCount;
	with FReserves do while FProcessing and ( not EOF) do
	begin
		pbrProgress.Position := RecNo;
		if not ( FieldByName( 'typPattern').AsInteger in [ PATTERN_COMPLEX, PATTERN_MULTIPLE]) then
			SpreadSchedulesSilently( FieldByName( 'keyInstance').AsInteger);
		Next;

		Application.ProcessMessages;
	end;

	if not FProcessing then
		Application.MessageBox( '𒆎~܂', '', MB_OK)
	else
		Application.MessageBox( '܂', '', MB_OK);

	Close;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TExtendSchedulesToolbox.btnAbort_Click(Sender: TObject);
begin
	FProcessing := false;
end;

end.
