unit Toolbox_GenerateBillings;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, StrUtils, ExtCtrls, Provider, DB, DBClient, DBLocal,
  MainDatastore, DBLocalI, IB, IBErrorCodes, IBSQL, IBDatabase, IBCustomDataSet,
  IBQuery, DBCtrls, ComCtrls, DateUtils, Base_Toolbox, Grids, DBGrids, Math,
  Misc_Constants, Misc_Utilities;

procedure GenerateBillings( datFirstday, datLastday : TDate);

type
  TGenerateBillingsToolbox = class(TToolboxTemplate)
    Payer: TIBQuery;

    lblPublished: TLabel;
    dtpPublished: TDateTimePicker;
    pbrProgress: TProgressBar;
    btnAbort: TButton;
    lblSpan: TLabel;
    dtpSpanFrom: TDateTimePicker;
    dtpSpanTo: TDateTimePicker;
    lblOver: TLabel;

    procedure dtpCalendar_Change(Sender: TObject);
    procedure btnAbort_Click(Sender: TObject);

  private
    { Private 錾 }
    FGenerating : Boolean;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  end;

var
  GenerateBillingsToolbox: TGenerateBillingsToolbox;

implementation

{$R *.dfm}

uses Set_Billing;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure GenerateBillings( datFirstday, datLastday : TDate);
begin
	with TGenerateBillingsToolbox.Create( Screen.ActiveForm) do
	begin
		dtpSpanFrom.Date := DateOf( datFirstday);
		dtpSpanTo.Date := DateOf( datLastday);
		dtpPublished.Date := IncDay( DateOf( datLastday));
		Popup;
		Release;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TGenerateBillingsToolbox.BeforePopup();
begin
	dtpCalendar_Change( dtpSpanFrom);
	dtpCalendar_Change( dtpSpanTo);
	dtpCalendar_Change( dtpPublished);
end;

procedure TGenerateBillingsToolbox.AfterPopup();
begin
	if dtpSpanFrom.Date >= dtpSpanTo.Date then
		ErrorMessages.Add( 'WvԂ̓ttɂȂĂ܂B');

	if dtpPublished.Date < dtpSpanTo.Date then
		ErrorMessages.Add( 'sWvԓɂȂĂ܂B');

	if ErrorMessages.Count > 0 then exit;

	FGenerating := true;
	dtpPublished.Enabled := false;
	dtpSpanFrom.Enabled := false;
	dtpSpanTo.Enabled := false;
	btnOK.Enabled := false;
	btnCancel.Enabled := false;
	btnAbort.Enabled := true;

	Payer.ParamByName( 'datFrom').AsDate := dtpSpanFrom.Date;
	Payer.ParamByName( 'datTo').AsDate := dtpSpanTo.Date;
	Payer.Open;
	Payer.Last;
	Payer.First;
	pbrProgress.Max := Payer.RecordCount;
	with Payer do while FGenerating and ( not EOF) do
	begin
		TBillingSet.Prepare(
			dtpSpanFrom.Date,
			dtpSpanTo.Date,
			dtpPublished.Date,
			ReadInstanceKey( Payer)
		).Append( true);

		pbrProgress.Position := RecNo;
		Next;

                Application.ProcessMessages;
	end;

	if not FGenerating then
		Application.MessageBox( '𒆎~܂', '', MB_OK)
	else
		Application.MessageBox( '܂', '', MB_OK);

	Close;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TGenerateBillingsToolbox.dtpCalendar_Change(Sender: TObject);
begin
	( Sender as TDateTimePicker).Format := FormatDateTime( ' gg ee "N"', ( Sender as TDateTimePicker).Date) + ' yyyy N MM  dd ';
end;

procedure TGenerateBillingsToolbox.btnAbort_Click(Sender: TObject);
begin
	FGenerating := false;
end;

end.
