unit Toolbox_RemoveSchedules;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, StrUtils, ExtCtrls, Provider, DB, DBClient, DBLocal,
  MainDatastore, DBLocalI, IB, IBErrorCodes, IBSQL, IBDatabase, IBCustomDataSet,
  IBQuery, DBCtrls, ComCtrls, DateUtils, Base_Toolbox, Grids, DBGrids, Math,
  Misc_Constants, Misc_Utilities, Buttons;

procedure RemoveSchedules( datAt : TDate; keyClient : Integer);

type
  TRemoveSchedulesToolbox = class(TToolboxTemplate)
    SourceOf_Schedule: TIBQuery;
    ProviderOf_Schedule: TDataSetProvider;
    Schedule: TClientDataSet;
    DataSourceOf_Schedule: TDataSource;

    lblPrograms: TLabel;
    btnDay_1: TSpeedButton;
    btnDay_2: TSpeedButton;
    btnDay_3: TSpeedButton;
    btnDay_4: TSpeedButton;
    btnDay_5: TSpeedButton;
    btnDay_6: TSpeedButton;
    btnDay_7: TSpeedButton;
    btnDay_8: TSpeedButton;
    btnDay_9: TSpeedButton;
    btnDay_10: TSpeedButton;
    btnDay_11: TSpeedButton;
    btnDay_12: TSpeedButton;
    btnDay_13: TSpeedButton;
    btnDay_14: TSpeedButton;
    btnDay_15: TSpeedButton;
    btnDay_16: TSpeedButton;
    btnDay_17: TSpeedButton;
    btnDay_18: TSpeedButton;
    btnDay_19: TSpeedButton;
    btnDay_20: TSpeedButton;
    btnDay_21: TSpeedButton;
    btnDay_22: TSpeedButton;
    btnDay_23: TSpeedButton;
    btnDay_24: TSpeedButton;
    btnDay_25: TSpeedButton;
    btnDay_26: TSpeedButton;
    btnDay_27: TSpeedButton;
    btnDay_28: TSpeedButton;
    btnDay_29: TSpeedButton;
    btnDay_30: TSpeedButton;
    btnDay_31: TSpeedButton;

    gridSchedule: TDBGrid;

    chkTransfer: TCheckBox;
    chkCare: TCheckBox;
    chkMenage: TCheckBox;
    chkMigration: TCheckBox;

    btnBrowseSchedule: TButton;
    btnExcludeSchedule: TButton;
    pbrProgress: TProgressBar;

    procedure Selector_Change( Sender : TObject);

    procedure gridSchedule_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);

    procedure btnBrowseSchedule_Click( Sender : TObject);
    procedure btnExcludeSchedule_Click( Sender : TObject);

  private
    { Private 錾 }
    FMonthFirstday : TDate;
    FMonthLastday : TDate;
    FClientKey : Integer;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  end;

var
  RemoveSchedulesToolbox: TRemoveSchedulesToolbox;

implementation

{$R *.dfm}

uses Set_Transfer, Set_Care, Set_Menage, Set_Migration;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure RemoveSchedules( datAt : TDate; keyClient : Integer);
begin
	if keyClient <= 0 then exit;
	with TRemoveSchedulesToolbox.Create( Screen.ActiveForm) do
	begin
		FMonthFirstday := StartOfTheMonth( datAt);
		FMonthLastday := EndOfTheMonth( datAt);
		FClientKey := keyClient;
		Popup;
		Release;
	end;
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TRemoveSchedulesToolbox.BeforePopup();
var
	index : Integer;
	dateStamp : TDateTime;
	dayButton : TSpeedButton;
begin
	if not DataStore.VerifyRecord( 'Profile', FClientKey) then
		ErrorMessages.Add( 'Y闘p҂̏͑̒[ŗpłB');

	if ErrorMessages.Count > 0 then exit;
	// error check

	Selector_Change( self);
	// controles update

	for index := 0 to 30 do
	begin
		dateStamp := IncDay( FMonthFirstday, index);
		dayButton := FindComponent( 'btnDay_' + IntToStr( index + 1)) as TSpeedButton;

		if dateStamp <= FMonthLastday then
		begin
			dayButton.Caption := IntToStr( DayOf( dateStamp));
			case DayOfWeek( dateStamp) of
			1 : dayButton.Font.Color := $0000CC;
			2..6 : dayButton.Font.Color := clWindowText;
			7 : dayButton.Font.Color := $CC0000;
			end;
			dayButton.Enabled := true;
		end
		else
		begin
			dayButton.Caption := '*';
			dayButton.Enabled := false;
		end;
	end;
	// setup calender
end;

procedure TRemoveSchedulesToolbox.AfterPopup();
var
	removed : Boolean;
        failed : Boolean;
label
	do_retry;
begin
do_retry:
	failed := false;
	Schedule.First;
	pbrProgress.Max := Schedule.RecordCount;
	with Schedule do while not EOF do
	begin
		if IntToBool( FieldByName( 'blnAvailable').AsInteger)
		and ( not IntToBool( FieldByName( 'blnRemoved').AsInteger))
		then
		begin
			removed := DataStore.CancelRecord( 'Schedule', FieldByName( 'keyInstance').AsInteger);

			if removed then
			begin
				Edit;
				FieldByName( 'blnRemoved').AsInteger := BoolToInt( true);
				Post;
			end;
			failed := failed or ( not removed);
		end;

		pbrProgress.Position := RecNo;
		Next;
	end;

	if failed then
	begin
		if Application.MessageBox(
			'̒[ŗpĂꕔ̏̍폜Ɏs܂B' + #13#10 +
			'x폜݂ꍇɂ́uĎsv{^' + #13#10 +
			'̂܂܏Iꍇɂ́uLZv{^NbNĂ',
			'ꊇ폜',
			MB_RETRYCANCEL
		) = IDRETRY then
			goto do_retry;
	end;

	Application.MessageBox( '폜ɐ܂', 'ꊇ폜', MB_OK);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TRemoveSchedulesToolbox.Selector_Change( Sender : TObject);
begin
	Schedule.Close;
	SourceOf_Schedule.ParamByName( 'keyClient').AsInteger := FClientKey;
	SourceOf_Schedule.ParamByName( 'datFrom').AsDate := FMonthFirstday;
	SourceOf_Schedule.ParamByName( 'datTo').AsDate := FMonthLastday;
	SourceOf_Schedule.ParamByName( 'optDays').AsInteger := SpeedButtonsToOptions( [
		btnDay_1, btnDay_2, btnDay_3, btnDay_4, btnDay_5, btnDay_6, btnDay_7, btnDay_8, btnDay_9, btnDay_10,
		btnDay_11, btnDay_12, btnDay_13, btnDay_14, btnDay_15, btnDay_16, btnDay_17, btnDay_18, btnDay_19, btnDay_20,
		btnDay_21, btnDay_22, btnDay_23, btnDay_24, btnDay_25, btnDay_26, btnDay_27, btnDay_28, btnDay_29, btnDay_30,
		btnDay_31
	]);
	SourceOf_Schedule.ParamByName( 'optService').AsInteger := CheckBoxesToOptions( [
		chkCare, chkMenage, chkMigration, chkTransfer
	]);
	Schedule.Open;
	// update query

	btnBrowseSchedule.Enabled := not Schedule.IsEmpty;
	btnExcludeSchedule.Enabled := not Schedule.IsEmpty;
	// update control
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TRemoveSchedulesToolbox.gridSchedule_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
	selected : Boolean;
	dummy : Integer;
	strExchange : String;
begin
	gridSchedule.Canvas.Font.Size := gridSchedule.Font.Size div 2; 
	selected := gridSchedule.SelectedRows.Find( Schedule.Bookmark, dummy);
	if IntToBool( Schedule.FieldByName( 'blnAvailable').AsInteger) then
	begin
		gridSchedule.Canvas.Font.Color := IfThen( selected, clHighlightText, Column.Font.Color);
		gridSchedule.Canvas.Brush.Color := IfThen( selected, clHighlight, Column.Color);
	end
	else
	begin
		gridSchedule.Canvas.Font.Color := IfThen( selected, clHighlightText, clWindowText);
		gridSchedule.Canvas.Brush.Color := IfThen( selected, clSelectedExcluded, clDefaultExcluded);
	end;

	if Column.Field.IsNull then
        begin
		gridSchedule.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, ' ');
        	exit;
        end;

	if Column.Field.FieldName = 'INTMINUTESAT' then with Schedule do
	begin
		case FieldByName( 'typSchedule').AsInteger of
		CARE_SCHEDULE, MENAGE_SCHEDULE :
			gridSchedule.Canvas.TextRect( Rect,
				Rect.Left + 2,
				Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
				RangeToText( Column.Field.AsInteger, FieldByName( 'intMinutesFor').AsInteger)
			);
		else
			gridSchedule.Canvas.TextRect( Rect,
				Rect.Left + 2,
				Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
				MinutesToText( Column.Field.AsInteger)
			);
		end;
		exit;
	end;

	if Column.Field.FieldName = 'STRSERVICE' then with Schedule do
	begin
		strExchange := AmountToText(
			FieldByName( 'typExchange').AsInteger,
			FieldByName( 'curAmountPerCount').AsCurrency,
			FieldByName( 'curAmountPerHour').AsCurrency,
			FieldByName( 'intMinutesFor').AsInteger
		);
		gridSchedule.Canvas.TextRect( Rect,
			Rect.Left + 2,
			Rect.Top + 2,
			Column.Field.AsString
		);
		gridSchedule.Canvas.TextOut(
			Rect.Right - 2 - gridSchedule.Canvas.TextWidth( strExchange),
			Rect.Top + ( Rect.Bottom - Rect.Top) div 2 + 2,
			strExchange
		);
		exit;
	end;

	if Column.Field.FieldName = 'STRADDRESSFROM' then
	begin
		case Schedule.FieldByName( 'typSchedule').AsInteger of
		CARE_SCHEDULE, MENAGE_SCHEDULE :
			gridSchedule.Canvas.TextRect( Rect,
				Rect.Left + 2,
				Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
				Column.Field.AsString
			);
		else
			begin
				gridSchedule.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Column.Field.AsString);
				gridSchedule.Canvas.TextOut(
					Rect.Left + 2,
					Rect.Top + ( Rect.Bottom - Rect.Top) div 2 + 1,
					'  ' + Schedule.FieldByName( 'strAddressTo').AsString
				);
			end;
		end;
		exit;
	end;

	if ( Column.PickList.Count > 0) and ( not Column.Field.IsNull) then
	begin
		gridSchedule.Canvas.TextRect( Rect,
			Rect.Left + 2,
			Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
			Column.PickList[ Column.Field.AsInteger]
		);
		exit;
	end;

	gridSchedule.Canvas.TextRect( Rect,
		Rect.Left + 2,
		Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
		Column.Field.AsString
	);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TRemoveSchedulesToolbox.btnBrowseSchedule_Click( Sender : TObject);
begin
	with Schedule do case FieldByName( 'typSchedule').AsInteger of
	     CARE_SCHEDULE : TCareSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
	   MENAGE_SCHEDULE : TMenageSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
	MIGRATION_SCHEDULE : TMigrationSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
	 TRANSFER_SCHEDULE : TTransferSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
	end;
end;

procedure TRemoveSchedulesToolbox.btnExcludeSchedule_Click( Sender : TObject);
var
	index : Integer;
begin
	if Schedule.IsEmpty then exit;

	for index := 0 to gridSchedule.SelectedRows.Count - 1 do
        begin
		with Schedule do
		begin
			Bookmark := gridSchedule.SelectedRows.Items[ index];
			Edit;
			FieldByName( 'blnAvailable').AsInteger := BoolToInt( not IntToBool( FieldByName( 'blnAvailable').AsInteger));
			Post;
		end;
        end;
end;

end.
