unit Toolbox_SpreadSchedules;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Base_Toolbox, StdCtrls, ExtCtrls, DB, IBCustomDataSet, IBQuery,
  DateUtils, DBClient, Provider, Grids, DBGrids, Math,
  Misc_Constants, Misc_Utilities, IBSQL;

procedure SpreadSchedules( keyPatternTail : Integer);
procedure SpreadSchedulesSilently( keyPatternTail : Integer);

type
  TSpreadSchedulesToolbox = class(TToolboxTemplate)
    Root: TIBQuery;
    SourceOf_Schedule: TIBQuery;
    ProviderOf_Schedule: TDataSetProvider;
    Schedule: TClientDataSet;
    DataSourceOf_Schedule: TDataSource;

    cboExtension: TComboBox;
    bvlCarry: TBevel;
    gridSchedule: TDBGrid;
    SubjectPromoter: TIBSQL;
    btnBrowseSchedule: TButton;
    btnExcludeSchedule: TButton;

    procedure gridSchedule_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);

    procedure btnBrowseSchedule_Click( Sender : TObject);
    procedure btnExcludeSchedule_Click(Sender : TObject);
  private
    { Private 錾 }
    FPatternTail : Integer;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
  public
    { Public 錾 }
  end;

var
  SpreadSchedulesToolbox: TSpreadSchedulesToolbox;

implementation

{$R *.dfm}

uses Misc_Scheduler, MainDatastore, Set_Care, Set_Menage, Set_Migration, Set_Transfer;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure SpreadSchedules( keyPatternTail : Integer);
begin
	if keyPatternTail <= 0 then exit;
	with TSpreadSchedulesToolbox.Create( Screen.ActiveForm) do
	begin
		FPatternTail := keyPatternTail;
		Popup;
		Release;
	end;
end;

procedure SpreadSchedulesSilently( keyPatternTail : Integer);
begin
	if keyPatternTail <= 0 then exit;
	with TSpreadSchedulesToolbox.Create( Screen.ActiveForm) do
	begin
		FPatternTail := keyPatternTail;
		BeforePopup;
		Schedule.Filter := 'keyInstance <> codRevision';
		if Schedule.IsEmpty then
		begin
			Schedule.Filter := '';
			AfterPopup;
			if ModalResult <> mrCancel then DataStore.Commit;
		end;
		Release;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TSpreadSchedulesToolbox.BeforePopup();
var
	index : Integer;
begin
	if not DataStore.VerifyRecord( 'Schedule', FPatternTail) then
		ErrorMessages.Add( 'YXPW[̏͑̒[ŗpłB');

	Root.ParamByName( 'keyInstance').AsInteger := FPatternTail;
	Root.Open;

	SourceOf_Schedule.ParamByName( 'keyPattern').AsInteger := Root.FieldByName( 'keyPattern').AsInteger;
	SourceOf_Schedule.ParamByName( 'datAnchor').AsDate := Root.FieldByName( 'datSchedule').AsDateTime;
	Schedule.Open;

	if Schedule.IsEmpty then
		ErrorMessages.Add( 'ł\肪܂B');

	if ErrorMessages.Count > 0 then exit;
	// update query

	cboExtension.Items.Clear;
	cboExtension.Items.Add( '܂ŉ');
	for index := 1 to DaysInMonth( IncMonth( Schedule.FieldByName( 'datSchedule').AsDateTime)) do
		cboExtension.Items.Add( Format( '%d܂łőł؂', [ index]));
	cboExtension.ItemIndex := 0;
end;

procedure TSpreadSchedulesToolbox.AfterPopup();

	procedure AssignScheduleToScheduler();
	begin
		with Scheduler do
		begin
			keyPattern := Schedule.FieldByName( 'keyPattern').AsInteger;
			typPattern := Schedule.FieldByName( 'typPattern').AsInteger;
			optPattern := Schedule.FieldByName( 'optPattern').AsInteger;
			optElement := Schedule.FieldByName( 'optElement').AsInteger;

			typProgress := Schedule.FieldByName( 'typProgress').AsInteger;
			refService := Schedule.FieldByName( 'refService').AsInteger;
			refExchange := Schedule.FieldByName( 'refExchange').AsInteger;

			intMinutesAt := Schedule.FieldByName( 'intMinutesAt').AsInteger;
			intMinutesFor := Schedule.FieldByName( 'intMinutesFor').AsInteger;
			refAddressFrom := Schedule.FieldByName( 'refAddressFrom').AsInteger;
			refAddressTo := Schedule.FieldByName( 'refAddressTo').AsInteger;
			strNotice := Schedule.FieldByName( 'strNotice').AsString;

			refClient := Schedule.FieldByName( 'refClient').AsInteger;
			refServer := Schedule.FieldByName( 'refServer').AsInteger;
		end;
	end;
begin
	Scheduler.Transaction := DataStore.MainTransaction;
	Scheduler.datAnchor := Root.FieldByName( 'datSchedule').AsDateTime;

	Schedule.DisableControls;

	Schedule.Filter := 'blnAvailable<>0 and refSubject IS NULL';
	AssignScheduleToScheduler;

	if cboExtension.ItemIndex = 0 then
		Scheduler.CopyAsSubject
	else
		Scheduler.CopyAsSubject(
			RecodeDay( IncMonth( Schedule.FieldByName( 'datSchedule').AsDateTime), cboExtension.ItemIndex),
			SEQUENCE_BODY
		);

	Schedule.Filter := Format( 'blnAvailable<>0 and refSubject IS NOT NULL and typSchedule=%d', [ Root.FieldByName( 'typSchedule').AsInteger]);
	if not Schedule.IsEmpty then
	begin
		AssignScheduleToScheduler;
		Scheduler.CopyAsLemma( Root.FieldByName( 'keyPattern').AsInteger);
	end;

	Schedule.Filter := Format( 'blnAvailable<>0 and refSubject IS NOT NULL and typSchedule<>%d', [ Root.FieldByName( 'typSchedule').AsInteger]);
	while not Schedule.Eof do
	begin
		AssignScheduleToScheduler;
		Scheduler.CopyAsLemma( Schedule.FieldByName( 'keySubjectPattern').AsInteger);
		Schedule.Next;
	end;

	Schedule.Filter := '';

	SubjectPromoter.ParamByName( 'keyInstance').AsInteger := FPatternTail;
	SubjectPromoter.ExecQuery;

	Schedule.EnableControls;

	if Visible then Application.MessageBox( 'ɐ܂', 'XPW[̉', MB_OK);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TSpreadSchedulesToolbox.gridSchedule_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
	strExchange : String;
begin
	gridSchedule.Canvas.Font.Size := gridSchedule.Font.Size div 2;
	if IntToBool( Schedule.FieldByName( 'blnAvailable').AsInteger) then
	begin
		gridSchedule.Canvas.Font.Color := IfThen( gdSelected in State, clHighlightText, Column.Font.Color);
		gridSchedule.Canvas.Brush.Color := IfThen( gdSelected in State, clHighlight, Column.Color);
	end
	else
	begin
		gridSchedule.Canvas.Font.Color := IfThen( gdSelected in State, clHighlightText, clWindowText);
		gridSchedule.Canvas.Brush.Color := IfThen( gdSelected in State, clSelectedExcluded, clDefaultExcluded);
	end;

	if Column.Field.IsNull then
	begin
		gridSchedule.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, ' ');
		exit;
	end;

	if Column.Field.FieldName = 'INTMINUTESAT' then with Schedule do
	begin
		case FieldByName( 'typSchedule').AsInteger of
		CARE_SCHEDULE, MENAGE_SCHEDULE :
			gridSchedule.Canvas.TextRect( Rect,
				Rect.Left + 2,
				Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
				RangeToText( Column.Field.AsInteger, FieldByName( 'intMinutesFor').AsInteger)
			);
		else
			gridSchedule.Canvas.TextRect( Rect,
				Rect.Left + 2,
				Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
				MinutesToText( Column.Field.AsInteger)
			);
		end;
		exit;
	end;

	if Column.Field.FieldName = 'STRSERVICE' then with Schedule do
	begin
		strExchange := AmountToText(
			FieldByName( 'typExchange').AsInteger,
			FieldByName( 'curAmountPerCount').AsCurrency,
			FieldByName( 'curAmountPerHour').AsCurrency,
			FieldByName( 'intMinutesFor').AsInteger
		);
		gridSchedule.Canvas.TextRect( Rect,
			Rect.Left + 2,
			Rect.Top + 2,
			Column.Field.AsString
		);
		gridSchedule.Canvas.TextOut(
			Rect.Right - 2 - gridSchedule.Canvas.TextWidth( strExchange),
			Rect.Top + ( Rect.Bottom - Rect.Top) div 2 + 2,
			strExchange
		);
		exit;
	end;

	if Column.Field.FieldName = 'STRADDRESSFROM' then
	begin
		case Schedule.FieldByName( 'typSchedule').AsInteger of
		CARE_SCHEDULE, MENAGE_SCHEDULE :
			gridSchedule.Canvas.TextRect( Rect,
				Rect.Left + 2,
				Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
				Column.Field.AsString
			);
		else
			begin
				gridSchedule.Canvas.TextRect( Rect, Rect.Left + 2, Rect.Top + 2, Column.Field.AsString);
				gridSchedule.Canvas.TextOut(
					Rect.Left + 2,
					Rect.Top + ( Rect.Bottom - Rect.Top) div 2 + 1,
					'  ' + Schedule.FieldByName( 'strAddressTo').AsString
				);
			end;
		end;
		exit;
	end;

	if ( Column.PickList.Count > 0) and ( not Column.Field.IsNull) then
	begin
		gridSchedule.Canvas.TextRect( Rect,
			Rect.Left + 2,
			Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
			Column.PickList[ Column.Field.AsInteger]
		);
		exit;
	end;

	gridSchedule.Canvas.TextRect( Rect,
		Rect.Left + 2,
		Rect.Top + ( Rect.Bottom - Rect.Top) div 4,
		Column.Field.AsString
	);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TSpreadSchedulesToolbox.btnBrowseSchedule_Click( Sender : TObject);
begin
	with Schedule do case FieldByName( 'typSchedule').AsInteger of
	     CARE_SCHEDULE : TCareSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
	   MENAGE_SCHEDULE : TMenageSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
	MIGRATION_SCHEDULE : TMigrationSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
	 TRANSFER_SCHEDULE : TTransferSet.Prepare.Browse( FieldByName( 'keyInstance').AsInteger);
	end;
end;

procedure TSpreadSchedulesToolbox.btnExcludeSchedule_Click( Sender : TObject);
var
	index : Integer;

	procedure DisableLemma( Target : TDataSet; keySubject : Integer);
	var
		defaultBookmark : String;
	begin
		defaultBookmark := Target.Bookmark;
		Target.First;
		with Target do while not EOF do
		begin
			if FieldByName( 'refSubject').AsInteger = keySubject then
			begin
				DisableLemma( Target, FieldByName( 'keyInstance').AsInteger);
				Edit;
				FieldByName( 'blnAvailable').AsInteger := BoolToInt( false);
				Post;
			end;
			Next;
		end;
		Target.Bookmark := defaultBookmark;
	end;

	procedure EnableSubject( Target : TDataSet; keySubject : Integer);
	var
		defaultBookmark : String;
	begin
		if keySubject <= 0 then exit;
		defaultBookmark := Target.Bookmark;
		Target.First;
		with Target do while not EOF do
		begin
			if FieldByName( 'keyInstance').AsInteger = keySubject then
			begin
				EnableSubject( Target, FieldByName( 'refSubject').AsInteger);
				Edit;
				FieldByName( 'blnAvailable').AsInteger := BoolToInt( true);
				Post;
			end;
			Next;
		end;
		Target.Bookmark := defaultBookmark;
	end;
begin
	Schedule.DisableControls;
	for index := 0 to gridSchedule.SelectedRows.Count - 1 do
        begin
		with Schedule do
		begin
			Bookmark := gridSchedule.SelectedRows.Items[ index];

			if IntToBool( FieldByName( 'blnAvailable').AsInteger) then
				DisableLemma( Schedule, FieldByName( 'keyInstance').AsInteger)
			else
				EnableSubject( Schedule, FieldByName( 'refSubject').AsInteger);

			Edit;
			FieldByName( 'blnAvailable').AsInteger := BoolToInt( not IntToBool( FieldByName( 'blnAvailable').AsInteger));
			Post;
		end;
	end;
	Schedule.EnableControls;
end;

end.
