unit Workspace_Branches;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, DB, IBCustomDataSet, IBQuery, IBEvents, StdCtrls, Grids,
  DBGrids, ExtCtrls, IB, IBErrorCodes, IBDatabase, DBCtrls,
  Provider, DBClient, Math, ActnList, DateUtils, MainDatastore, ComCtrls,
  Misc_Constants, Misc_Utilities, Base_Workspace;

type
  TBranchesWorkspace = class(TWorkspaceTemplate)

    SourceOf_Branch: TIBQuery;
    ProviderOf_Branch: TDataSetProvider;
    Branch: TClientDataSet;
    DataSourceOf_Branch: TDataSource;

    gridView: TDBGrid;
    radShowAvailable: TRadioButton;
    radShowDisabled: TRadioButton;
    radShowUnavailable: TRadioButton;
    lblCounter: TLabel;
    bvlBorder: TBevel;

    btnSelect: TButton;
    btnAppend: TButton;
    btnDelete: TButton;
    btnRestore: TButton;

    procedure Selector_Change(Sender: TObject);

    procedure gridView_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);

    procedure btnSelect_Click(Sender: TObject);
    procedure btnAppend_Click(Sender: TObject);
    procedure btnDelete_Click(Sender: TObject);
    procedure btnRestore_Click(Sender: TObject);

    procedure Report_MenuSetup( MenuRegistrar : TMenuRegistrar); override;
    procedure Report_Branches(Sender: TObject);

  private
    { Private 錾 }
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
    procedure AfterNotify(); override;
  public
    { Public 錾 }
  end;

var
  BranchesWorkspace: TBranchesWorkspace;

implementation

{$R *.dfm}

uses Set_Branch, Report_Branches;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBranchesWorkspace.BeforePopup();
begin
	Branch.Open;

	SortByDefault( gridView);
	Selector_Change( self);
end;

procedure TBranchesWorkspace.AfterPopup();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBranchesWorkspace.Selector_Change(Sender: TObject);
begin
	Branch.Filter := CatalogueFilter( radShowAvailable, radShowUnavailable, radShowDisabled);

	lblCounter.Caption := 'vF' + IntToStr( Branch.RecordCount) + ' ';

	btnSelect.Enabled := ( not Branch.IsEmpty);
	btnDelete.Enabled := ( not Branch.IsEmpty) and ( not radShowDisabled.Checked);
	btnRestore.Enabled := ( not Branch.IsEmpty) and radShowDisabled.Checked;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBranchesWorkspace.gridView_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
begin
	with Column do if ( PickList.Count > 0) and ( not Field.IsNull) then
	begin
		gridView.Canvas.TextRect(
			Rect, Rect.Left + 2, Rect.Top + 2, PickList[ Field.AsInteger]
		);
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBranchesWorkspace.btnSelect_Click(Sender: TObject);
begin
	if not radShowDisabled.Checked then
		TBranchSet.Prepare.Select( ReadInstanceKey( Branch))
	else
		TBranchSet.Prepare.Browse( ReadInstanceKey( Branch));
end;

procedure TBranchesWorkspace.btnAppend_Click(Sender: TObject);
begin
	TBranchSet.Prepare.Append;
end;

procedure TBranchesWorkspace.btnDelete_Click(Sender: TObject);
begin
	TBranchSet.Prepare.Delete( ReadInstanceKey( Branch));
end;

procedure TBranchesWorkspace.btnRestore_Click(Sender: TObject);
begin
	TBranchSet.Prepare.Restore( ReadInstanceKey( Branch));
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBranchesWorkspace.Report_MenuSetup( MenuRegistrar : TMenuRegistrar);
begin
	MenuRegistrar( 'o^敪ꗗ̈(&P)', Report_Branches, ( not Branch.IsEmpty));
end;

procedure TBranchesWorkspace.Report_Branches(Sender: TObject);
begin
	TBranchesReport.Prepare( CatalogueType( radShowAvailable, radShowUnavailable, radShowDisabled)).Preview;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TBranchesWorkspace.AfterNotify();
var
	Position : TDataSetPosition;
begin
	DisableGridSet( gridView, Position);
	Branch.Refresh;
	Selector_Change( self);
	EnableGridSet( gridView, Position);
end;

end.
