unit Workspace_Clients;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Workspace_Profiles, ActnList, Provider, DBClient, DB, IBDatabase,
  IBCustomDataSet, IBQuery, ExtCtrls, IBEvents, StdCtrls, DBCtrls, Grids,
  DBGrids, Misc_Constants, Set_Profile, Publisher_NameLabels;

type
  TClientsWorkspace = class(TProfilesWorkspace)
  private
    { Private 錾 }
  protected
    { Protected 錾 }
    class function CategoryType() : Integer; override;
    class function CategoryClass() : CProfileSet; override;
    class function NameLabelsPublisher() : CNameLabelsPublisher; override;
    class function ChooseProfile( _tran : TIBTransaction; var keyInstance : Integer) : Boolean; override;
  public
    { Public 錾 }
  end;

var
  ClientsWorkspace: TClientsWorkspace;

implementation

{$R *.dfm}

uses Set_Client, Publisher_ClientLabels, Chooser_Client;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

class function TClientsWorkspace.CategoryType() : Integer;
begin
	result := CLIENT_PROFILE;
end;

class function TClientsWorkspace.CategoryClass() : CProfileSet;
begin
	result := TClientSet;
end;

class function TClientsWorkspace.NameLabelsPublisher() : CNameLabelsPublisher;
begin
	result := TClientLabelsPublisher;
end;

class function TClientsWorkspace.ChooseProfile( _tran : TIBTransaction; var keyInstance : Integer) : Boolean;
begin
	result := ChooseClient( _tran, keyInstance);
end;

end.
