unit Workspace_Payback;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, DB, IBCustomDataSet, IBQuery, IBEvents, StdCtrls, Grids,
  DBGrids, ExtCtrls, IB, IBErrorCodes, IBDatabase, DateUtils, Buttons,
  DBClient, Provider, Math, ComCtrls, ActnList, DBCtrls,
  MainDatastore, Misc_Constants, Misc_Utilities, Base_Workspace,
  Frame_ServerPrivateTable, Frame_ServerPrivateGraph, Base_Frame;

type
  TPaybackWorkspace = class(TWorkspaceTemplate)
    Center: TIBQuery;

    SourceOf_Payee: TIBQuery;
    ProviderOf_Payee: TDataSetProvider;
    Payee: TClientDataSet;
    DataSourceOf_Payee: TDataSource;

    btnNextMonth: TSpeedButton;
    pnlMonth: TPanel;
    btnPrevMonth: TSpeedButton;
    btnLookupProfile: TButton;
    btnSelectMonth: TButton;

    gridView: TDBGrid;
    radShowEnabled: TRadioButton;
    radShowDisabled: TRadioButton;
    lblCounter: TLabel;

    bvlBorder: TBevel;

    btnSelect: TButton;
    btnPayback: TButton;
    btnDelete: TButton;

    btnAutoPayback: TButton;

    Shortcuts: TActionList;
    Shortcut_SelectMonth: TAction;
    Shortcut_Lookup: TAction;

    procedure Selector_Change(Sender: TObject);

    procedure btnPrevMonth_Click(Sender: TObject);
    procedure btnNextMonth_Click(Sender: TObject);
    procedure btnSelectMonth_Click(Sender: TObject);

    procedure btnLookupProfile_Click(Sender: TObject);

    procedure gridView_TitleClick(Column: TColumn);

    procedure btnSelect_Click(Sender: TObject);
    procedure btnPayback_Click(Sender: TObject);
    procedure btnDelete_Click(Sender: TObject);

    procedure btnAutoPayback_Click(Sender: TObject);

    procedure Report_MenuSetup( MenuRegistrar : TMenuRegistrar); override;
    procedure Report_Paybacks(Sender: TObject);
    procedure Report_Pressrun(Sender: TObject);
    procedure Report_NameLabels(Sender: TObject);

  private
    { Private 錾 }
    FTargetMonth : TDate;
    FClosingDay : Integer;

    function MonthFirstday() : TDate;
    function MonthLastday() : TDate;

    function PaybackKey() : Integer;
    function ProfileKey() : Integer;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
    procedure AfterNotify(); override;
  public
    { Public 錾 }
  end;

var
  PaybackWorkspace: TPaybackWorkspace;

implementation

{$R *.dfm}

uses Chooser_Date, Chooser_Server, Set_Server,
     Set_Payback,
     Toolbox_GeneratePaybacks,
     Report_Paybacks,
     Publisher_Paybacks,
     Publisher_PaybackLabels;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function TPaybackWorkspace.MonthFirstday() : TDate;
begin
	result := IncDay( IncMonth( MonthLastday, -1));
end;

function TPaybackWorkspace.MonthLastday() : TDate;
begin
	result := RecodeDay( FTargetMonth, Min( FClosingDay, DaysInMonth( FTargetMonth)));
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function TPaybackWorkspace.PaybackKey() : Integer;
begin
	if Payee.IsEmpty then
		result := -1
	else
		result := Payee.FieldByName( 'keyPayback').AsInteger;
end;

function TPaybackWorkspace.ProfileKey() : Integer;
begin
	if Payee.IsEmpty then
		result := -1
	else
		result := Payee.FieldByName( 'keyInstance').AsInteger;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackWorkspace.BeforePopup();
begin
	Center.Open;
	FTargetMonth := Today;
	FClosingDay := Center.FieldByName( 'intPaybackClosingDay').AsInteger;
	Center.Close;

	SortByDefault( gridView);
	Selector_Change( self);
end;

procedure TPaybackWorkspace.AfterPopup();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackWorkspace.Selector_Change(Sender: TObject);
var
	Position : TDataSetPosition;
begin
	DisableGridSet( gridView, Position);
	Payee.Close;
	SourceOf_Payee.ParamByName( 'datFrom').AsDate := MonthFirstday;
	SourceOf_Payee.ParamByName( 'datTo').AsDate := MonthLastday;
	SourceOf_Payee.ParamByName( 'typStatus').AsInteger := BoolToInt( radShowDisabled.Checked);
	Payee.Open;
	EnableGridSet( gridView, Position);
	// update query

	pnlMonth.Caption := Format( '%s ` %s', [
		FormatDateTime( 'gg ee "N" yyyy "N" MM "" dd ""', MonthFirstday),
		FormatDateTime( 'MM "" dd ""', MonthLastday)
	]);
	lblCounter.Caption := 'vF' + IntToStr( Payee.RecordCount) + ' ';

	btnSelect.Enabled := not Payee.IsEmpty;
	btnDelete.Enabled := btnSelect.Enabled;
	// update control
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackWorkspace.btnPrevMonth_Click(Sender: TObject);
begin
	FTargetMonth := IncMonth( FTargetMonth, -1);
	Selector_Change( btnPrevMonth);
end;

procedure TPaybackWorkspace.btnNextMonth_Click(Sender: TObject);
begin
	FTargetMonth := IncMonth( FTargetMonth);
	Selector_Change( btnNextMonth);
end;

procedure TPaybackWorkspace.btnSelectMonth_Click(Sender: TObject);
begin
	if ChooseMonth( FTargetMonth, FTargetMonth) then
	begin
		Selector_Change( btnSelectMonth);
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackWorkspace.btnLookupProfile_Click(Sender: TObject);
var
	keyServer : Integer;
begin
	if ChooseServer( DataStore.MainTransaction, MonthLastday, keyServer) then
	begin
		Payee.Locate( 'keyInstance', keyServer, []);
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackWorkspace.gridView_TitleClick(Column: TColumn);
var
	ACol : Integer;
begin
	if Column.Title.Color = clMenu then exit;

	if Column.FieldName = 'STRCODE' then Payee.IndexFieldNames := 'strCode;datPublished';
	if Column.FieldName = 'STRNAMEREAD' then Payee.IndexFieldNames := 'strNameRead;strCode;datPublished';
	if Column.FieldName = 'INTPRICEPERPOINT' then Payee.IndexFieldNames := 'intPricePerPoint;strNameRead;strCode;datPublished';
	if Column.FieldName = 'CURCAREPOINT' then Payee.IndexFieldNames := 'curCarePoint;strNameRead;strCode;datPublished';
	if Column.FieldName = 'CURMENAGEPOINT' then Payee.IndexFieldNames := 'curMenagePoint;strNameRead;strCode;datPublished';
	if Column.FieldName = 'CURMIGRATIONPOINT' then Payee.IndexFieldNames := 'curMigrationPoint;strNameRead;strCode;datPublished';
	if Column.FieldName = 'CURTRANSFERPOINT' then Payee.IndexFieldNames := 'curTransferPoint;strNameRead;strCode;datPublished';
	if Column.FieldName = 'INTMARGIN' then Payee.IndexFieldNames := 'intMargin;strNameRead;strCode;datPublished';
	if Column.FieldName = 'INTPAYBACK' then Payee.IndexFieldNames := 'intPayback;strNameRead;strCode;datPublished';
	if Column.FieldName = 'DATPUBLISHED' then Payee.IndexFieldNames := 'datPublished;strNameRead;strCode';

	with gridView.Columns do for ACol := 0 to Count - 1 do Items[ ACol].Color := clWindow;

	Column.Color := clSorted;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackWorkspace.btnSelect_Click(Sender: TObject);
begin
	TPaybackSet.Prepare.Browse( PaybackKey);
end;

procedure TPaybackWorkspace.btnPayback_Click(Sender: TObject);
begin
	TPaybackSet.Prepare( IncMonth( MonthFirstday, -1), IncDay( MonthFirstday, -1), Today, ProfileKey).Append;
	Payee.Next;
end;

procedure TPaybackWorkspace.btnDelete_Click(Sender: TObject);
begin
	TPaybackSet.Prepare.Delete( PaybackKey);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackWorkspace.btnAutoPayback_Click(Sender: TObject);
begin
	GeneratePaybacks( IncMonth( MonthFirstday, -1), IncDay( MonthFirstday, -1));
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackWorkspace.Report_MenuSetup( MenuRegistrar : TMenuRegistrar);
begin
	MenuRegistrar( 'Z׈ꗗ̈(&O)', Report_Paybacks, ( not Payee.IsEmpty));
	MenuRegistrar( 'Zׂ̈ꊇ(&P)', Report_Pressrun, ( not Payee.IsEmpty));
	MenuRegistrar( 'V[̈(&N)', Report_NameLabels, ( not Payee.IsEmpty));
end;

procedure TPaybackWorkspace.Report_Paybacks(Sender: TObject);
begin
	TPaybacksReport.Prepare( MonthFirstday, MonthLastday, Payee.IndexFieldNames).Preview;
end;

procedure TPaybackWorkspace.Report_Pressrun(Sender: TObject);
begin
	TPaybacksPublisher.Prepare( MonthFirstday, MonthLastday).Popup;
end;

procedure TPaybackWorkspace.Report_NameLabels(Sender: TObject);
begin
	TPaybackLabelsPublisher.Prepare( MonthFirstday, MonthLastday).Popup;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaybackWorkspace.AfterNotify();
begin
	if Happened( 'Center_Update') then
	begin
		Center.Open;
		FClosingDay := Center.FieldByName( 'intPaybackClosingDay').AsInteger;
		Center.Close;
	end;

	Selector_Change( self);
end;

end.
