unit Workspace_Payment;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, DB, IBCustomDataSet, IBQuery, IBEvents, StdCtrls, Grids,
  DBGrids, ExtCtrls, IB, IBErrorCodes, IBDatabase, DateUtils, Buttons,
  DBClient, Provider, Math, ComCtrls, ActnList, DBCtrls,
  MainDatastore, Misc_Constants, Misc_Utilities, Base_Workspace,
  Frame_ServerPrivateTable, Frame_ServerPrivateGraph, Base_Frame;

type
  TPaymentWorkspace = class(TWorkspaceTemplate)
    Center: TIBQuery;

    SourceOf_Payee: TIBQuery;
    ProviderOf_Payee: TDataSetProvider;
    Payee: TClientDataSet;
    DataSourceOf_Payee: TDataSource;

    btnNextMonth: TSpeedButton;
    pnlMonth: TPanel;
    btnPrevMonth: TSpeedButton;
    btnSelectMonth: TButton;
    btnLookupProfile: TButton;

    gridView: TDBGrid;

    lblCounter: TLabel;
    radShowEnabled: TRadioButton;
    radShowDisabled: TRadioButton;

    bvlBorder: TBevel;

    btnSelect: TButton;
    btnPayment: TButton;
    btnDelete: TButton;

    btnAutoPayment: TButton;

    Shortcuts: TActionList;
    Shortcut_SelectMonth: TAction;
    Shortcut_Lookup: TAction;

    procedure Selector_Change(Sender: TObject);

    procedure btnPrevMonth_Click(Sender: TObject);
    procedure btnNextMonth_Click(Sender: TObject);
    procedure btnSelectMonth_Click(Sender: TObject);

    procedure btnLookupProfile_Click(Sender: TObject);

    procedure gridView_TitleClick(Column: TColumn);

    procedure btnSelect_Click(Sender: TObject);
    procedure btnPayment_Click(Sender: TObject);
    procedure btnDelete_Click(Sender: TObject);

    procedure btnAutoPayment_Click(Sender: TObject);

    procedure Report_MenuSetup( MenuRegistrar : TMenuRegistrar); override;
    procedure Report_Payments(Sender: TObject);
    procedure Report_Pressrun(Sender: TObject);
    procedure Report_NameLabels(Sender: TObject);

  private
    { Private 錾 }
    FTargetMonth : TDate;
    FClosingDay : Integer;

    function MonthFirstday() : TDate;
    function MonthLastday() : TDate;

    function PaymentKey() : Integer;
    function ProfileKey() : Integer;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
    procedure AfterNotify(); override;
  public
    { Public 錾 }
  end;

var
  PaymentWorkspace: TPaymentWorkspace;

implementation

{$R *.dfm}

uses Chooser_Date, Chooser_Server, Set_Server,
     Set_Payment,
     Toolbox_GeneratePayments,
     Report_Payments,
     Publisher_Payments,
     Publisher_PaymentLabels;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function TPaymentWorkspace.MonthFirstday() : TDate;
begin
	result := IncDay( IncMonth( MonthLastday, -1));
end;

function TPaymentWorkspace.MonthLastday() : TDate;
begin
	result := RecodeDay( FTargetMonth, Min( FClosingDay, DaysInMonth( FTargetMonth)));
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function TPaymentWorkspace.PaymentKey() : Integer;
begin
	if Payee.IsEmpty then
		result := -1
	else
		result := Payee.FieldByName( 'keyPayment').AsInteger;
end;

function TPaymentWorkspace.ProfileKey() : Integer;
begin
	if Payee.IsEmpty then
		result := -1
	else
		result := Payee.FieldByName( 'keyInstance').AsInteger;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentWorkspace.BeforePopup();
begin
	Center.Open;
	FTargetMonth := Today;
	FClosingDay := Center.FieldByName( 'intPaymentClosingDay').AsInteger;
	Center.Close;

	SortByDefault( gridView);
	Selector_Change( self);
end;

procedure TPaymentWorkspace.AfterPopup();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentWorkspace.Selector_Change(Sender: TObject);
var
	Position : TDataSetPosition;
begin
	DisableGridSet( gridView, Position);
	Payee.Close;
	SourceOf_Payee.ParamByName( 'datFrom').AsDate := MonthFirstday;
	SourceOf_Payee.ParamByName( 'datTo').AsDate := MonthLastday;
	SourceOf_Payee.ParamByName( 'typStatus').AsInteger := BoolToInt( radShowDisabled.Checked);
	Payee.Open;
	EnableGridSet( gridView, Position);
	// update query

	pnlMonth.Caption := Format( '%s ` %s', [
		FormatDateTime( 'gg ee "N" yyyy "N" MM "" dd ""', MonthFirstday),
		FormatDateTime( 'MM "" dd ""', MonthLastday)
	]);
	lblCounter.Caption := 'vF' + IntToStr( Payee.RecordCount) + ' ';

	btnSelect.Enabled := not Payee.IsEmpty;
	btnDelete.Enabled := btnSelect.Enabled;
	// update control
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentWorkspace.btnPrevMonth_Click(Sender: TObject);
begin
	FTargetMonth := IncMonth( FTargetMonth, -1);
	Selector_Change( btnPrevMonth);
end;

procedure TPaymentWorkspace.btnNextMonth_Click(Sender: TObject);
begin
	FTargetMonth := IncMonth( FTargetMonth);
	Selector_Change( btnNextMonth);
end;

procedure TPaymentWorkspace.btnSelectMonth_Click(Sender: TObject);
begin
	if ChooseMonth( FTargetMonth, FTargetMonth) then
	begin
		Selector_Change( btnSelectMonth);
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentWorkspace.btnLookupProfile_Click(Sender: TObject);
var
	keyServer : Integer;
begin
	if ChooseServer( DataStore.MainTransaction, MonthLastday, keyServer) then
	begin
		Payee.Locate( 'keyInstance', keyServer, []);
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentWorkspace.gridView_TitleClick(Column: TColumn);
var
	ACol : Integer;
begin
	if Column.Title.Color = clMenu then exit;

	if Column.FieldName = 'STRCODE' then Payee.IndexFieldNames := 'strCode;datPublished';
	if Column.FieldName = 'STRNAMEREAD' then Payee.IndexFieldNames := 'strNameRead;strCode;datPublished';
	if Column.FieldName = 'INTCARECASH' then Payee.IndexFieldNames := 'intCareCash;strNameRead;strCode;datPublished';
	if Column.FieldName = 'INTMENAGECASH' then Payee.IndexFieldNames := 'intMenageCash;strNameRead;strCode;datPublished';
	if Column.FieldName = 'INTMIGRATIONCASH' then Payee.IndexFieldNames := 'intMigrationCash;strNameRead;strCode;datPublished';
	if Column.FieldName = 'INTTRANSFERCASH' then Payee.IndexFieldNames := 'intTransferCash;strNameRead;strCode;datPublished';
	if Column.FieldName = 'INTMARGIN' then Payee.IndexFieldNames := 'intMargin;strNameRead;strCode;datPublished';
	if Column.FieldName = 'INTPAYMENT' then Payee.IndexFieldNames := 'intPayment;strNameRead;strCode;datPublished';
	if Column.FieldName = 'DATPUBLISHED' then Payee.IndexFieldNames := 'datPublished;strNameRead;strCode';

	with gridView.Columns do for ACol := 0 to Count - 1 do Items[ ACol].Color := clWindow;

	Column.Color := clSorted;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentWorkspace.btnSelect_Click(Sender: TObject);
begin
	TPaymentSet.Prepare.Browse( PaymentKey);
end;

procedure TPaymentWorkspace.btnPayment_Click(Sender: TObject);
begin
	TPaymentSet.Prepare( IncMonth( MonthFirstday, -1), IncDay( MonthFirstday, -1), Today, ProfileKey).Append;
	Payee.Next;
end;

procedure TPaymentWorkspace.btnDelete_Click(Sender: TObject);
begin
	TPaymentSet.Prepare.Delete( PaymentKey);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentWorkspace.btnAutoPayment_Click(Sender: TObject);
begin
	GeneratePayments( IncMonth( MonthFirstday, -1), IncDay( MonthFirstday, -1));
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentWorkspace.Report_MenuSetup( MenuRegistrar : TMenuRegistrar);
begin
	MenuRegistrar( 'Z׈ꗗ̈(&O)', Report_Payments, ( not Payee.IsEmpty));
	MenuRegistrar( 'Zׂ̈ꊇ(&P)', Report_Pressrun, ( not Payee.IsEmpty));
	MenuRegistrar( 'V[̈(&N)', Report_NameLabels, ( not Payee.IsEmpty));
end;

procedure TPaymentWorkspace.Report_Payments(Sender: TObject);
begin
	TPaymentsReport.Prepare( MonthFirstday, MonthLastday, Payee.IndexFieldNames).Preview;
end;

procedure TPaymentWorkspace.Report_Pressrun(Sender: TObject);
begin
	TPaymentsPublisher.Prepare( MonthFirstday, MonthLastday).Popup;
end;

procedure TPaymentWorkspace.Report_NameLabels(Sender: TObject);
begin
	TPaymentLabelsPublisher.Prepare( MonthFirstday, MonthLastday).Popup;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TPaymentWorkspace.AfterNotify();
begin
	if Happened( 'Center_Update') then
	begin
		Center.Open;
		FClosingDay := Center.FieldByName( 'intPaymentClosingDay').AsInteger;
		Center.Close;
	end;

	Selector_Change( self);
end;

end.
