unit Workspace_Regions;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, DB, IBCustomDataSet, IBQuery, IBEvents, StdCtrls, Grids,
  DBGrids, ExtCtrls, IB, IBErrorCodes, IBDatabase, DBCtrls,
  Provider, DBClient, Math, ActnList, DateUtils, MainDatastore, ComCtrls,
  Misc_Constants, Misc_Utilities, Base_Workspace;

type
  TRegionsWorkspace = class(TWorkspaceTemplate)

    SourceOf_Region: TIBQuery;
    ProviderOf_Region: TDataSetProvider;
    Region: TClientDataSet;
    DataSourceOf_Region: TDataSource;

    gridView: TDBGrid;
    radShowAvailable: TRadioButton;
    radShowDisabled: TRadioButton;
    radShowUnavailable: TRadioButton;
    lblCounter: TLabel;
    bvlBorder: TBevel;

    btnSelect: TButton;
    btnAppend: TButton;
    btnDelete: TButton;
    btnRestore: TButton;

    procedure Selector_Change(Sender: TObject);

    procedure gridView_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);

    procedure btnSelect_Click(Sender: TObject);
    procedure btnAppend_Click(Sender: TObject);
    procedure btnDelete_Click(Sender: TObject);
    procedure btnRestore_Click(Sender: TObject);

    procedure Report_MenuSetup( MenuRegistrar : TMenuRegistrar); override;
    procedure Report_Regions(Sender: TObject);

  private
    { Private 錾 }
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
    procedure AfterNotify(); override;
  public
    { Public 錾 }
  end;

var
  RegionsWorkspace: TRegionsWorkspace;

implementation

{$R *.dfm}

uses Set_Region, Report_Regions;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TRegionsWorkspace.BeforePopup();
begin
	Region.Open;

	SortByDefault( gridView);
	Selector_Change( self);
end;

procedure TRegionsWorkspace.AfterPopup();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TRegionsWorkspace.Selector_Change(Sender: TObject);
begin
	Region.Filter := CatalogueFilter( radShowAvailable, radShowUnavailable, radShowDisabled);

	lblCounter.Caption := 'vF' + IntToStr( Region.RecordCount) + ' ';

	btnSelect.Enabled := ( not Region.IsEmpty);
	btnDelete.Enabled := ( not Region.IsEmpty) and ( not radShowDisabled.Checked);
	btnRestore.Enabled := ( not Region.IsEmpty) and radShowDisabled.Checked;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TRegionsWorkspace.gridView_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
begin
	with Column do if ( PickList.Count > 0) and ( not Field.IsNull) then
	begin
		gridView.Canvas.TextRect(
			Rect, Rect.Left + 2, Rect.Top + 2, PickList[ Field.AsInteger]
		);
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TRegionsWorkspace.btnSelect_Click(Sender: TObject);
begin
	if not radShowDisabled.Checked then
		TRegionSet.Prepare.Select( ReadInstanceKey( Region))
	else
		TRegionSet.Prepare.Browse( ReadInstanceKey( Region));
end;

procedure TRegionsWorkspace.btnAppend_Click(Sender: TObject);
begin
	TRegionSet.Prepare.Append;
end;

procedure TRegionsWorkspace.btnDelete_Click(Sender: TObject);
begin
	TRegionSet.Prepare.Delete( ReadInstanceKey( Region));
end;

procedure TRegionsWorkspace.btnRestore_Click(Sender: TObject);
begin
	TRegionSet.Prepare.Restore( ReadInstanceKey( Region));
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TRegionsWorkspace.Report_MenuSetup( MenuRegistrar : TMenuRegistrar);
begin
	MenuRegistrar( 'Znꗗ̈(&P)', Report_Regions, ( not Region.IsEmpty));
end;

procedure TRegionsWorkspace.Report_Regions(Sender: TObject);
begin
	TRegionsReport.Prepare( CatalogueType( radShowAvailable, radShowUnavailable, radShowDisabled)).Preview;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TRegionsWorkspace.AfterNotify();
var
	Position : TDataSetPosition;
begin
	DisableGridSet( gridView, Position);
	Region.Refresh;
	Selector_Change( self);
	EnableGridSet( gridView, Position);
end;

end.
