unit Workspace_Services;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, DB, IBCustomDataSet, IBQuery, IBEvents, StdCtrls, Grids,
  DBGrids, ExtCtrls, IB, IBErrorCodes, IBDatabase, DBCtrls, StrUtils,
  Provider, DBClient, Math, ActnList, DateUtils, ComCtrls, MainDatastore,
  Misc_Constants, Misc_Utilities, Base_Workspace;

type
  TServicesWorkspace = class(TWorkspaceTemplate)

    SourceOf_Service: TIBQuery;
    ProviderOf_Service: TDataSetProvider;
    Service: TClientDataSet;
    DataSourceOf_Service: TDataSource;

    gridView: TDBGrid;
    radShowAvailable: TRadioButton;
    radShowDisabled: TRadioButton;
    radShowUnavailable: TRadioButton;
    lblCounter: TLabel;
    bvlBorder: TBevel;

    btnSelect: TButton;
    btnAppend: TButton;
    btnDelete: TButton;
    btnRestore: TButton;

    procedure Selector_Change(Sender: TObject);

    procedure gridView_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);

    procedure btnSelect_Click(Sender: TObject);
    procedure btnAppend_Click(Sender: TObject);
    procedure btnDelete_Click(Sender: TObject);
    procedure btnRestore_Click(Sender: TObject);

    procedure Report_MenuSetup( MenuRegistrar : TMenuRegistrar); override;
    procedure Report_Services(Sender: TObject);

  private
    { Private 錾 }
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
    procedure AfterNotify(); override;
  public
    { Public 錾 }
  end;

var
  ServicesWorkspace: TServicesWorkspace;

implementation

{$R *.dfm}

uses Set_Service, Report_Services;

{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServicesWorkspace.BeforePopup();
begin
	Service.Open;

	SortByDefault( gridView);
	Selector_Change( self);
end;

procedure TServicesWorkspace.AfterPopup();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServicesWorkspace.Selector_Change(Sender: TObject);
begin
	Service.Filter := CatalogueFilter( radShowAvailable, radShowUnavailable, radShowDisabled);

	lblCounter.Caption := 'vF' + IntToStr( Service.RecordCount) + ' ';

	btnSelect.Enabled := ( not Service.IsEmpty);
	btnDelete.Enabled := ( not Service.IsEmpty) and ( not radShowDisabled.Checked);
	btnRestore.Enabled := ( not Service.IsEmpty) and radShowDisabled.Checked;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServicesWorkspace.gridView_DrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
begin
	if Column.Field.IsNull then exit;

	with Column do if Field.FieldName = 'OPTAVAILABILITY' then
	begin
		gridView.Canvas.TextRect(
			Rect,
			Rect.Left + 2,
			Rect.Top + 2,
			Format( '%s%s%s%s%s%s%s', [
				IfThen( ( Field.AsInteger and SUNDAY_AVAILABLE) <> 0,'', '~'),
				IfThen( ( Field.AsInteger and MONDAY_AVAILABLE) <> 0,'', '~'),
				IfThen( ( Field.AsInteger and TUESDAY_AVAILABLE) <> 0,'', '~'),
				IfThen( ( Field.AsInteger and WEDNESDAY_AVAILABLE) <> 0,'', '~'),
				IfThen( ( Field.AsInteger and THURSDAY_AVAILABLE) <> 0,'', '~'),
				IfThen( ( Field.AsInteger and FRIDAY_AVAILABLE) <> 0,'', '~'),
				IfThen( ( Field.AsInteger and SATURDAY_AVAILABLE) <> 0,'y', '~')
			])
		);
		exit;
	end;

	with Column do if ( PickList.Count > 0) and ( not Field.IsNull) then
	begin
		gridView.Canvas.TextRect(
			Rect, Rect.Left + 2, Rect.Top + 2, PickList[ Field.AsInteger]
		);
		exit;
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServicesWorkspace.btnSelect_Click(Sender: TObject);
begin
	if not radShowDisabled.Checked then
		TServiceSet.Prepare.Select( ReadInstanceKey( Service))
	else
		TServiceSet.Prepare.Browse( ReadInstanceKey( Service));
end;

procedure TServicesWorkspace.btnAppend_Click(Sender: TObject);
begin
	TServiceSet.Prepare.Append;
end;

procedure TServicesWorkspace.btnDelete_Click(Sender: TObject);
begin
	TServiceSet.Prepare.Delete( ReadInstanceKey( Service));
end;

procedure TServicesWorkspace.btnRestore_Click(Sender: TObject);
begin
	TServiceSet.Prepare.Restore( ReadInstanceKey( Service));
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServicesWorkspace.Report_MenuSetup( MenuRegistrar : TMenuRegistrar);
begin
	MenuRegistrar( 'T[rXꗗ̈(&P)', Report_Services, ( not Service.IsEmpty));
end;

procedure TServicesWorkspace.Report_Services(Sender: TObject);
begin
	TServicesReport.Prepare( CatalogueType( radShowAvailable, radShowUnavailable, radShowDisabled)).Preview;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TServicesWorkspace.AfterNotify();
var
	Position : TDataSetPosition;
begin
	DisableGridSet( gridView, Position);
	Service.Refresh;
	Selector_Change( self);
	EnableGridSet( gridView, Position);
end;

end.
