unit Workspace_Ticket;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, DB, IBCustomDataSet, IBQuery, IBEvents, StdCtrls, Grids,
  DBGrids, ExtCtrls, IB, IBErrorCodes, IBDatabase, DateUtils, Buttons,
  DBClient, Provider, Math, ComCtrls, ActnList, DBCtrls,
  MainDatastore, Misc_Constants, Misc_Utilities, Base_Workspace,
  Frame_ClientPrivateTable, Frame_ClientPrivateGraph, Base_Frame;

type
  TTicketWorkspace = class(TWorkspaceTemplate)
    Center: TIBQuery;

    SourceOf_Payer: TIBQuery;
    ProviderOf_Payer: TDataSetProvider;
    Payer: TClientDataSet;
    DataSourceOf_Payer: TDataSource;

    btnNextMonth: TSpeedButton;
    pnlMonth: TPanel;
    btnPrevMonth: TSpeedButton;
    btnSelectMonth: TButton;
    btnLookupProfile: TButton;

    gridView: TDBGrid;

    lblCounter: TLabel;
    radShowEnabled: TRadioButton;
    radShowDisabled: TRadioButton;

    bvlBorder: TBevel;

    btnSelect: TButton;
    btnTicket: TButton;
    btnDelete: TButton;

    Shortcuts: TActionList;
    Shortcut_SelectMonth: TAction;
    Shortcut_Lookup: TAction;

    procedure Selector_Change(Sender: TObject);

    procedure btnPrevMonth_Click(Sender: TObject);
    procedure btnNextMonth_Click(Sender: TObject);
    procedure btnSelectMonth_Click(Sender: TObject);

    procedure btnLookupProfile_Click(Sender: TObject);

    procedure gridView_TitleClick(Column: TColumn);

    procedure btnSelect_Click(Sender: TObject);
    procedure btnTicket_Click(Sender: TObject);
    procedure btnDelete_Click(Sender: TObject);

    procedure Report_MenuSetup( MenuRegistrar : TMenuRegistrar); override;
    procedure Report_Tickets(Sender: TObject);
    procedure Report_Pressrun(Sender: TObject);
    procedure Report_NameLabels(Sender: TObject);

  private
    { Private 錾 }
    FTargetMonth : TDate;
    FClosingDay : Integer;

    function MonthFirstday() : TDate;
    function MonthLastday() : TDate;

    function TicketKey() : Integer;
  protected
    { Protected 錾 }
    procedure BeforePopup(); override;
    procedure AfterPopup(); override;
    procedure AfterNotify(); override;
  public
    { Public 錾 }
  end;

var
  TicketWorkspace: TTicketWorkspace;

implementation

{$R *.dfm}

uses Chooser_Date, Chooser_Client, Set_Client,
     Set_Ticket,
     Report_Tickets,
     Publisher_TicketLabels,
     Publisher_Tickets;

{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function TTicketWorkspace.MonthFirstday() : TDate;
begin
	result := IncDay( IncMonth( MonthLastday, -1));
end;

function TTicketWorkspace.MonthLastday() : TDate;
begin
	result := RecodeDay( FTargetMonth, Min( FClosingDay, DaysInMonth( FTargetMonth)));
end;


{*=========================================================*
  @subject: 
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

function TTicketWorkspace.TicketKey() : Integer;
begin
	if Payer.IsEmpty then
		result := -1
	else
		result := Payer.FieldByName( 'keyTicket').AsInteger;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketWorkspace.BeforePopup();
begin
	Center.Open;
	FTargetMonth := Today;
	FClosingDay := Center.FieldByName( 'intPaymentClosingDay').AsInteger;
	Center.Close;

	SortByDefault( gridView);
	Selector_Change( self);
end;

procedure TTicketWorkspace.AfterPopup();
begin
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketWorkspace.Selector_Change(Sender: TObject);
var
	Position : TDataSetPosition;
begin
	DisableGridSet( gridView, Position);
	Payer.Close;
	SourceOf_Payer.ParamByName( 'datMonthFirstday').AsDate := MonthFirstday;
	SourceOf_Payer.ParamByName( 'datMonthLastday').AsDate := MonthLastday;
	SourceOf_Payer.ParamByName( 'typStatus').AsInteger := BoolToInt( radShowDisabled.Checked);
	Payer.Open;
	EnableGridSet( gridView, Position);
	// update query

	pnlMonth.Caption := Format( '%s ` %s', [
		FormatDateTime( 'gg ee "N" yyyy "N" MM "" dd ""', MonthFirstday),
		FormatDateTime( 'MM "" dd ""', MonthLastday)
	]);
	lblCounter.Caption := 'vF' + IntToStr( Payer.RecordCount) + ' ';

	btnSelect.Enabled := ( not Payer.IsEmpty);
	btnDelete.Enabled := btnSelect.Enabled;
	// update control
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketWorkspace.btnPrevMonth_Click(Sender: TObject);
begin
	FTargetMonth := IncMonth( FTargetMonth, -1);
	Selector_Change( btnPrevMonth);
end;

procedure TTicketWorkspace.btnNextMonth_Click(Sender: TObject);
begin
	FTargetMonth := IncMonth( FTargetMonth);
	Selector_Change( btnNextMonth);
end;

procedure TTicketWorkspace.btnSelectMonth_Click(Sender: TObject);
begin
	if ChooseMonth( FTargetMonth, FTargetMonth) then
	begin
		Selector_Change( btnSelectMonth);
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketWorkspace.btnLookupProfile_Click(Sender: TObject);
var
	keyClient : Integer;
begin
	if ChooseClient( DataStore.MainTransaction, MonthLastday, keyClient) then
	begin
		Payer.Locate( 'keyInstance', keyClient, []);
	end;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketWorkspace.gridView_TitleClick(Column: TColumn);
var
	ACol : Integer;
begin
	if Column.Title.Color = clMenu then exit;

	if Column.FieldName = 'STRCODE' then Payer.IndexFieldNames := 'strCode;datPublished';
	if Column.FieldName = 'STRNAMEREAD' then Payer.IndexFieldNames := 'strNameRead;strCode;datPublished';
	if Column.FieldName = 'INTPRICEPERPOINT' then Payer.IndexFieldNames := 'intPricePerPoint;strNameRead;strCode;datPublished';
	if Column.FieldName = 'CURPOINT' then Payer.IndexFieldNames := 'curPoint;strNameRead;strCode;datPublished';
	if Column.FieldName = 'INTMARGIN' then Payer.IndexFieldNames := 'intMargin;strNameRead;strCode;datPublished';
	if Column.FieldName = 'INTBORROW' then Payer.IndexFieldNames := 'intBorrow;strNameRead;strCode;datPublished';
	if Column.FieldName = 'DATPUBLISHED' then Payer.IndexFieldNames := 'datPublished;strNameRead;strCode';

	with gridView.Columns do for ACol := 0 to Count - 1 do Items[ ACol].Color := clWindow;

	Column.Color := clSorted;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketWorkspace.btnSelect_Click(Sender: TObject);
begin
	TTicketSet.Prepare.Browse( TicketKey);
end;

procedure TTicketWorkspace.btnTicket_Click(Sender: TObject);
begin
	TTicketSet.Prepare( Today).Append;
end;

procedure TTicketWorkspace.btnDelete_Click(Sender: TObject);
begin
	TTicketSet.Prepare.Delete( TicketKey);
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketWorkspace.Report_MenuSetup( MenuRegistrar : TMenuRegistrar);
begin
	MenuRegistrar( 's׈ꗗ̈(&O)', Report_Tickets, ( not Payer.IsEmpty));
	MenuRegistrar( 'sׂ̈ꊇ(&P)', Report_Pressrun, ( not Payer.IsEmpty));
	MenuRegistrar( 'V[̈(&N)', Report_NameLabels, ( not Payer.IsEmpty));
end;

procedure TTicketWorkspace.Report_Tickets(Sender: TObject);
begin
	TTicketsReport.Prepare( MonthFirstday, MonthLastday, Payer.IndexFieldNames).Preview;
end;

procedure TTicketWorkspace.Report_Pressrun(Sender: TObject);
begin
	TTicketsPublisher.Prepare( MonthFirstday, MonthLastday).Popup;
end;

procedure TTicketWorkspace.Report_NameLabels(Sender: TObject);
begin
	TTicketLabelsPublisher.Prepare( MonthFirstday, MonthLastday).Popup;
end;


{*=========================================================*
  @subject:
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*}

procedure TTicketWorkspace.AfterNotify();
begin
	if Happened( 'Center_Update') then
	begin
		Center.Open;
		FClosingDay := Center.FieldByName( 'intPaymentClosingDay').AsInteger;
		Center.Close;
	end;

	Selector_Change( self);
end;

end.
