
/*******************************************************************************
  @file: Catalogue_Utility.sql
  @subject: miscellaneous definition for catalogue tables
  @update: 2004/05/08 (Sat) 00:00:00
  = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
 *******************************************************************************/

INPUT 'Locator.sql';

/*=========================================================*
  @subject: table definition - Dummy
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

CREATE TABLE Dummy (
	DATE_VALUE  DATE DEFAULT CURRENT_DATE,
	TIME_VALUE  TIME DEFAULT CURRENT_TIME,
	TIMESTAMP_VALUE  TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	INTEGER_VALUE  INTEGER DEFAULT 0,
	DECIMAL_VALUE  DOUBLE PRECISION DEFAULT 0,
	BOOLEAN_TRUE  BOOLEAN DEFAULT 1,
	BOOLEAN_FALSE  BOOLEAN DEFAULT 1,
	SHORT_STRING_VALUE  CHAR(32),
	MEDIUM_STRING_VALUE  CHAR(64),
	LONG_STRING_VALUE  CHAR(128),
	REFERENCE_VALUE  INTEGER DEFAULT 0
);


/*=========================================================*
  @subject: procedure definition - Branches, Regions
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

SET TERM !! ;
RECREATE PROCEDURE Branches ( datAt  DATE) RETURNS ( keyInstance  INTEGER, strName  VARCHAR(32)) AS
	BEGIN
		keyInstance = -1;
		strName = 'ׂ';
		SUSPEND;

		FOR SELECT
			keyInstance, strName

		FROM Branch
			WHERE typStatus = 0 /* DATA_ENABLED */
			and ( :datAt IS NULL or :datAt BETWEEN datAvailableFrom and datAvailableTo)

		ORDER BY strName
		INTO :keyInstance, :strName
		DO
		BEGIN
			SUSPEND;
		END
	END !!
SET TERM ; !!

SET TERM !! ;
RECREATE PROCEDURE Regions ( datAt  DATE) RETURNS ( keyInstance  INTEGER, strName  VARCHAR(32)) AS
	BEGIN
		keyInstance = -1;
		strName = 'ׂ';
		SUSPEND;

		FOR SELECT
			keyInstance, strName

		FROM Region
			WHERE typStatus = 0 /* DATA_ENABLED */
			and ( :datAt IS NULL or :datAt BETWEEN datAvailableFrom and datAvailableTo)

		ORDER BY strName
		INTO :keyInstance, :strName
		DO
		BEGIN
			SUSPEND;
		END
	END !!
SET TERM ; !!


/*=========================================================*
  @subject: counter - Profile_Generator
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

CREATE GENERATOR Profile_Generator;
SET GENERATOR Profile_Generator TO 0;

SET TERM !! ;
RECREATE PROCEDURE NextProfileKey RETURNS ( nextKey  INTEGER) AS
	BEGIN
		nextKey = gen_id( Profile_Generator, 1);
		SUSPEND;
	END !!
SET TERM ; !!

SET TERM !! ;
RECREATE PROCEDURE CurrProfileKey RETURNS ( currKey  INTEGER) AS
	BEGIN
		currKey = gen_id( Profile_Generator, 0);
		SUSPEND;
	END !!
SET TERM ; !!


/*=========================================================*
  @subject: access permission
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

GRANT SELECT ON Dummy TO User_Client;

GRANT EXECUTE ON PROCEDURE Branches TO User_Client;
GRANT EXECUTE ON PROCEDURE Regions TO User_Client;

GRANT EXECUTE ON PROCEDURE NextProfileKey TO User_Client;
GRANT EXECUTE ON PROCEDURE CurrProfileKey TO User_Client;


