
/*******************************************************************************
  @file: Journal_Privilege.sql
  @subject: access permission for journal tables
  @update: 2004/05/08 (Sat) 00:00:00
  = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
 *******************************************************************************/

INPUT 'Locator.sql';

/*=========================================================*
  @subject: Schedule
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

GRANT INSERT                                     ON Schedule_Selector TO TRIGGER AfterInsert_Schedule;
GRANT                         SELECT, REFERENCES ON Schedule_Selector TO User_Client;
GRANT INSERT, DELETE, UPDATE, SELECT, REFERENCES ON Schedule TO User_Client;
REVOKE UPDATE ( keyInstance, datSchedule, refPattern, refSubject) ON Schedule FROM User_Client;


/*=========================================================*
  @subject: Comment
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

GRANT INSERT                             ON Comment_Selector TO TRIGGER AfterInsert_Comment;
GRANT                 SELECT, REFERENCES ON Comment_Selector TO User_Client;
GRANT INSERT, UPDATE, SELECT, REFERENCES ON Comment TO User_Client;
REVOKE UPDATE ( keyInstance) ON Comment FROM User_Client;


/*=========================================================*
  @subject: Ticket, Payback, Proof
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

GRANT INSERT                                                  ON Ticket_Selector TO TRIGGER AfterInsert_Ticket;
GRANT                                      SELECT, REFERENCES ON Ticket_Selector TO User_Client;
GRANT INSERT, DELETE, UPDATE ( typStatus), SELECT, REFERENCES ON Ticket TO User_Client;

GRANT INSERT                                                  ON Payback_Selector TO TRIGGER AfterInsert_Payback;
GRANT                                      SELECT, REFERENCES ON Payback_Selector TO User_Client;
GRANT INSERT, DELETE, UPDATE ( typStatus), SELECT, REFERENCES ON Payback TO User_Client;

GRANT INSERT                     ON Proof_Selector TO TRIGGER AfterInsert_Proof;
GRANT         SELECT, REFERENCES ON Proof_Selector TO User_Client;
GRANT INSERT, SELECT, REFERENCES ON Proof TO User_Client;


/*=========================================================*
  @subject: Billing, Receipt
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

GRANT INSERT                                                  ON Billing_Selector TO TRIGGER AfterInsert_Billing;
GRANT                                      SELECT, REFERENCES ON Billing_Selector TO User_Client;
GRANT INSERT, DELETE, UPDATE ( typStatus), SELECT, REFERENCES ON Billing TO User_Client;

GRANT INSERT                     ON Receipt_Selector TO TRIGGER AfterInsert_Receipt;
GRANT         SELECT, REFERENCES ON Receipt_Selector TO User_Client;
GRANT INSERT, SELECT, REFERENCES ON Receipt TO User_Client;


/*=========================================================*
  @subject: Payment, Supply
  @update: 2004/05/08 (Sat) 00:00:00
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 *=========================================================*/

GRANT INSERT                                                  ON Payment_Selector TO TRIGGER AfterInsert_Payment;
GRANT                                      SELECT, REFERENCES ON Payment_Selector TO User_Client;
GRANT INSERT, DELETE, UPDATE ( typStatus), SELECT, REFERENCES ON Payment TO User_Client;

GRANT INSERT                     ON Supply_Selector TO TRIGGER AfterInsert_Supply;
GRANT         SELECT, REFERENCES ON Supply_Selector TO User_Client;
GRANT INSERT, SELECT, REFERENCES ON Supply TO User_Client;


