/* 
 * Copyright 2007 Tatooine Project <http://tatooine.sourceforge.jp/> 
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *     http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.tatooine.gtx;

/**
 * GtxSyntaxException.
 *
 * @author  Tooru Noda
 * @version 1.0 2007/04/11
 * @since   JDK5.0 Tiger
 */
public class GtxSyntaxException extends Exception {

	private static final long serialVersionUID = 1L;

	/**
	 * <code>GtxSyntaxException</code>を構築する.
	 */
	public GtxSyntaxException() {
		super();
	}

	/**
	 * <code>GtxSyntaxException</code>を構築する.
	 * 
	 * @param message	例外メッセージ
	 */
	public GtxSyntaxException(String message) {
		super(message);
	}

	/**
	 * <code>GtxSyntaxException</code>を構築する.
	 * 
	 * @param message	例外メッセージ
	 * @param cause		親となる例外
	 */
	public GtxSyntaxException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * <code>GtxSyntaxException</code>を構築する.
	 * 
	 * @param cause		親となる例外
	 */
	public GtxSyntaxException(Throwable cause) {
		super(cause);
	}

}
